from flask import Blueprint, session
from flask.views import MethodView
import json
from scribe.eoleldap import Ldap
from scribe.linker import _user_factory
from eoleauthlib.authclient import login_required

ldappasswordsapi = Blueprint('ldappasswordsapi', __name__, url_prefix = '')

class LdappasswordsAPI(MethodView):
    decorators = [ login_required]

    def __init__(self):
        self.conn = Ldap()
        self.conn.connect()
        self.username = session["username"]

    def get(self, oldpassword):
        """Returns true if you give the oldpassword of username
           Parameters needed :
            in this object : self.username, self.conn
        """
        if self.username is None:
            return json.dumps('Error: You need a username to talk to backend')
        if oldpassword is None:
            return json.dumps('Error: You need a oldpassword to talk to backend')

        ldapusers = _user_factory(self.username, self.conn.connexion)
        return json.dumps(ldapusers.auth(self.username, oldpassword))

    def post(self):
        raise NotImplementedError

    def delete(self):
        raise NotImplementedError


    def put(self, newpassword):
        """Set password of username to newpassword
           Parameters needed :
            in this object : self.username, self.conn
        """
        if self.username is None:
            return json.dumps('Error: You need a username to talk to backend')
        if newpassword is None:
            return json.dumps('Error: You need a newpassword to talk to backend')

        ldapusers = _user_factory(self.username, self.conn.connexion)
        return json.dumps(ldapusers.c_mod_password(self.username, newpassword))

    @classmethod
    def register(cls, mod):
        f = cls.as_view("ldappasswords_api")
        mod.add_url_rule(mod.url_prefix, view_func=f, methods=["GET", "DELETE", "PUT"],
                defaults={"oldpassword": None, "newpassword": None})
        mod.add_url_rule(mod.url_prefix, view_func=f, methods=["POST"])
        mod.add_url_rule('%s<oldpassword>' % mod.url_prefix, view_func=f,
                        methods=['GET', 'DELETE'])
        mod.add_url_rule('%s<newpassword>' % mod.url_prefix, view_func=f,
                        methods=['PUT'])

LdappasswordsAPI.register(ldappasswordsapi)
