from flask import Blueprint, session
from flask.views import MethodView
import json
from scribe.eoleldap import Ldap
from scribe.linker import _user_factory
from eoleauthlib.authclient import login_required

ldapusersapi = Blueprint('ldapusersapi', __name__, url_prefix = '')

class LdapusersAPI(MethodView):
    decorators = [ login_required]

    def __init__(self):
        self.conn = Ldap()
        self.conn.connect()
        self.username = session["username"]

    def get(self, attribute):
        """Returns the given attribute for username in ldap
           Parameters needed :
            in this object : self.username, self.conn
        """
        if self.username is None:
            return json.dumps('Error: You need a username to talk to backend')
        if attribute is None:
            return json.dumps('Error: You need a attribute to talk to backend')

        ldapusers = _user_factory(self.username, self.conn.connexion)
        return json.dumps(ldapusers.get_attr(self.username, str(attribute)))

    def post(self):
        raise NotImplementedError

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("ldapusers_api")
        mod.add_url_rule(mod.url_prefix, view_func=f, methods=["GET", "PUT", "DELETE"],
                defaults={"attribute": None})
        mod.add_url_rule(mod.url_prefix, view_func=f, methods=["POST"])
        mod.add_url_rule('%s<attribute>' % mod.url_prefix, view_func=f,
                        methods=['GET', 'PUT', 'DELETE'])

LdapusersAPI.register(ldapusersapi)
