from flask import Blueprint, current_app, session
from xmlrpclib import ServerProxy
from flask.views import MethodView
import json
from eoleauthlib.authclient import login_required

usersapi = Blueprint('usersapi', __name__, url_prefix = '')

class UsersAPI(MethodView):
    decorators = [ login_required]

    def __init__(self):
        self.username = session["username"]
        self.proxy = ServerProxy(current_app.config['CONTROLEVNC_URL'])
        self.secret = current_app.config['SECRET_KEY']

    def get(self):
        """Returns true if username is a teacher
           Parameters needed :
            in this object : self.secret, self.username
        """
        if self.secret is None:
            #FIXME
            return json.dumps('Error: You need a secret to talk to backend')
        if self.username is None:
            return json.dumps('Error: You need a username to talk to backend')
        return json.dumps(self.proxy.remote_est_prof(self.secret, self.username))

    def post(self):
        raise NotImplementedError

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("users_api")
        mod.add_url_rule(mod.url_prefix, view_func=f, methods=["GET"])
        mod.add_url_rule(mod.url_prefix, view_func=f, methods=["POST"])
        mod.add_url_rule('%s' % mod.url_prefix, view_func=f,
                        methods=['GET', 'PUT', 'DELETE'])

UsersAPI.register(usersapi)
