;(function(){
// wrapper javascript
"use strict";

// variables nb_classe_min et nb_car_min déclarées en global dans le template html

jQuery(document).ready(function ($) {

    // popover permet l'affichage d'une popup pour les infobulle d'aide
    $("a[data-toggle=popover]").popover({html : true}).click(function(e) {e.preventDefault()});

    // Saisie au clavier dans le champ du nouveau mot de passe
    $(document).on("keyup", "#password", function(event){
        var retour = test_mdp($(this).val());

        switch (retour){
            case -1:
                var message = "Mot de passe acceptable.";
                break;
            case 1:
                var message = "Encore au moins " + (nb_car_min-$(this).val().length) + " caractère(s).";
                break;
            case 2:
                var message = "Mot de passe trop simple, mélangez d'autres types de caractères (voir aide).";
                break;
            default:
                var message = "";
        }

        if (retour == -1) {
            $('#progress').css({'width':'100%'}).removeClass('progressbarInvalid').addClass('progressbarValid');
        } else {
            $('#progress').css({'width':'100%'}).removeClass('progressbarValid').addClass('progressbarInvalid');
        }

        $("#complexity").html(message);
    });

    // Envoi du formulaire
    $(document).on("submit", "#formChangeMDP", function(event){
        var retour = test_mdp($("#password").val());
        var submit;

        $("#old_password + span").remove();
        if ($("#old_password").val() == ""){
            $("#old_password").after('<span class="help-inline">Entrez votre ancien mot de passe.</span>').parents(".control-group").addClass("warning");
            submit = false;
        }else{
            $("#old_password").parents(".control-group").removeClass("warning");
            submit = true;
        }

        $("#password + span").remove(); // suppression d'office de l'ancien message
        switch (retour){
            case 0:
                $("#password").after("<span class=\"help-inline\">Entrez votre nouveau mot de passe.</span>").parents(".control-group").addClass("warning");
                break;
            case 1:
                $("#password").after("<span class=\"help-inline\">Votre mot de passe doit comporter au moins " + nb_car_min + " caractères.</span>").parents(".control-group").addClass("warning");
                break;
            case 2:
                $("#password").after("<span class=\"help-inline\">Votre mot de passe doit être composé d'au moins " + nb_classe_min + " classes de caractères.</span>").parents(".control-group").addClass("warning");
                break;
            default:
                $("#password").parents(".control-group").removeClass("warning");
        }

        $("#re_password + span").remove();
        $("#re_password").parents(".control-group").removeClass("warning");
        if (($("#password").val() == $("#re_password").val() && $("#re_password").val() != "")){
            if ((retour == -1) && submit) return true;
        }else{
            $("#re_password").after('<span class="help-inline">Confirmez votre mot de passe.</span>').parents(".control-group").addClass("warning");
        }
        return false;
    });
});

    function test_mdp(mdp) {
        // teste le mot de passe et renvoie un tableau
        // -1 : mot de passe valide
        //  0 : mot de passe de longueur nulle
        //  1 : mot de passe trop court
        //  2 : mot de passe trop simple (pas assez de classes de caractères)
        var nb_classe = contientMinuscule(mdp) + contientMajuscule(mdp) + contientChiffre(mdp) + contientCarSpecial(mdp);
        var longueur = mdp.length;
        if (longueur == 0){
            return 0;
        } else if (longueur < nb_car_min){
            return 1;
        } else if (nb_classe < nb_classe_min){
            return 2;
        } else {
            return -1;
        }
    }

    function contientMinuscule(str) {
        var re = new RegExp(/[a-z]/);
        if (re.test(str)) return 1;
        return 0;
    }
    function contientMajuscule(str) {
        var re = new RegExp(/[A-Z]/);
        if (re.test(str)) return 1;
        return 0;
    }
    function contientChiffre(str) {
        var re = new RegExp(/[0-9]/);
        if (re.test(str)) return 1;
        return 0;
    }
    function contientCarSpecial(str) {
        var re = new RegExp(/[\W]/);
        if (re.test(str)) return 1;
        return 0;
    }
})()    // fin wrapper javascript