"use strict";

var documents = (function() {

    jQuery(document).ready(function ($) {
        var max_upload_file_size = "10mb";          // Max upload file size per ogject

        // Show tab on click (initially the tabs are hidden)
        $(document).on("click", ".row-fluid", function(event){
            $(".tab-content").show();
        });
        // Hide tabs at start
        $(document).on("click", ".row-fluid", function(event){
            $(".nav.nav-pills").show();
            $(".row-fluid").hide();
            $(".tab-content").show();
            if ($(this).find("button").attr("id") == "btn-distribuer")
                $("#href-distribuer").click();
            if ($(this).find("button").attr("id") == "btn-ramassage")
                $("#href-gerer").click();
            if ($(this).find("button").attr("id") == "btn-liste")
                $("#href-historique").click();
        });

        // Tab distribuer
        $("#nomdev").val("");   // cleaning field référence

        $.ajaxSetup({async:false});  // for the ajax call to be synchronous FIXME

        documents_utils.loadGroups();
        documents_utils.cacheDocs();
        documents_utils.remplirGroupes();
        documents_utils.remplirFichTemp("devoir");
        documents_utils.remplirFichTemp("data");
        documents_utils.gestionActivationDistMail();

        // Tab ramassage
        documents_utils.remplirListDevRamasser();
        documents_utils.remplirListDevRendre();
        documents_utils.gestionActivationRenMail();

        // Tab liste
        documents_utils.remplirTableauHistorique();

        $.ajaxSetup({async:true});  // reset the ajax call to be asynchronous FIXME

        // Delete file temp
        $(document).on("click", ".suptemp", function(event){
            var role = $(this).data("role");    // data or devoir
            var fich = $(this).data("name");    // filename
            documents_utils.removefileTemp(role, fich);
        });

        // Emptying folder temp
        $(document).on("click", ".vidtemp", function(event){
            var role = $(this).data("role");    // data or devoir
            documents_utils.cleaningTemp(role, true);
        });

        // Validate and submit distribute form
        $(document).on("click", "#btnSubmitDistribuer", function(event){
            var validation = true;

            // Checks if the document reference not already exists
            validation = documents_utils.validationReferenceDevoir() && validation;

            // Checks if a group has been selected
            validation = documents_utils.validationDestinataire() && validation;

            // Checks whether at least one file is found in the temp folder
            validation = documents_utils.validationDocuments() && validation;

            // Submit form
            $("html, body").animate({ scrollTop: 0 }, "slow");
            if (validation) {
                documents_utils.remplirModal();
		// Hack to put the modal back in a visible place (initial position set to left = -1000px in the template)
                $('#recap').attr("style","left: 50%;").modal();
            }
        });

        // Submit ramasser form
        $(document).on("click", "#btnSubmitRamasser", function(event){
            var refdev = $("option:selected", $("#list_dev_a_ram")).attr("label");
            if (refdev !== "(vide)") documents_utils.submitRamasser(refdev);
        });

        // Submit rendre form
        $(document).on("click", "#btnSubmitRendre", function(event){
            var refdev = $("option:selected", $("#list_dev_a_ren")).attr("label");
            var envoimail = $("#ren_envoi_mail").prop("checked");
            documents_utils.submitRendre(refdev, envoimail);
        });

        // Checks if the document reference not already exists
        $("#nomdev").on({blur : function(e){
            setTimeout(function(){documents_utils.validationReferenceDevoir();},50);
        }});

        // Change style for dropzone during drag & drop
        $(".dropzone").on({
            dragover : function(e){
               $(this).addClass("hotDropzone");
            },
            dragleave : function(e){
               $(this).removeClass("hotDropzone");
            }
        });

        // Plupload object for Documents (devoir)
        var uploader_devoir = new plupload.Uploader({
            runtimes : "html5,html4",
            browse_button : "addtempdevoir",
            container: "containerdevoir",
            drop_element : "zonetempdevoir",
            multipart: true,
            multi_selection: true,
            urlstream_upload: true,
            multipart_params: {"typedoc":"devoir"},
            max_file_size : max_upload_file_size,
            url : "/api/files/"
        });

        uploader_devoir.bind("Init", function(up, params) {
            // If html5 is available then display area for drag & drop and mask the add button else it's the opposite
            if (params.runtime == "html5"){
                $("#parcourirtempdevoir").remove();
                $("#zonetempdevoir").show();
                uploader_devoir.settings.browse_button = "zonetempdevoir";
            }else{
                $("#zonetempdevoir").remove();
                $("#parcourirtempdevoir").show();
                uploader_devoir.settings.browse_button = "addtempdevoir";
            }
        });

        uploader_devoir.init();

        uploader_devoir.bind("FilesAdded", function(up, files) {
            var $listfich = $("#tempfichdevoir");
            $.each(files, function(i, file) {
                if (uploader_devoir.runtime == "html5"){ // the file size is unknown in html4
                    $listfich.prepend("<div id=\""+file.id+"\" class=\"file\">"+file.name+" ("+plupload.formatSize(file.size)+")"+"<div class=\"progress progress-striped active\"><div class=\"bar\"></div></div></div>");
                }else{
                    $listfich.prepend("<div id=\""+file.id+"\" class=\"file\">"+file.name+" <div class=\"progress progress-striped active\"><div class=\"bar\"></div></div></div>");
                }
            });
            $(".dropzone").removeClass("hotDropzone");
            uploader_devoir.start();
        });

        uploader_devoir.bind("UploadProgress", function(up, file) {
            $("#"+file.id).find(".bar").css("width",file.percent+"%");
        });

        uploader_devoir.bind("Error", function(up, err) {
            var titrenotif = documents_utils.formatString(documents_utils.NOTIF_TITRE, "Document", "Erreur");
            documents_utils.afficherNotification("error", titrenotif, "Message: " + err.message + (err.file ? ", File: " + err.file.name : ""));
        });

        uploader_devoir.bind("FileUploaded", function(up, file) {
            $("#"+file.id).find(".bar").css("width","100%");
            var titrenotif = documents_utils.formatString(documents_utils.NOTIF_TITRE, "Document", "Ok");
            var textenotif = documents_utils.formatString(documents_utils.NOTIF_TEXTE, file.name);
            documents_utils.afficherNotification("info", titrenotif, textenotif);
            documents_utils.remplirFichTemp("devoir");
        });

        // Plupload object for Annexes (data)
        var uploader_data = new plupload.Uploader({
            runtimes : "html5,html4",
            browse_button : "addtempdata",
            container: "containerdata",
            drop_element : "zonetempdata",
            multipart: true,
            urlstream_upload: true,
            multipart_params: {"typedoc":"data"},
            max_file_size : max_upload_file_size,
            url : "/api/files/"
        });

        uploader_data.bind("Init", function(up, params) {
            // If html5 is available then display area for drag & drop and mask the add button else it's the opposite
            if (params.runtime == "html5"){
                $("#parcourirtempdata").remove();
                $("#zonetempdata").show();
                uploader_data.settings.browse_button = "zonetempdata";
            }else{
                $("#zonetempdata").remove();
                $("#parcourirtempdata").show();
                uploader_data.settings.browse_button = "addtempdata";
            }
        });

        uploader_data.init();

        uploader_data.bind("FilesAdded", function(up, files) {
            var $listfich = $("#tempfichdata");
            $.each(files, function(i, file) {
                if (uploader_data.runtime == "html5"){ // the file size is unknown in html4
                    $listfich.prepend("<div id=\""+file.id+"\" class=\"file\">"+file.name+" ("+plupload.formatSize(file.size)+")"+"<div class=\"progress progress-striped active\"><div class=\"bar\"></div></div></div>");
                }else{
                    $listfich.prepend("<div id=\""+file.id+"\" class=\"file\">"+file.name+" <div class=\"progress progress-striped active\"><div class=\"bar\"></div></div></div>");
                }
            });
            $(".dropzone").removeClass("hotDropzone");
            uploader_data.start();
        });

        uploader_data.bind("UploadProgress", function(up, file) {
            $("#"+file.id).find(".bar").css("width",file.percent+"%");
        });

        uploader_data.bind("Error", function(up, err) {
            var titrenotif = documents_utils.formatString(documents_utils.NOTIF_TITRE, "Données", "Erreur");
            documents_utils.afficherNotification("error", titrenotif, "Message: " + err.message + (err.file ? ", File: " + err.file.name : ""));
        });

        uploader_data.bind("FileUploaded", function(up, file) {
            $("#"+file.id).find(".bar").css("width","100%");
            var titrenotif = documents_utils.formatString(documents_utils.NOTIF_TITRE, "Données", "Ok");
            var textenotif = documents_utils.formatString(documents_utils.NOTIF_TEXTE, file.name);
            documents_utils.afficherNotification("info", titrenotif, textenotif);
            documents_utils.remplirFichTemp("data");
        });

        // popover allows to display a popup for tooltip help
        $("a[data-toggle=popover]").popover({html : true}).click(function(e) {e.preventDefault()});

        // Manage actions in doc list
        // Button Ramasser
        $(document).on("click", ".ramasser", function(event){
            var refdev = $(this).parents("tr").attr("data-name");
            if (refdev !== undefined) documents_utils.submitRamasser(refdev);
        });
        // Button Rendre
        $(document).on("click", ".rendre", function(event){
            var refdev = $(this).parents("tr").attr("data-name");
            if (refdev !== undefined) documents_utils.submitRendre(refdev, false);
        });
        // Button Supprimer
        $(document).on("click", ".supprimer", function(event){
            var refdev = $(this).parents("tr").attr("data-name");
            if (refdev !== undefined) documents_utils.submitSupprimer(refdev);
        });

        // Suppress one of the recipients
        $(document).on("click", ".supdestinataire", function(event){
            var dest = $(this).data("name");    // destinataire
            var index = documents_utils.listeDestinataires.indexOf(dest);
            if(index != -1) documents_utils.listeDestinataires.splice(index, 1);
            documents_utils.miseEnFormeDestinataires();
            documents_utils.validationReferenceDevoir();
        });

        // Empty recipients
        $(document).on("click", ".viddestinataires", function(event){
            documents_utils.listeDestinataires = [];
            documents_utils.miseEnFormeDestinataires();
            documents_utils.validationReferenceDevoir();
        });

        // Confirmation depuis la modal
        $(document).on("click", "#recap-confirm", function(event){
            documents_utils.submitDistribuer();
            $('#recap').modal("hide");
        });

        // Adding a recipient if not already listed
        $("#groupe").on({change : function(e){
            var destinataire = $("option:selected", $(this)).attr("label");
            if (documents_utils.listeDestinataires.indexOf(destinataire) == -1){
                documents_utils.listeDestinataires.push(destinataire);
                documents_utils.validationReferenceDevoir();
            }
            $("option:selected", $(this)).removeAttr("selected");  // empty the selected recipient
            $(this).trigger("liszt:updated");  // chosen plugin refresh
            documents_utils.miseEnFormeDestinataires();
            documents_utils.validationDestinataire();
        }});

        // Show / hide mail fields
        $("#dist_envoi_mail").on({change : function(e){documents_utils.gestionActivationDistMail();}});

        // Show / hide mail fields for "rendre"
        $("#ren_envoi_mail").on({change : function(e){documents_utils.gestionActivationRenMail();}});

    });
})();
