# -*- coding: UTF-8 -*-
from flask import Blueprint, session, current_app, json
from flask.views import MethodView
from xmlrpclib import ServerProxy
from eoleauthlib.authclient import login_required

admingroupsapi = Blueprint('admingroupsapi', __name__, url_prefix='/api/admingroups/')

class AdmingroupsAPI(MethodView):
    decorators = [ login_required]

    def __init__(self):
        self.proxy = ServerProxy(current_app.config['CONTROLEVNC_URL'])
        self.username = session["username"]
        self.secret = current_app.config['SECRET_KEY']

    def get(self):
        """Returns the list of groups or classes the current user has a right to administer
        """

        if self.username is None:
            current_app.logger.warning('Unbound use of the API, no session username defined!')
            return json.dumps('Error: You need a username to talk to backend')

        usergroups = self.proxy.remote_get_attr(self.secret, self.username, self.username, 'Divcod')
        usergroups.extend(self.proxy.remote_get_attr(self.secret, self.username, self.username, 'ManagedGroup'))

        return json.dumps(usergroups)

    def post(self):
        raise NotImplementedError

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("admin_groups_api")
        mod.add_url_rule('', view_func=f, methods=["GET"])
        mod.add_url_rule('', view_func=f, methods=["POST"])
        mod.add_url_rule('', view_func=f, methods=['GET', 'PUT', 'DELETE'])

AdmingroupsAPI.register(admingroupsapi)
