from flask import Blueprint, render_template, request, session, url_for, current_app
from eoleauthlib.authclient import login_required
from eoleflask.util import get_proxy_url
from eop import utils

passperso = Blueprint('passperso', __name__, url_prefix = '/passperso')

@passperso.route('')
@login_required
def show():

    username = session["username"]
    is_prof = utils.est_prof()

    if not is_prof:
        current_app.logger.warning('User %s (not prof) tried to access page \'passperso.html\'.' %username)
        return render_template('erreurs/non_prof.html', username=username)
    else:
        url_logout = url_for('logout', return_url=get_proxy_url(request, url_for("passperso.show", _external=True)))
        return render_template('passperso/passperso.html', nb_classe_min = current_app.config['NB_CLASSE_MIN'], nb_car_min = current_app.config['NB_CAR_MIN'], username = username, url_logout = url_logout)
