"use strict";

var passperso_utils = (function() {
    // Private Members
    var groups = {};

    function _manageJSON(data){
        // Checks if a string has the json format
        // if true returns an object else return the same string
        var response;
        try{
            response = $.parseJSON(data);
        }catch(e){
            response = data;
        }
        return response;
    };

    function _contientMinuscule(str) {
        var re = new RegExp(/[a-z]/);
        if (re.test(str)) return 1;
        return 0;
    };

    function _contientMajuscule(str) {
        var re = new RegExp(/[A-Z]/);
        if (re.test(str)) return 1;
        return 0;
    };

    function _contientChiffre(str) {
        var re = new RegExp(/[0-9]/);
        if (re.test(str)) return 1;
        return 0;
    };

    function _contientCarSpecial(str) {
        var re = new RegExp(/[\W]/);
        if (re.test(str)) return 1;
        return 0;
    };

    function _empty_fields(){
        $('#old-password').removeClass("has-error").removeClass("has-success");
        $("#old-password-input").val('');
        passperso_utils.remove_retype_warnings($('#new-password'), $("#complexity-check"));
        $("#new-password-input").val('');
        passperso_utils.remove_retype_warnings($('#retype-new-password'), $("#same-new-pass-check"));
        $("#retype-new-password-input").val('');
        $("#retype-new-password-input").blur();
        $("#retype-new-password-input").prop('disabled', true);
    };

    // Public Members
    return {
        "check_password" : function () {
            // checking the password entered by the user
            // return cases :
            // -1 : valid password
            //  0 : empty password
            //  1 : password is too short
            //  2 : password is too simple (not enough caracters types mixed)
            var pass = $("#new-password-input").val();
            var nb_classe = _contientMinuscule(pass) + _contientMajuscule(pass) + _contientChiffre(pass) + _contientCarSpecial(pass);
            var longueur = pass.length;
            var retour;
            if (longueur == 0){
                retour = 0;
            } else if (longueur < nb_car_min){
                retour = 1;
            } else if (nb_classe < nb_classe_min){
                retour = 2;
            } else {
                retour = -1;
            }
            var message;
            switch (retour){
            case -1:
                message = "Mot de passe acceptable.";
                break;
            case 0:
            case 1:
                message = "Encore au moins " + (nb_car_min-$("#new-password-input").val().length) + " caractère(s).";
                break;
            case 2:
                message = "Mot de passe trop simple, mélangez d'autres types de caractères.";
                break;
            default:
                message = "";
            }
            if (retour == -1) {
                $('#new-password').removeClass("has-error").addClass("has-success");
                $("#retype-new-password-input").prop('disabled', false);
            } else {
                $('#new-password').removeClass("has-success").addClass("has-error");
                $("#retype-new-password-input").prop('disabled', true);
            }

            $("#complexity-check").html(message);
            $("#complexity-check").show("slow");
            return (retour == -1);
        },

        // Checking for a correct new password
        "check_retype_password" : function(){
            var pass = $("#new-password-input").val();
            var retype_pass = $("#retype-new-password-input").val();
            var retype_ok = (pass == retype_pass);
            if (retype_ok) {
                $('#retype-new-password').removeClass("has-error").addClass("has-success");
                $("#same-new-pass-check").hide("slow");
            } else {
                $('#retype-new-password').removeClass("has-success").addClass("has-error");
                $("#same-new-pass-check").show("slow");
            }
            return retype_ok;
        },

        // Check the old password
        "check_old_password" : function(){
            var old_pass_empty = ($("#old-password-input").val().length == 0);
            if(old_pass_empty){
                $('#old-password').addClass("has-error");
                $("#old-pass-check").show("slow");
            }
            else{
                $('#old-password').removeClass("has-error");
                $("#old-pass-check").hide("slow");
            }
            return ! old_pass_empty;
        },

        // Remove warning for the retyping zone of element and hide help
        "remove_retype_warnings" : function(element, help){
            element.removeClass("has-error").removeClass("has-success");
            help.hide("slow");
        },

        "submitChangePassword" : function (){
            $.ajax({
                type: "PUT",
                url: "api/ldappasswords/" + $('#old-password-input').val() + "/" + $("#new-password-input").val(),
                success: function (data) {
                    var response = _manageJSON(data);
                    if(typeof response == "boolean"){
                        // response is the return from the remote modification function
                        if(response){
                            passperso_utils.afficherNotification("success", "Votre mot de passe a été changé avec succès.");
                            _empty_fields();
                        }else {
                            passperso_utils.afficherNotification("danger", "Erreur lors de la modification de votre mot de passe.");
                        }
                    }else { // response is a string error message
                        passperso_utils.afficherNotification("danger", response.substr(0,200));
                    }
                },
                error : function (data) {
                    passperso_utils.afficherNotification("danger", "Erreur : impossible de contacter le serveur.");
                }
            });
        },

        "afficherNotification" : function (type, message){
            var othertype;
            // type should be only "danger" or "success"
            if(type == "danger"){
                othertype = "success";
            }
            else{
                if(type == "success"){
                    othertype = "danger";
                }
                else{
                    return 0;
                }
            }
            $("#passperso-result-message").html("<button type=\"button\" class=\"close notification\">&times;</button>" + message);
            $("#passperso-result-message").removeClass("alert-" + othertype).addClass("alert-" + type);
            $("#passperso-result-message").show("slow");
            $("html, body").animate({ scrollTop: 0 }, "slow");
        }
    };
})();
