# -*- coding: UTF-8 -*-
from flask import Blueprint, current_app, session, json
from flask.views import MethodView
from eoleauthlib.authclient import login_required
from eop import utils

usersapi = Blueprint('usersapi', __name__, url_prefix='/api/users/')

class UsersAPI(MethodView):
    decorators = [ login_required]

    def __init__(self):
        self.username = session["username"]
        self.secret = current_app.config['SECRET_KEY']

    def get(self):
        """Returns true if username is a teacher
           Parameters needed :
            in this object : self.secret, self.username
        """
        if self.secret is None:
            #FIXME
            return json.dumps('Error: You need a secret to talk to backend')
        if self.username is None:
            current_app.logger.warning('Unbound use of the API, no session username defined!.')
            return json.dumps('Error: You need a username to talk to backend')
        return json.dumps(utils.est_prof())

    def post(self):
        raise NotImplementedError

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("users_api")
        mod.add_url_rule('', view_func=f, methods=["GET"])
        mod.add_url_rule('', view_func=f, methods=["POST"])
        mod.add_url_rule('', view_func=f, methods=['GET', 'PUT', 'DELETE'])

UsersAPI.register(usersapi)
