"use strict";

var mdp_utils = (function() {
    // Private Members
    var groups = {};

    function _manageJSON(data){
        // Checks if a string has the json format
        // if true returns an object else return the same string
        try{
            var response = $.parseJSON(data);
        }catch(e){
            var response = data;
        }
        return response;
    };

    function _contientMinuscule(str) {
        var re = new RegExp(/[a-z]/);
        if (re.test(str)) return 1;
        return 0;
    };

    function _contientMajuscule(str) {
        var re = new RegExp(/[A-Z]/);
        if (re.test(str)) return 1;
        return 0;
    };

    function _contientChiffre(str) {
        var re = new RegExp(/[0-9]/);
        if (re.test(str)) return 1;
        return 0;
    };

    function _contientCarSpecial(str) {
        var re = new RegExp(/[\W]/);
        if (re.test(str)) return 1;
        return 0;
    };

    // Public Members
    return {
        "getAdminGroups" : function() {
            var admin_groups;
            $.getJSON("api/ldapusers/Divcod", function(data) {
                var response = _manageJSON(data);
                if (typeof response == "object"){ // response has json format
                    admin_groups = response;
                }
            });
            return admin_groups;
        },

        "activationCommonPassword" : function (){
            // Show / hide common password field
            if ($("#option-common").prop('checked')){
                $("#common-password").show("slow");
                $("#common-password-input").focus();
            }else{
                $("#common-password").hide("slow");
            }
        },

        "check_password" : function () {
            // return a boolean that tells wether the password entered by the user is correct
            var pass = $("#common-password-input").val();
            var nb_classe = _contientMinuscule(pass) + _contientMajuscule(pass) + _contientChiffre(pass) + _contientCarSpecial(pass);
            var longueur = pass.length;
            var retour;
            // retour values :
            // -1 : valid password
            //  0 : empty password
            //  1 : password is too short
            //  2 : password is too simple (not enough caracters types mixed)
            if (longueur == 0){
                retour = 0;
            } else if (longueur < nb_car_min){
                retour = 1;
            } else if (nb_classe < nb_classe_min){
                retour = 2;
            } else {
                retour = -1;
            }
            var message;
            switch (retour){
            case -1:
                message = "Mot de passe acceptable.";
                break;
            case 0:
            case 1:
                message = "Encore au moins " + (nb_car_min-longueur) + " caractère(s).";
                break;
            case 2:
                message = "Mot de passe trop simple, mélangez d'autres types de caractères.";
                break;
            default:
                message = "";
            }

            if (retour == -1) {
                $('#common-password').removeClass("has-error").addClass("has-success");
            } else {
                $('#common-password').removeClass("has-success").addClass("has-error");
            }

            $("#complexity-check").html(message);
            $("#complexity-check").show("slow");
            return (retour == -1);
        },

        "submitChangePassword" : function (){
            var passwordformat = $(".radio input:checked").val();
            var newpassword = "";
            if (passwordformat == "common"){
                newpassword = $("#common-password-input").val();
            }
            $.ajax({
                type: "POST",
                url: "api/ldappasswords/",
                data: {"eleves": JSON.stringify(select_eleves_widget.getSelectedIds()), "passwordformat": passwordformat, "newpassword": newpassword, "forcechange": $("#force-modification").prop("checked")},
                success: function (data) {
                    select_eleves_widget.emptySelectedEleves(); // empty the list of selected eleves
                    select_eleves_widget.formatSelectedEleves();
                    var response = _manageJSON(data);
                    if (typeof response == "object"){ // response has json format
                        var items = [];
                        $.each(response['eleves'], function(login, pass) {
                            items.push("<li><b>"
                                       + select_eleves_widget.getDescriptionFromId(login)
                                       + "</b> : " + pass + "</li>");
                        });
                        var message = "Les mots de passe des utilisateurs suivants ont été modifiés avec succès :<ul class=\"list-inline\">" + items.join(" ; ") + "</ul><br/>";
                        var file_name = response['filename'];
                        if (file_name == ""){
                            message += "Les modifications n'ont pas pu être enregistrées dans un fichier.";
                        }
                        else{
                            message += "Modifications enregistrées dans votre répertoire personnel dans le fichier <b>" + file_name  + "</b>.";
                        }
                        mdp_utils.afficherNotification("success", message);
                    }else{ // response is a string error message
                        mdp_utils.afficherNotification("danger", response.substr(0,200));
                    }
                },
                error : function (data) {
                    mdp_utils.afficherNotification("danger", "Erreur : impossible de contacter le serveur.");
                }
            });
        },

        "afficherNotification" : function (type, message){
            var othertype;
            // type should be only "danger" or "success"
            if(type == "danger"){
                othertype = "success";
            }
            else{
                if(type == "success"){
                    othertype = "danger";
                }
                else{
                    return 0;
                }
            }
            $("#mdp-result-message").html("<button type=\"button\" class=\"close notification\">&times;</button>" + message);
            $("#mdp-result-message").removeClass("alert-" + othertype).addClass("alert-" + type);
            $("#mdp-result-message").show("slow");
            $("html, body").animate({ scrollTop: 0 }, "slow");
        }
    };
})();
