"use strict";

var mdp = (function() {

    jQuery(document).ready(function ($) {

        $.ajaxSetup({async:false});  // for the ajax call to be synchronous FIXME
        
        select_eleves_widget.loadEleves(mdp_utils.getAdminGroups());
        
        mdp_utils.activationCommonPassword();
        $("#complexity-check").hide();

        $.ajaxSetup({async:true});  // reset the ajax call to be asynchronous FIXME

        // Show / hide common password field
        $("input[name=option]:radio").on({change : function(e){
            mdp_utils.activationCommonPassword();
        }});

        // hiding the alert notification
        $(document).on("click", ".close.notification", function(event){
            $("#mdp-result-message").hide("slow");
        });
        
        // Checking for a correct password while typing
        $(document).on("keyup", "#common-password-input", function(event){
            mdp_utils.check_password();
        });

        // Validate and submit change password form
        $(document).on("click", "#btnSubmitPassword", function(event){
            $("#mdp-result-message").hide("slow");
            var validation = select_eleves_widget.validateSelectedEleves();
            // checking the entered password only if it has to be used
            if($("#option-common").prop('checked')){
                validation = validation &&  mdp_utils.check_password();
            }
            if (validation) {
                mdp_utils.submitChangePassword();
            }
        });

    });
})();

