from flask import Blueprint, render_template, request, session, url_for
from eoleauthlib.authclient import login_required
from eoleflask.util import get_proxy_url
from eop import utils

menuperso = Blueprint('menuperso', __name__, url_prefix = '/menuperso')

@menuperso.route('')
@login_required
def show():

    username = session["username"]
    is_prof = utils.est_prof()

    if not is_prof:
        current_app.logger.warning('User %s (not prof) tried to access page \'menuperso.html\'.' %username)
        return render_template('erreurs/non_prof.html', username=username)
    else:
        url_logout = url_for('logout', return_url=get_proxy_url(request, url_for("menuperso.show", _external=True)))
        return render_template('menuperso/menuperso.html', username = username, url_logout=url_logout)
