#!/usr/bin/env python
# -*- coding: utf-8 -*-

from wtforms import Form, FormField, TextField, TextAreaField, PasswordField, BooleanField, FileField, RadioField, SelectField, SubmitField, validators
from wtforms import ValidationError

import xmlrpclib

class DocumentsForm(Form):
    nomdev = TextField(u'Nom de référence')
    groupe = SelectField(u'Destinataires', choices=[])
    eleve_only = RadioField(u'Uniquement les élèves', default = "eleve", choices=[('eleve', u"Uniquement les élèves"), ('tous',u"À tous les membres")], coerce=unicode)

    rep_dest = RadioField(u"Répertoire de destination", default="perso", choices=[('perso', u"Distribuer immédiatement"), ('devoir', u"Distribuer ultérieurement")], coerce=unicode)

    dist_envoi_mail = BooleanField(u'Envoyer un mail aux élèves', default=False)
    dist_sujet_mail = TextField(u'Sujet')
    dist_corps_mail = TextAreaField(u'Contenu')

    submit = SubmitField(u'Valider')

class DocRamasserForm(Form):
    list_dev_a_ram = SelectField(u'Nom de la référence', choices=[])
    submit = SubmitField(u'Ramasser')

class DocRendreForm(Form):
    list_dev_a_ren = SelectField(u'Nom de la référence', choices=[])

    ren_envoi_mail = BooleanField(u'Envoyer un mail aux élèves', default=False)
    ren_sujet_mail = TextField(u'Sujet')
    ren_corps_mail = TextAreaField(u'Contenu')

    submit = SubmitField(u'Rendre')

class DocSupprimerForm(Form):
    list_dev_a_sup = SelectField(u'Nom de la référence', choices=[])
    submit = SubmitField(u'Supprimer')

# from eop import app
# def test_password(form, field):
#     nb_car_min = app.config['NB_CAR_MIN']
#     nb_classe_min = app.config['NB_CLASSE_MIN']
#     mdp = field.data

#     if len(mdp) < nb_car_min:
#         raise ValidationError(u"Votre mot de passe doit comporter au moins %s caractères." % nb_car_min)

#     proxy = xmlrpclib.ServerProxy(app.config["CONTROLEVNC_URL"])
#     if not proxy.remote_check_nb_min_classes(app.config['SECRET_KEY'], mdp, nb_classe_min):
#         raise ValidationError(u"Votre mot de passe doit être composé d'au moins %s classes de caractères." % nb_classe_min)

# class ChangementMDPForm(Form):
#     old_password = PasswordField(u'Ancien mot de passe ', validators=[validators.required(message=u'Vous devez entrer votre ancien mot de passe.')])
#     password = PasswordField(u'Nouveau mot de passe', validators=[validators.required(message=u'Entrez votre nouveau mot de passe.'), test_password])
#     re_password = PasswordField(u'Confirmation', validators=[validators.required(message=u'Vous devez confirmer votre mot de passe.'), validators.EqualTo('password', message=u'Les mots de passe doivent correspondre.')])
#     submit = SubmitField(u'Valider')
