"use strict";

var vnc_utils = (function() {
    // Private Members
    // Contains token, id... for the current connection. Needs to be stored in a local variable for further call to disconnect

    var connection_infos;

    function _manageJSON(data){
        // Checks if a string has the json format
        // if true returns an object else return the same string
        var response;
        try{
            response = $.parseJSON(data);
        }catch(e){
            response = data;
        }
        return response;
    };

    // Public Members
    return {

        "getGroups" : function() {
            // return all classes
            var groups;
            $.getJSON("api/groups/classe", function(data) {
                var response = _manageJSON(data);
                if (typeof response == "object"){ // response has json format
                    groups = response;
                }
            });
            return groups;
        },

        "connect" : function (id){
            // Checks via getConnectionInfos if the needed informations can be retrieved for user "id".
            // In that case, initiate the connection and show the modal containing the noVNC  canvas.
            $("#vnc-result-message").hide("slow");
            var selected_eleve = select_eleves_widget.getEleveFromId(id);
            if(! selected_eleve){
                vnc_utils.showNotification("danger", "Erreur : aucun élève sélectionné");
            }
            else{
                var view_only = ($('input[type=radio][name=vnc-mode]:checked').val() == "view-only");
                $.ajaxSetup({async:false});
                var get_infos_ok = vnc_utils.getConnectionInfos(selected_eleve.login, selected_eleve.id, selected_eleve.ip);
                if(get_infos_ok){
                    window.open("static/js/noVNC/vnc.html?host=" + host_scribe + "&port=" + port_vnc + "&token=" + connection_infos['token'] + "&view_only=" + view_only + "&title=" + select_eleves_widget.getDescription(selected_eleve) + "&id=" + connection_infos.id,"_blank")
                }
                else{
                    vnc_utils.showNotification("danger", "Erreur : impossible de visualiser le poste de l'utilisateur " + select_eleves_widget.getDescription(selected_eleve) + ".");
                }
            }
        },

        "getConnectionInfos" : function(login, id, ip){
            // returns true iff useful informations (token etc.) has been obtained and stored in global variable connection_infos
            // (token informations placed in connection_infos in that case)
            var token_ok = false;
            $.ajax({
                type: "PUT",
                url: "api/vnc/" + login + "/" + id + "/" + ip,
                success: function (data) {
                    var response = _manageJSON(data);
                    if (typeof response == "object"){ // response has json format
                        connection_infos = response;
                        if (! (typeof connection_infos['token'] == "undefined")){
                            token_ok = true;
                        }
                    }
                },
                error : function (data) {
                    vnc_utils.showNotification("danger", "Erreur : impossible de contacter le serveur.");
                }
            });
            return token_ok;
        },

        "showNotification" : function (type, message){
            // Display the given message in the alert area of the template, changing styles according
            // to the type parameter (type should be "danger" or "success")
            var othertype;
            if(type == "danger"){
                othertype = "success";
            }
            else{
                if(type == "success"){
                    othertype = "danger";
                }
                else{
                    return 0;
                }
            }
            $("#vnc-result-message").html("<button type=\"button\" class=\"close notification\">&times;</button>" + message);
            $("#vnc-result-message").removeClass("alert-" + othertype).addClass("alert-" + type);
            $("#vnc-result-message").show("slow");
            $("html, body").animate({ scrollTop: 0 }, "slow");
        }

    };
})();
