# -*- coding: UTF-8 -*-
from flask import Blueprint, current_app, json
from xmlrpclib import ServerProxy
from flask.views import MethodView
from eoleauthlib.authclient import login_required

groupsapi = Blueprint('groupsapi', __name__, url_prefix='/api/groups/')

class GroupsAPI(MethodView):
    decorators = [ login_required]

    def __init__(self):
        self.proxy = ServerProxy(current_app.config['CONTROLEVNC_URL'])

    def get(self, typegroup):
        """Returns the list of groups with the given type
           Possible group types : "classe", "niveau", "matiere", "equipe", "groupe"
        """
        if typegroup is None:
            current_app.logger.warning('Unbound use of the API: required typegroup is not provided.')
            return json.dumps('Error: You need a typegroup to talk to backend')
        return json.dumps(self.proxy.remote_groupes(typegroup))

    def post(self):
        raise NotImplementedError

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("groups_api")
        mod.add_url_rule('', view_func=f, methods=["GET"],
                defaults={"typegroup": None})
        mod.add_url_rule('', view_func=f, methods=["POST"])
        mod.add_url_rule('<typegroup>', view_func=f, methods=['GET', 'PUT', 'DELETE'])

GroupsAPI.register(groupsapi)
