# -*- coding: UTF-8 -*-
from flask import Blueprint, session, current_app, json
from flask.views import MethodView
from xmlrpclib import ServerProxy
from eoleauthlib.authclient import login_required
from eop import utils


ldapusersapi = Blueprint('ldapusersapi', __name__, url_prefix='/api/ldapusers/')

class LdapusersAPI(MethodView):
    decorators = [ login_required]

    def __init__(self):
        self.secret = current_app.config['SECRET_KEY']
        self.username = session["username"]
        self.proxy = ServerProxy(current_app.config['CONTROLEVNC_URL'])

    def get(self, attribute, usertocheck=None):
        """Returns the given attribute in ldap for user "usertocheck" if specified,
        or else for the current user
        """
        if self.username is None:
            current_app.logger.warning('Unbound use of the API, no session username defined!.')
            return json.dumps('Error: You need a username to talk to backend')
        if attribute is None:
            current_app.logger.warning('Unbound use of the API by user %s: required attribute is not provided.' %self.username)
            return json.dumps('Error: You need an attribute to talk to backend')

        return json.dumps(utils.user_get_attr(str(attribute), usertocheck))

    def post(self):
        raise NotImplementedError

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("ldapusers_api")
        mod.add_url_rule('', view_func=f, methods=["GET", "PUT", "DELETE"],
                         defaults={"attribute": None, "usertocheck": None})
        mod.add_url_rule('', view_func=f, methods=["POST"])
        mod.add_url_rule('<attribute>/<usertocheck>', view_func=f, methods=['GET'])
        mod.add_url_rule('<attribute>', view_func=f, methods=['GET'])

LdapusersAPI.register(ldapusersapi)
