from flask import Blueprint, current_app, session, request
from flask.views import MethodView
from xmlrpclib import ServerProxy
from eoleauthlib.authclient import login_required
from eop.utils import send_mail

mailsapi = Blueprint('mailsapi', __name__, url_prefix='/api/mails/')

class MailsAPI(MethodView):
    decorators = [ login_required]

    def __init__(self):
        self.username = session["username"]
        self.proxy = ServerProxy(current_app.config['CONTROLEVNC_URL'])
        self.secret = current_app.config['SECRET_KEY']
        self.serveur = current_app.config["SERVER_SMTP"]

    def get(self):
        raise NotImplementedError

    def post(self):
        """Sends a mail to each member of the group dest
        """
        response = request.form

        groupe = response["groupe"]
        sujetmail = response["sujetmail"]
        corpsmail = response["corpsmail"]

        lesmembres = self.proxy.remote_membres(groupe, "eleves")
        user_name = self.proxy.remote_get_nom(self.secret, self.username)
        user_mail = self.proxy.remote_get_mail(self.secret, self.username)
        if user_mail == "":
            user_mail = "admin@%s" % current_app.config["DOMAINE_MAIL"]

        de = "%s <%s>" % (user_name, user_mail)
        pour = []

        for m in lesmembres:
            pour.append(self.proxy.remote_get_mail(self.secret, m))
        send_mail(smtp_server=self.serveur, mailFrom=de, mailTo=pour, mailSubject=sujetmail.encode('utf8'), text=corpsmail.encode('utf8'))

        return "Done"

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("mails_api")
        mod.add_url_rule('', view_func=f, methods=["POST"])

MailsAPI.register(mailsapi)
