"use strict";

var mdp = (function() {

    jQuery(document).ready(function ($) {

        $.ajaxSetup({async:false});  // for the ajax call to be synchronous FIXME
        
        select_eleves_widget.loadEleves(mdp_utils.getAdminGroups());
        select_etabs_widget.loadEtabs();

        mdp_utils.activationCommonPassword();
        mdp_utils.activationCommonPasswordEtab();
        $("#complexity-check").hide();

        $.ajaxSetup({async:true});  // reset the ajax call to be asynchronous FIXME

        // Show / hide common password field
        $("input[name=option]:radio").on({change : function(e){
            mdp_utils.activationCommonPassword();
            mdp_utils.activationCommonPasswordEtab();
        }});

        // hiding the alert notification
        $(document).on("click", ".close.notification", function(event){
            $("#mdp-result-message").hide("slow");
        });
        
        // Checking for a correct password while typing
        $(document).on("keyup", "#common-password-input", function(event){
            mdp_utils.check_password();
        });
        $(document).on("keyup", "#common-password-etab-input", function(event){
            mdp_utils.check_password_etab();
        });

        // Validate and submit change password form
        $(document).on("click", "#btnSubmitPassword", function(event){
            $("#mdp-result-message").hide("slow");
            var validation = select_eleves_widget.validateSelectedEleves();
            // checking the entered password only if it has to be used
            if($("#option-common").prop('checked')){
                validation = validation &&  mdp_utils.check_password();
            }
            if (validation) {
                $("#btnSubmitPassword").html("Traitement en cours <i class=\"fa fa-spinner fa-spin\"></i>");
                var selected = JSON.stringify(select_eleves_widget.getSelectedIds())
                mdp_utils.submitChangePassword(selected);
            }
        });
        // Validate and submit change etabs password form
        $(document).on("click", "#btnSubmitEtabsPassword", function(event){
            $("#mdp-result-message").hide("slow");
            var validation = select_etabs_widget.validateSelectedEtabs();
            // checking the entered password only if it has to be used
            if($("#option-common-etab").prop('checked')){
                validation = validation &&  mdp_utils.check_password_etab();
            }
            if (validation) { 
                $("#btnSubmitEtabsPassword").html("Traitement en cours <i class=\"fa fa-spinner fa-spin\"></i>");
                var selectedetabs = JSON.stringify(select_etabs_widget.getSelectedIds())
                mdp_utils.submitChangeEtabsPassword(selectedetabs);
            }
        });


    });
})();

