# -*- coding: utf-8 -*-
import json
from flask import Blueprint, current_app, render_template, request, session, url_for
from eoleauthlib.authclient import login_required
from eoleflask.util import get_proxy_url
from eop import utils

droitsprof = Blueprint('droitsprof', __name__, url_prefix = '/droitsprof')

@droitsprof.route('')
@login_required
def show():

    username = session["username"]
    is_prof = utils.est_prof()

    listes = utils.get_list_profs()

    if not is_prof:
        current_app.logger.warning('User %s (not prof) tried to access page \'droitsprof.html\'.' %username)
        return render_template('erreurs/non_prof.html', username=username)
    else:
        url_logout = url_for('logout', return_url=get_proxy_url(request, url_for("droitsprof.show", _external=True)))
        return render_template('droitsprof/droitsprof.html', username = username, url_logout = url_logout,
            classes=listes[1], profs=json.dumps(listes[0]))
