"use strict";

var documents_utils = (function() {
    // Private Members
    var refGroups = {};

    function _manageJSON(data){
        // Checks if a string has the json format
        // if true returns an object else return the same string
        var response;
        try{
            response = $.parseJSON(data);
        }catch(e){
            response = data;
        }
        return response;
    };

    function _getDateTime(unixTimeStamp) {
        // Transform an unix timestmap into a formated date
        var d = new Date(unixTimeStamp*1000);
        var j = (d.getDate().toString().length == 1) ? ('0' + d.getDate()) : d.getDate();
        var m = ((d.getMonth()+1).toString().length == 1) ? ('0' + (d.getMonth()+1)) : d.getMonth()+1;
        var a = d.getFullYear();

        var myDate = a + '/' + m + '/' + j;

        return myDate;
    }

    function _getGroups(typegroup){
        $.getJSON("api/groups/" + typegroup, function(data) {
            var response = _manageJSON(data);
            if (typeof response == "object"){ // response has json format
                refGroups[typegroup] = response;
            }
        });
    };

    function _formattingTempFiles(data, role){
        // Takes the file list in json (data) and return formated html
        // data = {"listedoc":["yoyo2000.gif","1_005.png","yoyo2000.png"]}
        // role = "data" or "devoir" to put it in a html attribut "data-role" recoverable in js
        if (data["listedoc"] == null) return "Aucun document";
        var items = [];
        $.each(data["listedoc"], function(i, fich) {
            items.push("<div class=\"well-sm btn-group\">\n");
            items.push("<a class=\"btn btn-danger suptemp\" data-name=\"" + fich +"\" data-role=\"" + role + "\"><span class=\"fa fa-times\"></span></a>\n");
            items.push("<a class=\"btn btn-default disabled\">" + fich +"</a>\n");
            items.push("</div>\n");
        });
        if (items.length !== 0) {
            items.unshift("<a class=\"btn-link pull-right vidtemp\" data-role=\""+ role +"\">Vider la liste</a>");
            return items.join("");
        }else{
            return "Aucun document";
        }
    };

    function _formattingDocs(data) {
        // Takes the doc list in json (data) and returns formated html
        // data = {"devoir-yo-2-yo_grp":{"groupe":"yo_grp", "timestamp": 1396604212.584942, "state":"dist","in_perso":true,"eleve_only":true},"devoir-yo-3":{"groupe":"yo_grp","state":"dist","in_perso":true,"eleve_only":true},...}
        var items = [];
        var listecle = $.map(data, function(value, key) {return key;}).sort(); // lists the json keys and sorts them
        $.each(listecle, function(i, cle) {
            items.push("<option label=\"" + cle + "\" data-group=\"" + data[cle]["groupe"] + "\">" + cle + "</option>");
        });
        items.unshift("<option label=\"(vide)\"></option>"); // Place an empty value at the beginning
        return items.join("");
    };

    function _genInfosDocs(data) {
        // Takes doc data and returns a list of computed information and html
        // data = {"groupe":"yo_grp", "timestamp": 1396604212.584942, "state":"dist","in_perso":true,"eleve_only":true}
        var infosdev = [];
        infosdev["date"] = _getDateTime(data["timestamp"]);
        switch (data["state"]) {
            case "dist":
                infosdev["styledev"] = "info";
                infosdev["etat"] = "Distribué";
                infosdev["action"] = "<a class=\"btn btn-warning ramasser\">Ramasser <span class=\"fa fa-check\"></span></a>";
                break;
            case "ram":
                infosdev["styledev"] = "warning";
                infosdev["etat"] = "Ramassé";
                infosdev["action"] = "<a class=\"btn btn-success rendre\">Rendre <span class=\"fa fa-check\"></span></a>";
                break;
            case "ren":
                infosdev["styledev"] = "success";
                infosdev["etat"] = "Rendu";
                infosdev["action"] = "";
                break;
            default : break;
        }
        ////if (data["in_perso"] == true){
            ////infosdev["destination"] = "dossier 'perso/devoirs'";
        ////}else{
            ////infosdev["destination"] = "partage 'devoirs' (non accessible par défaut)";
        ////}
        if (data["eleve_only"] == true){
            infosdev["eleve_seul"] = "oui";
        }else{
            infosdev["eleve_seul"] = "non";
        }
        return infosdev;
    };

    function _checkDevoir(docname) {
        var list_key = $.map(documents_utils.refDocs, function(value, key) {return key;}).sort(); // lists the json keys and sorts them
        return (list_key.indexOf(docname) != -1);
    };

    function _addValidationMessage($element, message) {
        // Adds a validation message to the $element field (= jquery object)
        var elem_id = $element.attr("id");
        var $message = $("#" + elem_id + "_message");

        $element.closest("div.form-group").addClass("has-error");
        if ($message.is("span")){
            $message.text(message);
        }else{
            $element.after("<span id=\"" + elem_id + "_message\" class=\"text-danger\">"+ message + "</span>");
        }
    };

    function _deleteValidationMessage($element) {
        // Deletes the validation message from the $element field (= jquery object)
        var elem_id = $element.attr("id");
        var $message = $("#" + elem_id + "_message");

        $element.closest("div.form-group").removeClass("has-error");
        $message.remove();
    };

    function _sendGroupMail(dest, sujetmail, corpsmail) {
        // Sends a mail to each member of the group dest
        $.ajax({
            type: "POST",
            url: "api/mails/",
            data: {"groupe":dest, "sujetmail":sujetmail, "corpsmail":corpsmail},
            error : function (data) {
                documents_utils.afficherNotification("danger", "Erreur", "Impossible de contacter le serveur.", true);
            }
        });
    };

    function _copyTempFiles(refdev) {
        // Copy the uploaded files from refdev temp folder on the server to the workgroup folder for the backend
        $.ajax({
            type: "PUT",
            url: "api/files/" + refdev,
            success: function (data) {
                documents_utils.remplirFichTemp("devoir");
                documents_utils.remplirFichTemp("data");
            },
            error : function (data) {
                documents_utils.afficherNotification("danger", "Erreur", "Impossible de contacter le serveur.", true);
            }
        });
    };

    function _distributeDoc(refdev, groupe, eleve_only, in_perso) {
        $.ajax({
            type: "POST",
            url: "api/documents/",
            data: {"groupe":groupe, "nomdev":refdev, "eleve_only":eleve_only, "in_perso":in_perso},
            success: function (data) {
                // returned data is json string : [20, ["yoyo2000", "toto24"], "devoir1-grp"] or in case of error a string : "Error : this document already exists"
                // 20 => number of docs distributed
                // ["yoyo2000", "toto24"] => list of username where a distribution error occured
                // "devoir1-grp" => the name of the doc created
                var response = _manageJSON(data);
                if (typeof response == "object"){ // response has json format
                    if (response[1].length == 0){ // no error reported
                        var devoirnotif = documents_utils.formatString(documents_utils.NOTIF_DOC_DIST, response[2], response[0]);
                        documents_utils.afficherNotification("success", "Distribution", devoirnotif);
                    }else{ // some users in error
                        var devoirerrnotif = documents_utils.formatString(documents_utils.NOTIF_DOC_DIST_ERR, response[2], response[0], response[1].join(', '));
                        documents_utils.afficherNotification("warning", "Distribution", devoirerrnotif, true);
                    }
                }else{ // response is a string error message
                    documents_utils.afficherNotification("danger", "Erreur", response.substr(0,200), true);
                }
            },
            error : function (data) {
                documents_utils.afficherNotification("danger", "Erreur", "Impossible de contacter le serveur.", true);
            }
        });
    };


    // Public Members
    return {
        "refTableau" : 0,   // reference to the DataTables object
        "refDocs" : {},     // docs table for cache
        "refDels" : [],     // cache list of docs datas that can be deleted
        "listeDestinataires" : [],   // list of recipient groups

        "NOTIF_TITRE" : "Transfert de {1} : {2} !",
        "NOTIF_ERR_SIZE" : "Fichier trop gros ! ({1}Mo maxi)",
        "NOTIF_TEXTE" : "Le fichier {1} a bien été transféré.",
        "NOTIF_DOC_DIST" : "{1} a été distribué à {2} personne(s).",
        "NOTIF_DOC_DIST_ERR" : "{1} a été distribué à {2} personne(s), et il y a eu des erreurs pour : {3}.",
        "NOTIF_DOC_PICK" : "{1} a été ramassé pour {2} personne(s).",
        "NOTIF_DOC_PICK_ERR" : "{1} a été ramassé pour {2} personne(s), et il y a eu des erreurs pour : {3}.",
        "NOTIF_DOC_COR" : "{1} a été corrigé pour {2} personne(s).",
        "NOTIF_DOC_COR_ERR" : "{1} a été corrigé pour {2} personne(s), et il y a eu des erreurs pour : {3}.",
        "NOTIF_DOC_DEL" : "La suppression des données de {1} a été effectuée.",

        "cacheDocs" : function() {
            // Fills the documents_utils.refDocs table with all the user's docs for cache
            $.getJSON("api/documents/", function(data) {
                var response = _manageJSON(data);
                if (typeof response == "object"){ // response has json format
                    documents_utils.refDocs = response;
                }
            });
        },

        "cacheDels" : function() {
            // Fills the documents_utils.refDels list with all docs datas that can be deleted for cache
            //{"DevoirsASupprimer": ['dev_yo2-yo_grp', 'dev_yo4-yo_grp', 'devoir-yo-2-yo_grp', 'devoir-yo-3-yo_grp']}
            $.getJSON("api/documents/todel", function(data) {
                documents_utils.refDels = [];
                $.each(data, function(i, dev) {
                    documents_utils.refDels.push(dev);
                });
            });
        },

        "parseHtmlResponse" : function(html_response) {
            // Parse the html response error from the server and returns the error status
            // ex : "<html><head><title>413 Request Entity Too Large</title></head><body bgcolor="white"><center><h1>413 Request Entity Too Large</h1></center><hr><center>nginx/1.4.6 (Ubuntu)</center></body></html>"
            if (html_response !== undefined){
                var el = document.createElement("html");
                el.innerHTML = html_response;
                var html_err = el.getElementsByTagName("title")[0].textContent; // ex : "413 Request Entity Too Large"
                return html_err.substr(html_err.indexOf(" ")+1); // "Request Entity Too Large"
            } else {
                return "";
            }
        },

        "filterDocs" : function(filter) {
            // Filters the documents_utils.refDocs table on the state and returns
            //{"dist1":{"groupe":"yo_grp","state":"dist","in_perso":true,"eleve_only":true}, "dist2":{"groupe":"yo_grp","state":"dist","in_perso":true,"eleve_only":true}, "ram3":{"groupe":"yo_grp","state":"ram","in_perso":true,"eleve_only":true}, "ram4":{"groupe":"yo_grp","state":"ram","in_perso":true,"eleve_only":true}, "ren5":{"groupe":"yo_grp","state":"ren","in_perso":true,"eleve_only":true}, "ren6":{"groupe":"yo_grp","state":"ren","in_perso":true,"eleve_only":true}}
            var list_key = $.map(documents_utils.refDocs, function(value, key) {return key;}).sort(); // lists the json keys and sorts them
            var list_docs = {};
            $.each(list_key, function(i, key) {
                if (documents_utils.refDocs[key]["state"] == filter) {
                    list_docs[key] = documents_utils.refDocs[key];
                }
            });
            return list_docs;
        },

        "loadGroups" : function() {
            // Loads all the groupsof the server and put them in the refGroups variable
            _getGroups("classe");
            _getGroups("niveau");
            _getGroups("matiere");
            _getGroups("option");
            _getGroups("equipe");
            _getGroups("groupe");
        },

        "remplirGroupes" : function() {
            // Fills the group list based on the refGroups variable
            //refGroups = {"matieres": [], "classes": ["c3", "c31", "c32"], "niveaux": ["3eme", "4eme"], "groupes": [], "equipes": ["profs-c3", "profs-c31", "profs-c32"]};
            var listecle = $.map(refGroups, function(value, key) {return key;}).sort(); // lists the json keys and sorts them
            var items = [];
            $.each(listecle, function(i, cle) {
                if (refGroups[cle].length != 0) {
                    items.push("<optgroup label=\"" + cle[0].toUpperCase() + cle.substring(1) + "\">");
                    $.each(refGroups[cle], function(i, val) {
                        items.push("<option label=\"" + val + "\">" + val + "</option>");
                    });
                    items.push("</optgroup>");
                }
            });
            items.unshift("<option label=\"(vide)\"></option>"); // Place an empty value at the beginning
            $("#groupe").html(items.join(""));
            $("#groupe").attr("data-placeholder", " ");
            $("#groupe").chosen({ width: $("#groupe").css("width"), no_results_text: "Pas de résultats pour" });
        },

        "remplirFichTemp" : function(role) {
            // Ajax call to populate list of uploaded temp files
            // role = "data" ou "devoir"
            ////{"listedoc":["yoyo2000.gif","1_005.png","yoyo2000.png"]}
            $.getJSON("api/files/" + role, function(data) {
                var resultat = _formattingTempFiles(data, role);
                if (resultat != "Aucun document"){
                    $("#tempfichdevoir").removeClass("text-danger");
                    $("#tempfichdevoir").siblings("span").removeClass("text-danger");
                }
                $("#tempfich"+role).html(resultat);
            });
        },

        "remplirListDevRamasser" : function() {
            // Populates list of docs to pick using documents_utils.refDocs variable
            ////{"devoir-yo-2-yo_grp":{"groupe":"yo_grp", "timestamp": 1396604212.584942, "state":"dist","in_perso":true,"eleve_only":true},"devoir-yo-3-yo_grp":{"groupe":"yo_grp", "timestamp": 1396604212.584942, "state":"dist","in_perso":true,"eleve_only":true},...}
            var data = documents_utils.filterDocs("dist");
            $("#list_dev_a_ram").html(_formattingDocs(data));
            $("#list_dev_a_ram").attr("data-placeholder", " ");
            $("#list_dev_a_ram").chosen({ width: $("#groupe").css("width"), no_results_text: "Pas de résultats pour" });
            $("#list_dev_a_ram").trigger("chosen:updated");
        },

        "remplirListDevRendre" : function() {
            // Populates list of docs to correct using documents_utils.refDocs variable
            ////{"devoir-yo-4-yo_grp":{"groupe":"yo_grp", "timestamp": 1396604212.584942, "state":"ram","in_perso":true,"eleve_only":true},...}
            var data = documents_utils.filterDocs("ram");
            $("#list_dev_a_ren").html(_formattingDocs(data));
            $("#list_dev_a_ren").attr("data-placeholder", " ");
            $("#list_dev_a_ren").chosen({ width: $("#groupe").css("width"), no_results_text: "Pas de résultats pour" });
            $("#list_dev_a_ren").trigger("chosen:updated");
        },

        "remplirTableauHistorique" : function() {
            // Populate docs list for display using documents_utils.refDocs variable and documents_utils.refDels
            ////{"devoir-yo-2-yo_grp":{"groupe":"yo_grp", "timestamp": 1396604212.584942, "state":"dist","in_perso":true,"eleve_only":true},"devoir-yo-3-yo_grp":{"groupe":"yo_grp", "timestamp": 1396604212.584942, "state":"dist","in_perso":true,"eleve_only":true},...}
            var items = [];
            var listecle = $.map(documents_utils.refDocs, function(value, key) {return key;}).sort(); // lists the json keys and sorts them
            $.each(listecle, function(i, cle) {
                var infosdev = _genInfosDocs(documents_utils.refDocs[cle]);
                if (documents_utils.refDels.indexOf(cle) != -1){
                    infosdev["action"] += " <a class=\"btn btn-danger supprimer\">Supprimer <span class=\"fa fa-times\"></span></a>";
                }
                items.push("<tr class=\"" + infosdev["styledev"] + "\" data-name=\"" + cle + "\"><td>" + cle + "</td><td>" + documents_utils.refDocs[cle]["groupe"] + "</td><td>" + infosdev["date"] + "</td><td>" + infosdev["eleve_seul"] + "</td><td>" + infosdev["etat"] + "</td><td class=\"droite\">" + infosdev["action"] + "</td>");
            });
            if (documents_utils.refTableau != 0) {
                // the table already existed so just refresh
                $("#tableauhistorique").hide();
                documents_utils.refTableau.destroy();
            }
            $("#tableauhistorique tbody").html(items.join(""));
            documents_utils.refTableau = $("#tableauhistorique").DataTable( {
                "processing": true,
                "stateSave" : true,
                "pagingType" : "simple",
                "autoWidth": false,
                "columnDefs": [
                    //{ "targets": 0, "width": "20%"  },
                    { "targets": 1, "width": "15%"  },
                    { "targets": 2, "width": "15%", "type": "date",  },
                    { "targets": 3, "width": "10%" },
                    //{ "targets": 4, "width": "15%" },
                    { "targets": 5, "width": "25%", "orderable": false }
                ],
                "order": [[ 4, "asc" ]],
                "language": { "url": "static/js/dataTables.txt" }
            } );
            documents_utils.refTableau.draw(false);
            $("#tableauhistorique").show();
        },

        "afficherNotification" : function(type, titre, texte, fixe) {
            // Displays a notification with the jGrowl plugin
            fixe = fixe || false; // if fixe is not defined then false
            var duree = 10000;     // in ms
            // boostrap style (danger, success, info, or empty for default style)
            var style = (type != "") ? "alert alert-block alert-" + type : "alert alert-block";
            if (fixe) {
                style += " opaque";
            }
            $.jGrowl.defaults.position = "bottom-right";   // initializing the position of notifications

            $.jGrowl(texte, {theme: style, life: duree, header: titre, sticky: fixe});
        },

        "formatString" : function() {
            // Remplaces the strings {x} (with x starting at 1)
            // 1rst parameter = the string template
            // next parameters = the pieces of string to include
            // formatString("{1} c'est trop {2} !", "Ubuntu", "super") ==> "Ubuntu c'est trop super !"
            var args = [].slice.call(arguments);
            var pattern = new RegExp("{([1-" + args.length + "])}","g");
            return String(args[0]).replace(pattern, function(match, index) { return args[index]; });
        },

        "validationReferenceDevoir" : function() {
            // Checks if the document reference not already exists
            // Return false if the doc reference is not filled or if it's already used
            var validation = true;
            var $elem = $("#nomdev");
            var refdev = $elem.val();
            if (refdev != ""){
                if(refdev.indexOf("/") != -1){
                    validation = false;
                    _addValidationMessage($elem, "La référence ne doit pas contenir le caractère '/'.");
                }else{
                    // Get the secure filename for refdev
                    $.ajaxSetup({async:false});  // forcing synchronious ajax call
                    $.getJSON("api/securename/"+refdev, function(data) {
                        if (data != ""){
                            refdev = data;
                        }else{
                            documents_utils.afficherNotification("danger", "Erreur", "La référence du devoir ne doit pas être vide !", true);
                        }
                    });
                    $.ajaxSetup({async:true});  // back to defaults

                    // getting the doc list
                    var listedevoirs = $.map(documents_utils.refDocs, function(value, key) {return key;}).sort(); // lists the json keys and sorts them

                    // Checking if a doc of the form "refdev-dest" already exists for one or more "dest" recipients
                    var groupes_interdits = "";
                    $.each(documents_utils.listeDestinataires, function(i,dest){
                        if (listedevoirs.indexOf(refdev+"-"+dest) != -1){
                            groupes_interdits += ", " + dest;
                        }
                    });
                    if (groupes_interdits.length > 0){
                        validation = false;
                        _addValidationMessage($elem, "Cette référence est déjà utilisée pour " + groupes_interdits.substr(2) + ".");
                    }else{
                        _deleteValidationMessage($elem);
                    }
                }
            }else{
                _addValidationMessage($elem, "Une référence doit être fournie.");
                validation = false;
            }
            return validation;
        },

        "validationDestinataire" : function() {
            // Checks if a group has been selected
            // Return false if no group is selected
            var validation = true;
            var $elem = $("#tempdestinataire");
            if (documents_utils.listeDestinataires.length == 0){
                $elem.addClass("text-danger");
                $("#lbldest").addClass("text-danger");
                validation = false;
            }else{
                $elem.removeClass("text-danger");
                $("#lbldest").removeClass("text-danger");
            }
            return validation;
        },

        "validationDocuments" : function() {
            // Checks whether at least one file is found in the temp folder
            // Return false if no document file was uploaded
            var validation = true;
            var $elem = $("#tempfichdevoir");
            if ($elem.text() == "Aucun document"){
                $elem.addClass("text-danger");
                $elem.siblings("span").addClass("text-danger");
                validation = false;
            }else{
                $elem.removeClass("text-danger");
                $elem.siblings("span").removeClass("text-danger");
            }
            return validation;
        },

        "submitDistribuer" : function() {
            var refdev = $("#nomdev").val();
            var eleve_only = $("#chxEleveOnly").find(":checked").val() == "eleve";
            var in_perso = $("#chxInPerso").find(":checked").val() == "perso";
            var envoimail = $("#dist_envoi_mail").prop("checked");
            var sujetmail = $("#dist_sujet_mail").prop("value");
            var corpsmail = $("#dist_corps_mail").prop("value");

            $.ajaxSetup({async:false})  // for the ajax call to be synchronous FIXME
            // Get the secure filename for refdev
            $.getJSON("api/securename/"+refdev, function(data) {
                if (data != ""){
                    refdev = data;
                }
            });

            if (refdev != ""){
                $.each(documents_utils.listeDestinataires, function(i, dest){
                    documents_utils.refDels.push(refdev + "-" + dest);   // temporary add newly created document to the cache del for ajax reason
                    _copyTempFiles(refdev + "-" + dest);
                    _distributeDoc(refdev + "-" + dest, dest, eleve_only, in_perso);
                    if (envoimail){
                        _sendGroupMail(dest, sujetmail, corpsmail);
                    }
                });
            }
            documents_utils.cleaningTemp("devoir", false);
            documents_utils.cleaningTemp("data", false);
            documents_utils.cacheDocs();
            $.ajaxSetup({async:true})  // reset the ajax call to be asynchronous FIXME
            documents_utils.remplirListDevRamasser();
            documents_utils.remplirTableauHistorique();
            documents_utils.cacheDels();    // update cache del
            $("#nomdev").val("");   // emptying field référence$
            documents_utils.listeDestinataires = []; // empty the recipients list
            documents_utils.miseEnFormeDestinataires();
            $("body").removeClass("wait");
        },

        "submitRamasser" : function(refdev) {
            $("body").addClass("wait");
            $.ajax({
                type: "PUT",
                url: "api/documents/" + refdev,
                success: function (data) {
                    // Return json string : '[20, ["yoyo2000", "toto24"]' or in case of error return a string : "Error: You need a devname to talk to backend"
                    // 20 => number of docs collected
                    // ["yoyo2000", "toto24"] => list of username where an error occured
                    var response = _manageJSON(data);
                    if (typeof response == "object"){ // response has json format
                        if (response[1].length == 0){ // no error reported
                            var notif = documents_utils.formatString(documents_utils.NOTIF_DOC_PICK, refdev, response[0]);
                            documents_utils.afficherNotification("success", "Ramassage", notif);
                        }else{
                            var notif = documents_utils.formatString(documents_utils.NOTIF_DOC_PICK_ERR, refdev, response[0], response[1].join(', '));
                            documents_utils.afficherNotification("warning", "Ramassage", notif, true);
                        }
                        $.ajaxSetup({async:false});  // for the ajax call to be synchronous FIXME
                        documents_utils.cacheDocs();
                        documents_utils.remplirTableauHistorique();
                        documents_utils.remplirListDevRamasser();
                        documents_utils.remplirListDevRendre();
                        $.ajaxSetup({async:true});  // reset the ajax call to be asynchronous FIXME
                    }else{ // response is a string error message
                        documents_utils.afficherNotification("danger", "Erreur", response.substr(0,200), true);
                    }
                },
                error : function (data) {
                    documents_utils.afficherNotification("danger", "Erreur", "Impossible de contacter le serveur.", true);
                },
                complete : function (data) {
                    $("body").removeClass("wait");
                }
            });
        },

        "submitRendre" : function(refdev, envoimail) {
            $("body").addClass("wait");
            if(envoimail){
                var group = $("option:selected", $("#list_dev_a_ren")).data("group");
                var sujetmail = $("#ren_sujet_mail").prop("value");
                var corpsmail = $("#ren_corps_mail").prop("value");
            }
            if (refdev !== "(vide)") {
                $.ajax({
                    type: "PUT",
                    url: "api/documents/" + refdev + "/correction",
                    success: function (data) {
                        // Return json string : '[20, ["yoyo2000", "toto24"]' or in case of error return a string : "Error: You need a devname to talk to backend"
                        // 20 => number of docs corrected
                        // ["yoyo2000", "toto24"] => list of username where an error occured
                        var response = _manageJSON(data);
                        if (typeof response == "object"){ // response has json format
                            if (response[1].length == 0){ // no error reported
                                var notif = documents_utils.formatString(documents_utils.NOTIF_DOC_COR, refdev, response[0]);
                                documents_utils.afficherNotification("success", "Correction", notif);
                            }else{
                                var notif = documents_utils.formatString(documents_utils.NOTIF_DOC_COR_ERR, refdev, response[0], response[1].join(', '));
                                documents_utils.afficherNotification("warning", "Correction", notif, true);
                            }
                            if (envoimail){
                                _sendGroupMail(group, sujetmail, corpsmail);
                            }
                            $.ajaxSetup({async:false})  // for the ajax call to be synchronous FIXME
                            documents_utils.cacheDocs();
                            documents_utils.remplirTableauHistorique();
                            documents_utils.remplirListDevRendre();
                            $.ajaxSetup({async:true});  // reset the ajax call to be asynchronous FIXME
                        }else{ // response is a string error message
                            documents_utils.afficherNotification("danger", "Erreur", response.substr(0,200), true);
                        }
                    },
                    error : function (data) {
                        documents_utils.afficherNotification("danger", "Erreur", "Impossible de contacter le serveur.", true);
                    },
                    complete : function (data) {
                        $("body").removeClass("wait");
                    }
                });
            }
        },

        "submitSupprimer" : function(refdev) {
            $("body").addClass("wait");
            $.ajax({
                type: "DELETE",
                url: "api/documents/" + refdev,
                success: function (data) {
                    // Always return string : 'true'
                    var i = documents_utils.refDels.indexOf(refdev);
                    if (i > -1){ documents_utils.refDels.splice(i, 1) } // suppress directly in the cache for ajax reason
                    documents_utils.remplirTableauHistorique();
                    documents_utils.cacheDels();    // update cache
                    var notif = documents_utils.formatString(documents_utils.NOTIF_DOC_DEL, refdev);
                    documents_utils.afficherNotification("success", "Suppression", notif);
                },
                error : function (data) {
                    documents_utils.afficherNotification("danger", "Erreur", "Impossible de contacter le serveur.", true);
                },
                complete : function (data) {
                    $("body").removeClass("wait");
                }
            });
        },

        "removefileTemp" : function(typedocs, filename) {
            $("body").addClass("wait");
            $.ajax({
                type: "DELETE",
                url: "api/files/" + typedocs + "/" + filename,
                success: function (data) {
                    // Return string : "OK : File deleted" or "KO : File not deleted"
                    if (data.includes("OK")){
                        documents_utils.afficherNotification("info", "Suppression de fichier", "Le fichier a été supprimé.");
                        documents_utils.remplirFichTemp(typedocs);
                    }else{
                        documents_utils.afficherNotification("danger", "Suppression de fichier", "Le fichier n'a pas pu être supprimé.", true);
                    }
                },
                error : function (data) {
                    documents_utils.afficherNotification("danger", "Erreur", "Impossible de contacter le serveur.", true);
                },
                complete : function (data) {
                    $("body").removeClass("wait");
                }
            });
        },

        "cleaningTemp" : function(typedocs, avecNotif) {
            $("body").addClass("wait");
            $.ajax({
                type: "DELETE",
                url: "api/files/" + typedocs,
                success: function (data) {
                    // Return string : "OK : Directory empty" or "KO : Directory not empty"
                    if (data.includes("OK")){
                        if (avecNotif){
                            documents_utils.afficherNotification("info", "Suppression de fichier", "Le dossier a été vidé.");
                        }
                        documents_utils.remplirFichTemp(typedocs);
                    }else{
                        if (avecNotif){
                            documents_utils.afficherNotification("danger", "Suppression de fichier", "Le dossier n'a pas pu être vidé.", true);
                        }
                    }
                },
                error : function (data) {
                    documents_utils.afficherNotification("danger", "Erreur", "Impossible de contacter le serveur.", true);
                },
                complete : function (data) {
                    if (avecNotif){
                        $("body").removeClass("wait");
                    }
                }
            });
        },

        "miseEnFormeDestinataires" : function() {
            // Uses the list of recipients to compute the corresponding html
            var resultat;
            var items = [];
            $.each(documents_utils.listeDestinataires, function(i, dest) {
                items.push("<div class=\"well-sm btn-group\">\n");
                items.push("<a class=\"btn btn-danger supdestinataire\" data-name=\"" + dest + "\"><span class=\"fa fa-times\"></span></a>\n");
                items.push("<a class=\"btn btn-default disabled\">" + dest +"</a>\n");
                items.push("</div>\n");
            });
            if (items.length !== 0) {
                items.unshift("<a class=\"btn-link pull-right viddestinataires\">Vider la liste</a>");
                resultat = items.join("");
            }else{
                resultat = "Aucun destinataire";
            }
            $("#tempdestinataire").html(resultat);
        },

        "remplirModal" : function() {
            var refdev = $("#nomdev").val();
            var eleve_only = $("#chxEleveOnly").find(":checked").val() == "eleve";
            var in_perso = $("#chxInPerso").find(":checked").val() == "perso";
            var envoimail = $("#dist_envoi_mail").prop("checked");
            var sujetmail = $("#dist_sujet_mail").prop("value");
            var corpsmail = $("#dist_corps_mail").prop("value");

            $("#recap-ref").html(refdev);
            var groupes = "";
            $.each(documents_utils.listeDestinataires, function(i, grp){
                groupes += '<button type="button" class="btn btn-default" disabled="disabled">'+grp+"</button>&nbsp;";
            });
            $("#recap-groupes").html(groupes);
            $("#recap-eleveonly").html(eleve_only ? "Uniquement aux élèves" : "À tous les membres");
            var $listeDevTemp = $("#tempfichdevoir a.disabled").filter("a");
            var devoirs = "";
            $.each($listeDevTemp, function(i, dev){
                devoirs += '<button type="button" class="btn btn-danger" disabled="disabled">'+dev.innerHTML+'</button>&nbsp;';
            });
            $("#recap-dev").html(devoirs);
            var $listeDataTemp = $("#tempfichdata a.disabled").filter("a");
            if ($listeDataTemp.length > 0){
                var datas = "";
                $.each($listeDataTemp, function(i, dat){
                    datas += '<button type="button" class="btn btn-success" disabled="disabled">'+dat.innerHTML+'</button>&nbsp;';
                    });
                $("#recap-data").html(datas);
            }
            else{
                $("#recap-data").html('aucun');
            }
            $("#recap-inperso").html(in_perso ? "Distribuer immédiatement" : "Distribuer plus tard");
            if (envoimail){
                $("#recap-envoimail").html('oui');
                $("#recap-divmail").show();
                $("#recap-sujet").html(sujetmail);
                $("#recap-mail").html(corpsmail);
            }
            else{
                $("#recap-envoimail").html('non');
                $("#recap-divmail").hide();
            }
        },

        "gestionActivationDistMail" : function (){
            // Show / hide mail fields
            if ($("#dist_envoi_mail").prop('checked')){
                $("#group-dist_sujet_mail").show("slow");
                $("#group-dist_corps_mail").show("slow");
            }else{
                $("#group-dist_sujet_mail").hide("slow");
                $("#group-dist_corps_mail").hide("slow");
            }
        },

        "gestionActivationRenMail" : function (){
            // Show / hide mail fields for "rendre"
            if ($("#ren_envoi_mail").prop('checked')){
                $("#group-ren_sujet_mail").show("slow");
                $("#group-ren_corps_mail").show("slow");
            }else{
                $("#group-ren_sujet_mail").hide("slow");
                $("#group-ren_corps_mail").hide("slow");
            }
        },

        "querystring" : function (){
            // Returns an object containing the querystring if exists
            var vars = {}, hash;
            var q = document.URL.split('?')[1];
            if(q != undefined){
                q = q.split('&');
                for(var i = 0; i < q.length; i++){
                    hash = q[i].split('=');
                    vars[hash[0]] = hash[1];
                }
            }
            return vars;
        }
    };
})();
