# -*- coding: UTF-8 -*-
from flask import Blueprint, current_app, session, json, request
from xmlrpclib import ServerProxy
from flask.views import MethodView
from eop.modules.api import membersapi, ldapusersapi
from eoleauthlib.authclient import login_required

profsapi = Blueprint('profsapi', __name__, url_prefix='/api/profs/')

class ProfsAPI(MethodView):
    decorators = [login_required]

    def __init__(self):
        self.username = session["username"]
        self.proxy = ServerProxy(current_app.config['CONTROLEVNC_URL'])
        self.secret = current_app.config['SECRET_KEY']

    def get(self, etabs):
        """Returns a list of members of etabs
        """
        if etabs is not None:
            proflist = self.proxy.remote_etabs_profs([etabs])
            return json.dumps(proflist)
        else:
            return json.dumps([])

    def post(self):
        raise NotImplementedError

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("profs_api")
        mod.add_url_rule('', view_func=f, methods=["GET"],
                         defaults={"etabs": None})
        mod.add_url_rule('<etabs>', view_func=f, methods=['GET'])


ProfsAPI.register(profsapi)
