"use strict";

var select_groups_events =  (function() {

    jQuery(document).ready(function ($) {

        // Adding a group
        $("#select-groups-group-selection").on({change : function(e){
            if($("option:selected", $(this)).html() != ""){
                select_groups_widget.addGroup($("option:selected", $(this)).attr("label"));
            }
            $("option:selected", $(this)).removeAttr("selected");  // empty the selected group
            $(this).trigger("chosen:updated");  // chosen plugin refresh
            select_groups_widget.formatSelectedGroups();
        }});

        // Suppress one of the selected groups
        $(document).on("click", ".suppress-group", function(event){
            var group = $(this).data("name");
            var index = select_groups_widget.selectedGroups.indexOf(group);
            if(index != -1) select_groups_widget.selectedGroups.splice(index, 1);
            select_groups_widget.formatSelectedGroups();
        });

        // Empty selected groups
        $(document).on("click", ".empty-groups", function(event){
            select_groups_widget.selectedGroups = [];
            select_groups_widget.formatSelectedGroups();
        });

    });
})();

var select_groups_widget = (function() {
    // Private Members

    function _manageJSON(data){
        // Checks if a string has the json format
        // if true returns an object else return the same string
        var response;
        try{
            response = $.parseJSON(data);
        }catch(e){
            response = data;
        }
        return response;
    };

    function _fillGroups(grouplist) {
        // Fills the group-selection list
        var items = [];
        $.each(grouplist, function(i, cle) {
            items.push("<option label=\"" + cle + "\">" + cle + "</option>");
        });
        items.unshift("<option label=\"(vide)\"></option>"); // Place an empty value at the beginning
        $("#select-groups-group-selection").html(items.join(""));
        $("#select-groups-group-selection").attr("data-placeholder", " ");
        $("#select-groups-group-selection").chosen({ width: $("#select-groups-group-selection").css("width"), no_results_text: "Pas de résultats pour" });
        $("#select-groups-group-selection").trigger("chosen:updated");  // chosen plugin refresh
    };

    // Public Members
    return {
        "selectedGroups" : [],   // list of selected groups

        "loadGroups" : function(grouplist) {
            _fillGroups(grouplist);
        },

        "addGroup" : function(group) {
            if (select_groups_widget.selectedGroups.indexOf(group) == -1){
                select_groups_widget.selectedGroups.push(group);
            }
        },
        
        "validateSelectedGroups" : function() {
            // Checks if a group has been selected
            // Return false if no group is selected
            var validation = (select_groups_widget.selectedGroups.length > 0);
            if (validation){
                $("#select-groups-selection-list-label").removeClass("text-danger");
                $("#select-groups-selection-list").removeClass("text-danger");
            }else{
                $("#select-groups-selection-list-label").addClass("text-danger");
                $("#select-groups-selection-list").addClass("text-danger");
            }
            return validation;
        },

        "formatSelectedGroups" : function() {
            // Uses the list of selected groups to compute the corresponding html
            var resultat;
            var items = [];
            $.each(select_groups_widget.selectedGroups, function(i, group) {
                items.push("<div class=\"well-sm btn-group\">\n");
                items.push("<a class=\"btn btn-danger suppress-group\" data-name=\"" + group + "\"><i class=\"fa fa-times\"></i></a>\n");
                items.push("<a class=\"btn btn-default disabled\">" + group +"</a>\n");
                items.push("</div>\n");
            });
            if (items.length !== 0) {
                items.unshift("<a class=\"btn-link pull-right empty-groups\">Vider la liste</a>");
                resultat = items.join("");
            }else{
                resultat = "Aucune sélection.";
            }
            $("#select-groups-selection-list").html(resultat);
            // to remove the warning when adding to an empty list
            if(select_groups_widget.selectedGroups.length > 0){
                select_groups_widget.validateSelectedGroups();
            }
        }
    };
})();
