# -*- coding: UTF-8 -*-
import smtplib
import xmlrpclib
import os
from string import ascii_lowercase, ascii_uppercase, digits
from random import randint, shuffle
from flask import current_app, session, request, url_for, json
from eoleflask.util import get_proxy_url
from werkzeug import secure_filename
from email.mime.text import MIMEText

COMMASPACE = ', '

## Various tools

def formate_date(date, sep='/'):
    """
    formate une date "américaine" (ex : attribut dateNaissance)
    en date "française" avec ou sans séparateur
    """
    try:
        if '/' in date:
            year, month, day = date.split('/', 2)
        elif '-' in date:
            year, month, day = date.split('-', 2)
        elif len(date) == 8:
            year, month, day = (date[6:8], date[4:6], date[0:4])
        else:
            return date
    except ValueError:
        return date
    if len(year) == 4:
        return sep.join((day, month, year))
    elif len(day) == 4:
        # la date était déjà à l'anglaise !
        return sep.join((year, month, day))
    else:
        return date

def send_mail(smtp_server="", mailFrom="", mailTo=[], mailSubject="", text=""):
    """Envoi simple de mail text
    """
    if len(mailTo) > 0:
        msg = MIMEText(text, "plain", "utf-8")
        msg['Subject'] = mailSubject
        msg['From'] = mailFrom
        msg['To'] = COMMASPACE.join(mailTo)
        msg.preamble = mailSubject

        orig_timeout = smtplib.socket.getdefaulttimeout()
        try:
            smtplib.socket.setdefaulttimeout(10)
            s = smtplib.SMTP("127.0.0.1")
            s.sendmail("root@localhost.{}".format(current_app.config['DOMAINE_MAIL']), mailTo, msg.as_string())
            s.quit()
        except Exception, err:
            current_app.logger.error(u"Problème lors de l'envoi des mail : {0}".format(err))
        smtplib.socket.setdefaulttimeout(orig_timeout)

def secure_arg(arg=None):
    """Returns arg for secure file names
    """
    if arg is not None:
        return secure_filename(arg).lower()
    else:
        return None

def est_prof():
    """Returns true if username is a teacher
    """
    username = session.get('username', None)
    secret = current_app.config["SECRET_KEY"]
    proxy = xmlrpclib.ServerProxy(current_app.config["CONTROLEVNC_URL"])
    return proxy.remote_est_prof(secret, username)

def est_admin():
    """Returns true if username is an admin
    """
    username = session.get('username', None)
    secret = current_app.config["SECRET_KEY"]
    proxy = xmlrpclib.ServerProxy(current_app.config["CONTROLEVNC_URL"])
    return  proxy.remote_est_admin(username)

def est_admin_etab():
    """Returns true if username is an admin
    """
    username = session.get('username', None)
    secret = current_app.config["SECRET_KEY"]
    proxy = xmlrpclib.ServerProxy(current_app.config["CONTROLEVNC_URL"])
    return  proxy.remote_est_admin_etab(username)

def user_get_attr(attr, user=None):
    """Returns the given attribute <attr> in ldap for user <user>
       if user is None then the current logged user is used
    """
    username = session.get('username', None)
    secret = current_app.config["SECRET_KEY"]
    proxy = xmlrpclib.ServerProxy(current_app.config["CONTROLEVNC_URL"])
    if user is None:
        user = username
    return proxy.remote_get_attr(secret, username, user, attr)

def get_user_menus():
    """Return the menus allowed for the current user
    """
    if "menus" not in session:
        # MENUS CONFIGURATION

        # Load menus configuration, filled while browsing the conf files
        path_menus = os.path.join(os.path.dirname(current_app.static_folder), 'menus')

        if not os.path.isdir(path_menus):
            current_app.logger.warning('Menus folder not found !')

        menus_configfile = os.path.join(path_menus, '__menus__.conf')
        if os.path.isfile(menus_configfile):
            current_app.logger.info('Loading menus configuration file "{0}"'.format(menus_configfile))
            menus = json.loads(file(menus_configfile).read().decode('utf-8'))['MENUS']
        else:
            menus = list()
            current_app.logger.warn('No menus configuration file "{0}": skipping'.format(menus_configfile))

        conf_files_list = [os.path.join(path_menus, f) for f in os.listdir(path_menus) if f != '__menus__.conf']

        #loading config files in variable menus
        for configfile in conf_files_list:
            if os.path.isfile(configfile):
                current_app.logger.info('Loading configuration file "{0}"'.format(configfile))
                try:
                    config = json.loads(file(configfile).read().decode('utf-8'))
                    #Adding the content of config to variable menus
                    try:
                        for menu_item in config['items']:
                            main_menu = menu_item['top-menu']
                            for menu in menus:
                                active = True
                                if "active" in menu_item['menu-item'] :
                                    if  menu_item['menu-item']["active"] == "false":
                                        active = False
                                if active:
                                    if menu['name'] == main_menu:
                                        menu['menu-items'].append(menu_item['menu-item'])
                    except Exception, e:
                        current_app.logger.warning('The configuration file content does not match the expected syntax, the menu will not be created!')

                except Exception, e:
                    current_app.logger.warning('Configuration file "{0}" does not contain valid JSON, check your syntax!'.format(configfile))

        # user's typeadmin from the ldap
        # 0 : prof ; 1 : admin ; 2 : prof_admin
        typeadmin_list = user_get_attr('typeadmin')
        if len(typeadmin_list) == 0:
            return []

        user_typeadmin = int(typeadmin_list[0])

        # used to map the names to the typeadmin values
        typeadmin = ["prof", "admin", "prof_admin"]
        etabadmin = est_admin_etab()
        session["menus"] = []
        prepath = get_proxy_url(request, url_for("index.show", _external=True)).replace("/index", "")
        for menu in menus:
            items = []
            for item in menu['menu-items']:
                if (typeadmin[user_typeadmin] in item['typeadmin']):
                    if "link" in item:
                        if prepath not in item["link"]:
                            item["link"] = prepath + item["link"]
                    items.append(item)
                if "etab_admin" in item :
                    if etabadmin and ("etab_admin" in item["etab_admin"]):
                        if "link" in item:
                            if prepath not in item["link"]:
                                item["link"] = prepath + item["link"]
                        items.append(item)
            if len(items) > 0:
                if "link" in menu:
                    if prepath not in menu["link"]:
                        menu["link"] = prepath + menu["link"]
                session["menus"].append({'name': menu['name'], 'icon': menu['icon'], 'link': menu['link'], 'menu-items': items})
    return session["menus"]

## Password tools

class PasswordCheckError(Exception):
    def __init__(self, value):
        self.value = value
    def __str__(self):
        return repr(self.value)

def check_password(username, password):
    """ Checking if a password is long enough and contains enough different kinds of characters
    """
    nb_car_min = current_app.config['NB_CAR_MIN']
    nb_classe_min = current_app.config['NB_CLASSE_MIN']
    no_username_in_pwd = current_app.config['NO_USERNAME_IN_PWD']
    if password.find(username) != -1 :
        raise PasswordCheckError("Erreur : votre mot de passe ne doit pas contenir votre nom d'utilisateur")
    if len(password) < nb_car_min:
        raise PasswordCheckError("Erreur : votre mot de passe doit comporter au moins %s caractères." % nb_car_min)
    proxy = xmlrpclib.ServerProxy(current_app.config["CONTROLEVNC_URL"])
    if not proxy.remote_check_nb_min_classes(current_app.config['SECRET_KEY'], password, nb_classe_min):
        raise PasswordCheckError(u"Erreur : veuillez utiliser au moins %s classes de caractère." % nb_classe_min)
    return password

def generate_random_password():
    """ Generating a random password that is long enough and contains enough different kinds of characters.
    """
    nb_car_min = current_app.config['NB_CAR_MIN']
    char_types = [ascii_lowercase, ascii_uppercase, digits, '!&*+-<=>?@']
    password = ''
    # Constructing password with one kind of character in turn. This ensures that 'password' will have enough kinds of character
    # Generated password is at least 8 characters long
    for i in range(max(8, nb_car_min)):
        current_type = char_types[i % 4]
        password += current_type[randint(0, len(current_type)-1)]

    pass_as_list = list(password)
    shuffle(pass_as_list)
    password = ''.join(pass_as_list)
    return password

def get_list_profs(classe=None):
    """Returns the prof list that are admin of <classe> from the ldap with some other informations
       When classe is None, all the prof and the classes admin by current user are listed
       => [{"login": "nom prenom",...}, {"class1": ["login1",...], ...}]
       When a classe is provided, only the list of the admin of this class are listed
       => {"class1": ["login1",...]}
    """
    username = session.get('username', None)
    secret = current_app.config["SECRET_KEY"]
    proxy = xmlrpclib.ServerProxy(current_app.config["CONTROLEVNC_URL"])
    if classe is None:
        return proxy.remote_get_list_profs(secret, username, "")
    else:
        return proxy.remote_get_list_profs(secret, username, classe)
