"use strict";

var passperso = (function() {

    jQuery(document).ready(function ($) {

        // Hiding empty help zones
        $("#old-pass-check").hide();
        $("#complexity-check").hide();
        $("#same-new-pass-check").hide();

        // First disable retype-password input
        $("#retype-new-password-input").prop('disabled', true);

        // Removing warnings when retyping the old password
        $(document).on("keyup", "#old-password-input", function(event){
            passperso_utils.remove_retype_warnings($('#old-password'), $("#old-pass-check"));
        });

        // Removing warnings when retyping the new password
        $(document).on("keydown", "#retype-new-password-input", function(event){
            passperso_utils.remove_retype_warnings($('#retype-new-password'), $("#same-new-pass-check"));
        });

        // hiding the alert notification
        $(document).on("click", ".close.notification", function(event){
            $("#passperso-result-message").hide("slow");
        });

        // popover allows to display a popup for tooltip help
        $("a[data-toggle=popover]").popover({html : true}).click(function(e) {
            $("a[data-toggle=popover]").not(this).popover('hide'); // hide all other popover
            e.preventDefault();
        });

        // Checking for a correct password while typing
        $(document).on("keyup", "#new-password-input", function(event){
            passperso_utils.check_password();
            // empty the retype field and remove its warnings
            passperso_utils.remove_retype_warnings($('#retype-new-password'), $("#same-new-pass-check"));
        });

        // Validate and submit change password form
        $(document).on("click", "#btnSubmitPassword", function(event){
            // checking new password
            var validation = passperso_utils.check_password();

            if ($("#new-password-input").val().length == 0){
                $("#new-password-input").trigger("keyup");   // To display error message due to password empty
            }

            // checking retype new password
            validation = validation && passperso_utils.check_retype_password();

            // old password should not be empty
            validation = validation && passperso_utils.check_old_password();

            if (validation){
                $("#passperso-result-message").hide("slow");
                passperso_utils.submitChangePassword();
            }
        });

    });
})();

