"use strict";

var select_profs_events =  (function() {

    jQuery(document).ready(function ($) {
        select_profs_widget.load();

        // Adding rights for the selected person
        $(".listprof").on({change : function(e){
            select_profs_widget.addRight($(this).data("classe"), $("option:selected", $(this)).attr("label"));
            $("option:selected", $(this)).removeAttr("selected");  // empty the selected eleve
        }});

        // Suppress rights for the selected person
        $(document).on("click", ".suppress-prof", function(event){
            select_profs_widget.removeRight($(this).data("classe"), $(this).data("name"));
        });

    });

})();

var select_profs_widget = (function() {
    // Private Members

    function _manageJSON(data){
        // Checks if a string has the json format
        // if true returns an object else return the same string
        try{
            data = data.replace(/'/g, '"');
            var response = $.parseJSON(data);
        }catch(e){
            var response = data;
        }
        return response;
    };

    function _fillListProfs(classe) {
        // Fills the html select based on the g_liste_profs variable
        //g_liste_profs = {'prenom.prof10': 'Toto10 Titi10', 'prenom.prof11': 'Toto11 Titi11', 'prenom.prof6': 'Toto6 Titi6'};
        var keys = $.map(g_liste_profs, function(value, key) {return key;}).sort(); // lists the json keys and sorts them
        var list_profsprinc = _manageJSON($("#select-prof-selection-list-" + classe).data("profsprinc"));
        var items = [];
        $.each(keys, function(i, cle) {
            if (g_liste_profs[cle].length != 0) {
                if ($.inArray(cle, list_profsprinc) == -1){    // only add not yet chosen persons
                    items.push("<option label=\"" + cle + "\">" + g_liste_profs[cle] + "</option>");
                }
            }
        });
        items.unshift("<option label=\"(vide)\"></option>"); // Place an empty value at the beginning
        var $listprof = $("#prof-selection-" + classe);
        $listprof.html(items.join("\n"));

        // initiate chosen on the prof list
        $listprof.chosen({ width: $("#select-prof-selection-list-" + classe).css("width"), no_results_text: "Pas de résultats pour" });
        $listprof.attr("data-placeholder", "Choisir une personne à ajouter");
        $listprof.trigger("chosen:updated");  // chosen plugin refresh
    };

    function _fillWidget(classe) {
        // Fills the rights for the class
        var $selection = $("#select-prof-selection-list-" + classe);
        var list_profsprinc = _manageJSON($selection.data("profsprinc"));
        var items = [];
        if ((list_profsprinc != "undefined") && (list_profsprinc.length != 0)){
            $.each(list_profsprinc, function(i, prof) {
                // Add the rights
                items.push("<div class=\"well-sm btn-group\">\n");
                items.push("<a class=\"btn btn-danger suppress-prof\" data-name=\"" + prof + "\" data-classe=\"" + classe + "\"><i class=\"fa fa-times\"></i></a>\n");
                items.push("<a class=\"btn btn-default disabled\">" + g_liste_profs[prof] +"</a>\n");
                items.push("</div>\n");
            });
        }else{
            items.push("<p>Aucune</p>");
        };
        $selection.html(items.join(""));

        _fillListProfs(classe);
    };

    // Public Members
    return {
        "load" : function() {
            // Loads all the profs widgets

            // Fill the right and the list for all the classes
            $( ".droits" ).each(function() {
                if ($(this).data("classe") != "undefined"){
                    _fillWidget($(this).data("classe"));
                }
            });
        },

        "addRight" : function(classe, login) {
            // Add class right for a login

            $.ajax({
                type: "POST",
                url: "api/droitsprof/",
                data: {"login":login, "classe":classe},
                success: function (data) {
                    // returned data is json string : {"classe1": ["login1", "login2",...]}
                    // list of all logins that have admin rights on classe1
                    var response = _manageJSON(data);
                    if (typeof response == "object"){ // response has json format
                        // Si ajout OK on récupère une nouvelle liste de prof admin et on met à jour la liste dans data("profsprinc")
                        $("#select-prof-selection-list-" + classe).data("profsprinc", response[classe]);
                    }else{ // response is a string error message
                        droitsprof.afficherNotification("danger", response.substr(0,200));
                    }
                },
                error : function (data) {
                    droitsprof.afficherNotification("danger", "Erreur : impossible de contacter le serveur.");
                },
                complete : function (data) {
                    _fillWidget(classe);
                    $('.grid').isotope();
                }
            });
        },

        "removeRight" : function(classe, login) {
            // Remove class right for a login

            $.ajax({
                type: "DELETE",
                url: "api/droitsprof/" + login + "/" + classe,
                success: function (data) {
                    // returned data is json string : {"classe1": ["login1", "login2",...]}
                    // list of all logins that have admin rights on classe1
                    var response = _manageJSON(data);
                    if (typeof response == "object"){ // response has json format
                        // Si suppression OK on récupère une nouvelle liste de prof admin et on met à jour la liste dans data("profsprinc")
                        $("#select-prof-selection-list-" + classe).data("profsprinc", response[classe]);
                    }else{ // response is a string error message
                        droitsprof.afficherNotification("danger", response.substr(0,200));
                    }
                },
                error : function (data) {
                    droitsprof.afficherNotification("danger", "Erreur : impossible de contacter le serveur.");
                },
                complete : function (data) {
                    _fillWidget(classe);
                    $('.grid').isotope();
                }
            });
        }
    }
})();