# -*- coding: UTF-8 -*-
from flask import Blueprint, session, request, current_app, json
from flask.views import MethodView
from eop.utils import check_password, PasswordCheckError
from xmlrpclib import ServerProxy
from eoleauthlib.authclient import login_required

ldappasswordpersoapi = Blueprint('ldappasswordpersoapi', __name__, url_prefix = '/api/ldappasswordperso/')

class LdappasswordpersoAPI(MethodView):
    decorators = [ login_required]

    def __init__(self):
        self.username = session["username"]
        self.proxy = ServerProxy(current_app.config['CONTROLEVNC_URL'])
        self.secret = current_app.config['SECRET_KEY']

    def get(self):
        raise NotImplementedError

    def post(self):
        """Set password of username to newpassword if oldpassword is correct
        """
        if self.username is None:
            current_app.logger.warning('Unbound use of the API, no session username defined!')
            return json.dumps('Error: You need a username to talk to backend')

        if None in request.form:
            current_app.logger.warning('Unbound use of the API by user %s.' %self.username)
            return json.dumps('Error in args')
        response = request.form

        oldpassword = response["oldpass"]
        newpassword = response["newpass"]

        if oldpassword is None:
            current_app.logger.warning('Unbound use of the API. User %s tried to bypass the frontend filtering: required old password is empty.' %self.username)
            return json.dumps('Error: You need a oldpassword to talk to backend')
        if newpassword is None:
            current_app.logger.warning('Unbound use of the API. User %s tried to bypass the frontend filtering: required password is empty.' %self.username)
            return json.dumps('Error: You need a newpassword to talk to backend')
        try:
            newpassword = check_password(self.username, newpassword)
        except PasswordCheckError, e:
            current_app.logger.warning('Attempt to bypass the frontend filtering! %s tried to set his own password without matching password policy.' %self.username)
            return json.dumps(e.value)

        return json.dumps(self.proxy.remote_change_mdp(self.secret, self.username, oldpassword, newpassword))

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("ldappasswordperso_api")
        mod.add_url_rule('', view_func=f, methods=["POST"])

LdappasswordpersoAPI.register(ldappasswordpersoapi)
