"use strict";

var tempusers_utils = (function() {
    // Private Members

    function _manageJSON(data){
        // Checks if a string has the json format
        // if true returns an object else return the same string
        try{
            var response = $.parseJSON(data);
        }catch(e){
            var response = data;
        }
        return response;
    };

    // Public Members
    return {
        "submitCreateTempUser": function(etab, nom, prenom, login, passwordformat, password, expire){
            $.ajax({
                type: "POST",
                url: "api/tempuser/",
                data: {"etab": etab, "nom": nom, "prenom": prenom, "login": login, "passwordformat": passwordformat, "password": password, "expire": expire},
                success: function (data) {

                    var response = _manageJSON(data);
                    if (typeof response == "object"){ // response has json format

                        var message = "La création du compte utilisateur <b>"+login+"</b> (mot de passe : "+response['password']+") a été exécuté";
                        tempusers_utils.afficherNotificationCreate("success", message);
                    }else{ // response is a string error message
                        tempusers_utils.afficherNotificationCreate("danger", response.substr(0,200));
                    }
                    $("#btnSubmitCreateTempUser").html("Créer <i class=\"fa fa-check-circle\"></i>");
                },
                error : function (data) {
                    tempusers_utils.afficherNotificationCreate("danger", "Erreur : impossible de contacter le serveur.");
                    $("#btnSubmitCreateTempUser").html("Créer <i class=\"fa fa-check-circle\"></i>");
                }

            });
        },
        "submitEditTempUser": function(user, typeaction, count){
          $.ajax({
              type: "POST",
              url: "api/tempuser/",
              data: {"actiontype": typeaction, "user": user, "count": count},
              success: function (data) {

                  var response = _manageJSON(data);
                  if (typeof response == "object"){ // response has json format

                      var message = "Compte utilisateur <b>"+user+"</b> "+ typeaction;
                      tempusers_utils.afficherNotificationEdit("success", message);
                  }else{ // response is a string error message
                      tempusers_utils.afficherNotificationEdit("danger", response.substr(0,200));
                  }
                  $("#btnSubmitEditTempUser").html("Appliquer <i class=\"fa fa-check-circle\"></i>");
              },
              error : function (data) {
                  tempusers_utils.afficherNotificationEdit("danger", "Erreur : impossible de contacter le serveur.");
                  $("#btnSubmitEditTempUser").html("Appliquer <i class=\"fa fa-check-circle\"></i>");
              }

          });
      },
        "activationActivateCompteTemp" : function (){
          // Show / hide common password field
          if ($("#option-activate").prop('checked')){
              $("#activate-comptetemp").show("slow");
              $("#activate-comptetemp-input").focus();
          }else{
              $("#activate-comptetemp").hide("slow");
          }
      },
        "afficherNotificationCreate" : function (type, message){
            var othertype;
            // type should be only "danger" or "success"
            if(type == "danger"){
                othertype = "success";
            }
            else{
                if(type == "success"){
                    othertype = "danger";
                }
                else{
                    return 0;
                }
            }
            $("#create-comptetemp-result-message").html("<button type=\"button\" class=\"close notification\">&times;</button>" + message);
            $("#create-comptetemp-result-message").removeClass("alert-" + othertype).addClass("alert-" + type);
            $("#create-comptetemp-result-message").show("slow");
            $("html, body").animate({ scrollTop: 0 }, "slow");
        },
        "afficherNotificationEdit" : function (type, message){
            var othertype;
            // type should be only "danger" or "success"
            if(type == "danger"){
                othertype = "success";
            }
            else{
                if(type == "success"){
                    othertype = "danger";
                }
                else{
                    return 0;
                }
            }
            $("#edit-comptetemp-result-message").html("<button type=\"button\" class=\"close notification\">&times;</button>" + message);
            $("#edit-comptetemp-result-message").removeClass("alert-" + othertype).addClass("alert-" + type);
            $("#edit-comptetemp-result-message").show("slow");
        },
        "check_expire_comptetemp" : function () {
          // return a boolean that tells wether the password entered by the user is correct
          var expire = parseInt($("#expire-input").val());
          var res = false;
          var message = "Durée d'activation : entre 1 et 14 jours.";
          if (expire < 1){
            "Durée d'activation : entre 1 et 14 jours.";
            $("#expire-input").val("1");
          }
          if (expire > 14){
            $("#expire-input").val("14");
            res=false;
          }else{
            res=true;
          }

          $("#expire-check-comptetemp").html(message);
          $("#expire-check-comptetemp").show("slow");
          return res;

      }
    };
})();
