"use strict";

var select_eleves_events =  (function() {

    jQuery(document).ready(function ($) {

        // filling the list of eleves when selecting a group
        $("#select-eleves-group-selection").on({change : function(e){
            $(this).trigger("chosen:updated");  // chosen plugin refresh
            select_eleves_widget.fillEleves($("option:selected", $(this)).attr("label"));
        }});

        // Adding an eleve or a whole group
        $("#eleve-selection").on({change : function(e){
            if($("option:selected", $(this)).html() != "Tous"){
                select_eleves_widget.addEleve($("option:selected", $(this)).attr("label"));
            }
            else{
                select_eleves_widget.addGroup($("option:selected", $(this)).attr("label"));
            }
            $("option:selected", $(this)).removeAttr("selected");  // empty the selected eleve
            $(this).trigger("chosen:updated");  // chosen plugin refresh
            select_eleves_widget.formatSelectedEleves();
        }});

        // Suppress one of the selected eleve
        $(document).on("click", ".suppress-eleve", function(event){
            var id = $(this).data("id");
            select_eleves_widget.removeEleve(id);
        });

        // Empty selected users
        $(document).on("click", ".empty-eleves", function(event){
            select_eleves_widget.selectedEleves = [];
            select_eleves_widget.formatSelectedEleves();
        });

        // Refresh eleves filtering
        $(".radio-inline.eleve-filter").on({change : function(e){
            select_eleves_widget.fillEleves($("option:selected", $("#select-eleves-group-selection")).attr("label"));
            select_eleves_widget.formatSelectedEleves();
        }});

    });
})();

var select_eleves_widget = (function() {
    // Private Members
    var groups = {}; // filled at startup
    var options = {'filter': "", 'eleve_button_enabled': false};

    function _manageJSON(data){
        // Checks if a string has the json format
        // if true returns an object else return the same string
        var response;
        try{
            response = $.parseJSON(data);
        }catch(e){
            response = data;
        }
        return response;
    };

    function _getEleves(grouplist){
        var url;
        $.each(grouplist, function(i, group) {
            // getting the list of eleves from a given group with the current filter
            url = "api/usersinfos/" + group;
            if (options['filter'] != ""){
                url += "/" + options['filter'];
            }
            $.getJSON(url, function(data) {
                var response = _manageJSON(data);
                if (typeof response == "object"){ // response has json format
                    groups[group] = response;
                }
            });
        });
    };

    function _fillGroups() {
        // Fills the group list based on the groups variable
        //groups = {"c31": ["c31e1", "c31e2", "c31e3"], "c32": ["c32e4", "c32e5", "c32e6"]};
          var keys = $.map(groups, function(value, key) {return key;}).sort(); // lists the json keys and sorts them
          var items = [];
          $.each(keys, function(i, cle) {
              if (groups[cle].length != 0) {
                  items.push("<option label=\"" + cle + "\">" + cle + "</option>");
              }
          });
          items.unshift("<option label=\"(vide)\"></option>"); // Place an empty value at the beginning
          $("#select-eleves-group-selection").html(items.join(""));
          $("#select-eleves-group-selection").attr("data-placeholder", " ");
          $("#select-eleves-group-selection").chosen({ width: $("#select-eleves-group-selection").css("width"), no_results_text: "Pas de résultats pour" });
          // selecting the first item
          $("#select-eleves-group-selection option:eq(1)").attr("selected", "selected");
          $("#select-eleves-group-selection").trigger("chosen:updated");  // chosen plugin refresh
          if (Object.keys(groups).length > 0){
            select_eleves_widget.fillEleves($("#select-eleves-group-selection option:selected").attr("label"));
          }
    };

    function _eleve_from_id(id){
        var eleve;
        $.each(groups, function(i, eleves) {
            var length = eleves.length;
            for(var i = 0 ; i < length ; i++){
                if (eleves[i].id == id){
                    eleve = eleves[i];
                    // breaking the $.each loop
                    return false;
                }
            }
        });
        if(typeof eleve == "undefined"){
            return false;
        }else{
            return eleve;
        }
    };

    // Public Members
    return {
        "selectedEleves": [], // list of selected users

        "loadEleves" : function(grouplist) {
            // Loads all the groups and users
            _getEleves(grouplist);
            _fillGroups();
        },

        "getSelectedEleves": function(){
            return select_eleves_widget.selectedEleves;
        },

        "getSelectedIds": function(){
            return $.map(select_eleves_widget.selectedEleves,
                         function(eleve, i){
                             return eleve.id;
                         }
                        );
        },

        "getDescription": function(eleve) {
            var machine = "";
            if(options['filter'] == "connected"){
                machine = " - " + eleve.machine;
            }
            if(typeof eleve.login != "undefined"
               && typeof eleve.nom != "undefined"
               && typeof eleve.prenom != "undefined"){
                if ($("#eleve-filter-nom").prop("checked")){
                    return eleve.nom + " " + eleve.prenom + machine;
                }
                if ($("#eleve-filter-prenom").prop("checked")){
                    return eleve.prenom  + " " + eleve.nom + machine;
                }
                if ($("#eleve-filter-login").prop("checked")){
                    return eleve.login + machine;
                }
            }
                return "";
        },

        "getDescriptionFromId": function(id) {
            return select_eleves_widget.getDescription(_eleve_from_id(id));
        },

        "emptySelectedEleves": function(){
            select_eleves_widget.selectedEleves = [];
        },

        "getEleveFromId": function(id){
            return _eleve_from_id(id);
        },

        "setOptions": function(user_options){
            $.each(user_options, function(cle, valeur){
                options[cle] = valeur;
            });
        },

        "getOptions": function(){
            return options;
        },

        "fillEleves" : function(group) {
            // Fills the eleves list based on the groups variable and the group selection
            var items = [];
            if ($("#eleve-filter-nom").prop("checked")){
                groups[group].sort((a,b) => (a.nom > b.nom) ? 1 : ((b.nom > a.nom) ? -1 : 0));
            }
            if ($("#eleve-filter-prenom").prop("checked")){
                groups[group].sort((a,b) => (a.prenom > b.prenom) ? 1 : ((b.prenom > a.prenom) ? -1 : 0));
            }
            if ($("#eleve-filter-login").prop("checked")){
                groups[group].sort((a,b) => (a.login > b.login) ? 1 : ((b.login > a.login) ? -1 : 0));
            }
            $.each(groups[group], function(i, eleve) {
                items.push("<option label=\"" + eleve.id + "\">" + select_eleves_widget.getDescription(eleve) + "</option>");
            });
            items.unshift("<option label=\"" + group + "\">Tous</option>"); // Place an empty value at the beginning
            items.unshift("<option label=\"(vide)\"></option>"); // Place an empty value at the beginning
            $("#eleve-selection").html(items.join(""));
            $("#eleve-selection").attr("data-placeholder", " ");
            $("#eleve-selection").chosen({ width: $("#eleve-selection").css("width"), no_results_text: "Pas de résultats pour" });
            $("#eleve-selection").trigger("chosen:updated");  // chosen plugin refresh
        },

        "removeEleve" : function(id) {
            var index = select_eleves_widget.selectedEleves.indexOf(_eleve_from_id(id));
            if(index != -1) {
                select_eleves_widget.selectedEleves.splice(index, 1);
                select_eleves_widget.formatSelectedEleves();
            }
        },

        "addEleve" : function(id) {
            var eleve = _eleve_from_id(id);
            // eleve == false if id is unknown
            if(typeof eleve != "boolean"){
                if (select_eleves_widget.selectedEleves.indexOf(eleve) == -1){
                    select_eleves_widget.selectedEleves.push(eleve);
                }
            }
        },

        "addGroup" : function(group) {
            $.each(groups[group], function(i, eleve){
                if (select_eleves_widget.selectedEleves.indexOf(eleve) == -1){
                    select_eleves_widget.selectedEleves.push(eleve);
                }
            });
        },

        "validateSelectedEleves" : function() {
            // Checks if an eleve has been selected
            // Return false if no eleve is selected
            var validation = (select_eleves_widget.selectedEleves.length > 0);
            if (validation){
                $("#select-eleves-selection-list-label").removeClass("text-danger");
                $("#select-eleves-selection-list").removeClass("text-danger");
            }else{
                $("#select-eleves-selection-list-label").addClass("text-danger");
                $("#select-eleves-selection-list").addClass("text-danger");
            }
            return validation;
        },

        "formatSelectedEleves" : function() {
            // Uses the list of selected users to compute the corresponding html
            var resultat;
            var items = [];
            var button_status = options.eleve_button_enabled ? "" : " disabled";
            $.each(select_eleves_widget.selectedEleves, function(i, eleve) {
                items.push("<div class=\"well-sm btn-group\">\n");
                items.push("<a class=\"btn btn-danger suppress-eleve\" data-id=\"" + eleve.id + "\"><i class=\"fa fa-times\"></i></a>\n");
                items.push("<a class=\"btn btn-default connection"+ button_status + "\" data-id=\"" + eleve.id +"\">" + select_eleves_widget.getDescription(eleve) +"</a>\n");
                items.push("</div>\n");
            });
            if (items.length !== 0) {
                items.unshift("<a class=\"btn-link pull-right empty-eleves\">Vider la liste</a>");
                resultat = items.join("");
            }else{
                resultat = "Aucune sélection";
            }
            $("#select-eleves-selection-list").html(resultat);
            // to remove the warning when adding to an empty list
            if(select_eleves_widget.selectedEleves.length > 0){
                select_eleves_widget.validateSelectedEleves();
            }
        }
    };
})();
