"use strict";

var select_etabs_events =  (function() {

    jQuery(document).ready(function ($) {
        // Adding an etab
        $("#select-etab-selection").on({change : function(e){
            if($("option:selected", $(this)).html() != ""){
                select_etabs_widget.addEtab($("option:selected", $(this)).attr("label"));
            }
            $("option:selected", $(this)).removeAttr("selected");  // empty the selected etab
            $(this).trigger("chosen:updated");  // chosen plugin refresh
            select_etabs_widget.formatSelectedEtabs();
        }});

        // Suppress one of the selected etabs
        $(document).on("click", ".suppress-etab", function(event){
            var etab = $(this).data("name");
            var index = select_etabs_widget.selectedEtabs.indexOf(etab);
            if(index != -1) select_etabs_widget.selectedEtabs.splice(index, 1);
            select_etabs_widget.formatSelectedEtabs();
        });

        // Empty selected etabs
        $(document).on("click", ".empty-etabs", function(event){
            select_etabs_widget.selectedEtabs = [];
            select_etabs_widget.formatSelectedEtabs();
        });

    });
})();

var select_etabs_widget = (function() {
    // Private Members
    var etablist = []; 

    function _manageJSON(data){
        // Checks if a string has the json format
        // if true returns an object else return the same string
        var response;
        try{
            response = $.parseJSON(data);
        }catch(e){
            response = data;
        }
        return response;
    };

    function _getEtabs(){
        // getting the list of eleves from a given group with the current filter
        var url = "api/etabs/";
        $.getJSON(url, function(data) {
            var response = _manageJSON(data);
            if (typeof response == "object"){ // response has json format
                if (response.length > 1){ //multiEtab
                    var resp = []
                    resp.push(response[0])
                    $.each(response[1],function(i, etab){
                        resp.push(etab)
                    })
                    etablist = resp
                }else{
                    etablist = response
                }
            }
        });
       
    };

    function _fillEtabs() {
        // Fills the etab-selection list
        var items = [];
        if(etablist.length > 1) {
            $.each(etablist, function(i, cle) {
                items.push("<option label=\"" + cle + "\">" + cle + "</option>");
            });
            items.unshift("<option label=\"(vide)\"></option>"); // Place an empty value at the beginning
           
        }else{
            items.push("<option label=\"" + etablist[0] + "\" selected>" + etablist[0] + "</option>");
            select_etabs_widget.addEtab(etablist[0] );
            select_etabs_widget.formatSelectedEtabs();
        }
        $("#select-etab-selection").html(items.join(""));
        $("#select-etab-selection").attr("data-placeholder", " ");
        $("#select-etab-selection").chosen({ width: $("#select-etab-selection").css("width"), no_results_text: "Pas de résultats pour" });
        $("#select-etab-selection").trigger("chosen:updated");  // chosen plugin refresh
    };

    // Public Members
    return {
        "selectedEtabs" : [],   // list of selected etabs

        "loadEtabs" : function() {
            _getEtabs();
            _fillEtabs();
        },

        "addEtab" : function(etab) {
            if (select_etabs_widget.selectedEtabs.indexOf(etab) == -1){
                select_etabs_widget.selectedEtabs.push(etab);
            }
        },
        "validateSelectedEtabs" : function() {
            // Checks if a etab has been selected
            // Return false if no etab is selected
            var validation = (select_etabs_widget.selectedEtabs.length > 0);
            if (validation){
                $("#select-etab-selection-list-label").removeClass("text-danger");
                $("#select-etab-selection-list").removeClass("text-danger");
            }else{
                $("#select-etab-selection-list-label").addClass("text-danger");
                $("#select-etab-selection-list").addClass("text-danger");
            }
            return validation;
        },

        "formatSelectedEtabs" : function() {
            // Uses the list of selected etabs to compute the corresponding html
            var resultat;
            var items = [];
            $.each(select_etabs_widget.selectedEtabs, function(i, etab) {
                items.push("<div class=\"well-sm btn-etab\">\n");
                items.push("<a class=\"btn btn-danger suppress-etab\" data-name=\"" + etab + "\"><i class=\"fa fa-times\"></i></a>\n");
                items.push("<a class=\"btn btn-default disabled\">" + etab +"</a>\n");
                items.push("</div>\n");
            });
            if (items.length !== 0) {
                items.unshift("<a class=\"btn-link pull-right empty-etabs\">Vider la liste</a>");
                resultat = items.join("");
            }else{
                resultat = "Aucune sélection.";
            }
            $("#select-etab-selection-list").html(resultat);
            // to remove the warning when adding to an empty list
            if(select_etabs_widget.selectedEtabs.length > 0){
                select_etabs_widget.validateSelectedEtabs();
            }
        },
        "getSelectedIds": function(){
            return $.map(select_etabs_widget.selectedEtabs,
                         function(etab, i){
                             return etab;
                         }
            );
        }
    };
})();
