#!/usr/bin/env python3

import sys
import time
from datetime import datetime, timedelta
from scribe.eolegroup import Group
from scribe.eoleldap import LdapEntry
from scribe.eoleuser import User
from scribe.enseignants import Enseignant
from scribe.eoletools import nscd_start, nscd_stop, lsc_full_sync
from pyeole.process import system_code, system_out

grouplist  = []
userlist = []

g = Group()
groups = g.get_groups()
for grp in groups:
    if 'invite-' in grp:
        grouplist.append(grp)
        entry = LdapEntry()
        members = entry.get_members(grp)
        for member in members :
            userlist.append(member)

delusers=[]
for user in userlist:
    u=User()
    shadowexpire = datetime.fromtimestamp(int(u.get_attr(user, 'shadowExpire')[0]))+timedelta(days=14)
    fornow = datetime.now().replace(hour=0, minute=0, second=0, microsecond=0)

    if shadowexpire <= fornow :
        delusers.append(user)

if delusers:
    ldapuser = Enseignant()
    ldapuser.ldap_admin.connect()
    nscd_stop()
    for login in delusers:
        ldapuser._delete(login, remove_data=True, delete_resp=True)

    lsc_full_sync()
    nscd_start()
