# -*- coding: UTF-8 -*-
from flask import Blueprint, current_app, session, json
from xmlrpc.client import ServerProxy
from flask.views import MethodView
from eop.modules.api import membersapi, ldapusersapi
from eoleauthlib.authclient import login_required

userinfosapi = Blueprint('userinfosapi', __name__, url_prefix='/api/usersinfos/')

class UserinfosAPI(MethodView):
    decorators = [login_required]

    def __init__(self):
        self.username = session["username"]
        self.proxy = ServerProxy(current_app.config['CONTROLEVNC_URL'])
        self.secret = current_app.config['SECRET_KEY']

    def get(self, groupname, filtre = None):
        """Returns a list of eleves of the given group with attributes depending on the filtre parameter
        None: login, sn and givenName from the ldap
        "connected": filter only connected users and return login, sn, givenName from the ldap, IP address (may not be unique), host name
        """
        if groupname is None:
            current_app.logger.warning('Unbound use of the API: required groupname is not provided.')
            return json.dumps('Error: You need a groupname to talk to backend')
        member = membersapi.MembersAPI()
        temp = member.get(groupname)
        logins = json.loads(temp)
        eleves = []
        if filtre is None:
            for login in logins:
                eleve = ldapusersapi.LdapusersAPI()
                nom = json.loads(eleve.get('sn', login))[0]
                prenom = json.loads(eleve.get('givenName', login))[0]
                eleves.append({'id': login, 'login': login, 'nom': nom, 'prenom': prenom})
            return json.dumps(eleves)
        elif filtre == "connected":
            connected = self.proxy.remote_get_connectes_groupes(self.secret, self.username, groupname)
            for i in range(len(connected)):
                login = connected[i]['login']
                eleve = ldapusersapi.LdapusersAPI()
                nom = json.loads(eleve.get('sn', login))[0]
                prenom = json.loads(eleve.get('givenName', login))[0]
                connected[i]['nom'] = nom
                connected[i]['prenom'] = prenom
                connected[i]['id'] = login + '-' + connected[i]['machine']
            return json.dumps(connected)
        else:
            return json.dumps([])

    def post(self):
        raise NotImplementedError

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("userinfos_api")
        mod.add_url_rule('', view_func=f, methods=["GET"],
                         defaults={"groupname": None, "filtre": None})
        mod.add_url_rule('', view_func=f, methods=["POST"])
        mod.add_url_rule('<groupname>', view_func=f, methods=['GET'])
        mod.add_url_rule('<groupname>/<filtre>', view_func=f, methods=['GET'])

UserinfosAPI.register(userinfosapi)
