from flask import Blueprint, current_app, render_template, request, session, url_for
from eoleauthlib.authclient import login_required
from eoleflask.util import get_proxy_url
from eop import utils

comptetemp = Blueprint('comptetemp', __name__, url_prefix = '/comptetemp')

@comptetemp.route('')
@login_required
def show():

    username = session["username"]
    session["admin_etab"] = False
    is_prof = utils.est_prof()
    is_admin = False
    is_admin_etab = False
    if utils.est_admin():
        is_admin = True
    if utils.est_admin_etab():
        is_admin_etab = True
        session["admin_etab"] = True

    url_logout = url_for('logout', return_url=get_proxy_url(request, url_for("index.show", _external=True)))
    return render_template('comptetemp/comptetemp.html',
                               nb_classe_min = current_app.config['NB_CLASSE_MIN'],
                               nb_car_min = current_app.config['NB_CAR_MIN'],
                               username = username,
                               is_admin = is_admin,
                               is_admin_etab = is_admin_etab,
                               can_create_tempaccount = current_app.config['PROFS_CAN_CREATE_TEMPACCOUNT'],
                               url_logout = url_logout,
                               activer_ad = current_app.config['ACTIVER_AD'],
                               multi_etab = current_app.config['MULTI_ETAB'])

