# -*- coding: UTF-8 -*-
from flask import Blueprint, current_app, session, json, request
from xmlrpc.client import ServerProxy
from flask.views import MethodView
from eop.modules.api import membersapi, ldapusersapi
from eoleauthlib.authclient import login_required
from scribe.eoleldap import Ldap, get_etabs

etabsapi = Blueprint('etabsapi', __name__, url_prefix='/api/etabs/')

class EtabsAPI(MethodView):
    decorators = [login_required]

    def __init__(self):
        self.username = session["username"]
        self.proxy = ServerProxy(current_app.config['CONTROLEVNC_URL'])
        self.secret = current_app.config['SECRET_KEY']

    def get(self):
        """Returns a list of etabs
        """
        etabslist = []
        etabslist = get_etabs()
        return json.dumps(etabslist)

    def post(self):
        """Returns a list of members of etabs
        """
        response = request.form
        etbs = json.loads(response["etabs"])
        if current_app.config['MULTI_ETAB'] == "oui":
            etabslist = self.proxy.remote_etabs_eleves(etbs)
        else: 
            etabslist = self.proxy.remote_etabs_eleves(etbs[0])
        return json.dumps(etabslist)

    def delete(self):
        raise NotImplementedError

    def put(self):
        raise NotImplementedError

    @classmethod
    def register(cls, mod):
        f = cls.as_view("etabs_api")
        mod.add_url_rule('', view_func=f, methods=["GET", "POST"])
       

EtabsAPI.register(etabsapi)
