"use strict";

var mdp_utils = (function() {
    // Private Members
    var groups = {};

    function _manageJSON(data){
        // Checks if a string has the json format
        // if true returns an object else return the same string
        try{
            var response = $.parseJSON(data);
        }catch(e){
            var response = data;
        }
        return response;
    };

    function _contientMinuscule(str) {
        var re = new RegExp(/[a-z]/);
        if (re.test(str)) return 1;
        return 0;
    };

    function _contientMajuscule(str) {
        var re = new RegExp(/[A-Z]/);
        if (re.test(str)) return 1;
        return 0;
    };

    function _contientChiffre(str) {
        var re = new RegExp(/[0-9]/);
        if (re.test(str)) return 1;
        return 0;
    };

    function _contientCarSpecial(str) {
        var re = new RegExp(/[\W]/);
        if (re.test(str)) return 1;
        return 0;
    };

    // Public Members
    return {
        "getAdminGroups" : function() {
            var admin_groups;
            $.getJSON("api/ldappasswords/", function(data) {
                var response = _manageJSON(data);
                if (typeof response == "object"){ // response has json format
                    admin_groups = response;
                }
            });
            return admin_groups;
        },

        "activationCommonPassword" : function (){
            // Show / hide common password field
            if ($("#option-common").prop('checked')){
                $("#common-password").show("slow");
                $("#common-password-input").focus();
            }else{
                $("#common-password").hide("slow");
            }
        },
        "activationCommonPasswordEtab" : function (){
            // Show / hide common password field
            if ($("#option-common-etab").prop('checked')){
                $("#common-password-etab").show("slow");
                $("#common-password-etab-input").focus();
            }else{
                $("#common-password-etab").hide("slow");
            }
        },

        "check_password" : function () {
            // return a boolean that tells wether the password entered by the user is correct
            var pass = $("#common-password-input").val();
            var nb_classe = _contientMinuscule(pass) + _contientMajuscule(pass) + _contientChiffre(pass) + _contientCarSpecial(pass);
            var longueur = pass.length;
            var retour;
            // retour values :
            // -1 : valid password
            //  0 : empty password
            //  1 : password is too short
            //  2 : password is too simple (not enough caracters types mixed)
            if (longueur == 0){
                retour = 0;
            } else if (longueur < nb_car_min){
                retour = 1;
            } else if (nb_classe < nb_classe_min){
                retour = 2;
            } else {
                retour = -1;
            }
            var message;
            switch (retour){
            case -1:
                message = "Mot de passe acceptable.";
                break;
            case 0:
            case 1:
                message = "Encore au moins " + (nb_car_min-longueur) + " caractère(s).";
                break;
            case 2:
                message = "Mot de passe trop simple, mélangez d'autres types de caractères.";
                break;
            default:
                message = "";
            }

            if (retour == -1) {
                $('#common-password').removeClass("has-error").addClass("has-success");
            } else {
                $('#common-password').removeClass("has-success").addClass("has-error");
            }

            $("#complexity-check").html(message);
            $("#complexity-check").show("slow");
            return (retour == -1);
        },
        "check_password_etab" : function () {
            // return a boolean that tells wether the password entered by the user is correct
            var pass = $("#common-password-etab-input").val();
            var nb_classe = _contientMinuscule(pass) + _contientMajuscule(pass) + _contientChiffre(pass) + _contientCarSpecial(pass);
            var longueur = pass.length;
            var retour;
            // retour values :
            // -1 : valid password
            //  0 : empty password
            //  1 : password is too short
            //  2 : password is too simple (not enough caracters types mixed)
            if (longueur == 0){
                retour = 0;
            } else if (longueur < nb_car_min){
                retour = 1;
            } else if (nb_classe < nb_classe_min){
                retour = 2;
            } else {
                retour = -1;
            }
            var message;
            switch (retour){
            case -1:
                message = "Mot de passe acceptable.";
                break;
            case 0:
            case 1:
                message = "Encore au moins " + (nb_car_min-longueur) + " caractère(s).";
                break;
            case 2:
                message = "Mot de passe trop simple, mélangez d'autres types de caractères.";
                break;
            default:
                message = "";
            }

            if (retour == -1) {
                $('#common-password-etab').removeClass("has-error").addClass("has-success");
            } else {
                $('#common-password-etab').removeClass("has-success").addClass("has-error");
            }

            $("#complexity-check-etab").html(message);
            $("#complexity-check-etab").show("slow");
            return (retour == -1);
        },
        "submitChangeEtabsPassword" : function (selectdetabs){
            var passwordformat = $(".checketab input:checked").val();
            var newpassword = "";
            if (passwordformat == "common"){
                newpassword = $("#common-password-etab-input").val();
            }
            var forcechange = $("#force-modification-etab").prop("checked");
            if (forcechange == undefined) {
                forcechange = false;
            }
            $.ajax({
                type: "POST",
                url: "api/etabs/",
                data: {"etabs": selectdetabs},
                success: function (data) {
                    var response = _manageJSON(data);
                    if (typeof response !== 'undefined' && response.length > 0) {
                        mdp_utils.changePassord(JSON.stringify(response), passwordformat, newpassword, forcechange, true);
                    }else{
                        mdp_utils.afficherNotificationEtab("danger", "Erreur : Aucune élève trouvé.");
                        $("#btnSubmitPassword").html("Modifier <i class=\"fa fa-check-circle\"></i>");
                        $("#btnSubmitEtabsPassword").html("Modifier <i class=\"fa fa-check-circle\"></i>"); 
                    }
                }
            })
        },
        "submitChangePassword" : function (selected){
            var passwordformat = $(".check input:checked").val();
            var newpassword = "";
            if (passwordformat == "common"){
                newpassword = $("#common-password-input").val();
            }
            var forcechange = $("#force-modification").prop("checked");
            if (forcechange == undefined) {
                forcechange = false;
            }
            mdp_utils.changePassord(selected, passwordformat, newpassword, forcechange);
        },
        "changePassord": function(selected, passwordformat, newpassword, forcechange, etabs=false){
            $.ajax({
                type: "POST",
                url: "api/ldappasswords/",
                data: {"eleves": selected, "passwordformat": passwordformat, "newpassword": newpassword, "forcechange": forcechange},
                success: function (data) {
                    select_eleves_widget.emptySelectedEleves(); // empty the list of selected eleves
                    select_eleves_widget.formatSelectedEleves();
                    var response = _manageJSON(data);
                    if (typeof response == "object"){ // response has json format
                        var items = [];
                        $.each(response['eleves'], function(login, pass) {
                            items.push("<li><b>"
                                       + select_eleves_widget.getDescriptionFromId(login)
                                       + "</b> : " + pass.replace(/</g,'&lt;').replace(/>/g,'&gt;') + "</li>");
                        });
                        var message = "Les mots de passe des utilisateurs suivants ont été modifiés avec succès :<ul class=\"list-inline\">" + items.join(" ; ") + "</ul><br/>";
                        var file_name = response['filename'];
                        if (file_name == ""){
                            message += "Les modifications n'ont pas pu être enregistrées dans un fichier.";
                        }
                        else{
                            message += "Modifications enregistrées dans votre répertoire personnel dans le fichier <b>" + file_name  + "</b>.";
                        }
                        if (etabs){
                            mdp_utils.afficherNotificationEtab("success", message);
                        }else{
                            mdp_utils.afficherNotification("success", message);
                        }
                       
                    }else{ // response is a string error message
                        if (etabs){
                            mdp_utils.afficherNotification("danger", response.substr(0,200));
                        }else{
                            mdp_utils.afficherNotification("danger", response.substr(0,200));
                        }
                       
                    }
                    $("#btnSubmitPassword").html("Modifier <i class=\"fa fa-check-circle\"></i>");
                    $("#btnSubmitEtabsPassword").html("Modifier <i class=\"fa fa-check-circle\"></i>"); 
                },
                error : function (data) {
                    if (etabs){
                        mdp_utils.afficherNotification("danger", "Erreur : impossible de contacter le serveur.");
                    }else{
                        mdp_utils.afficherNotification("danger", "Erreur : impossible de contacter le serveur.");
                    }
                    $("#btnSubmitPassword").html("Modifier <i class=\"fa fa-check-circle\"></i>");
                    $("#btnSubmitEtabsPassword").html("Modifier <i class=\"fa fa-check-circle\"></i>"); 
                }
                
            });
        },
        "afficherNotification" : function (type, message){
            var othertype;
            // type should be only "danger" or "success"
            if(type == "danger"){
                othertype = "success";
            }
            else{
                if(type == "success"){
                    othertype = "danger";
                }
                else{
                    return 0;
                }
            }
            $("#mdp-result-message").html("<button type=\"button\" class=\"close notification\">&times;</button>" + message);
            $("#mdp-result-message").removeClass("alert-" + othertype).addClass("alert-" + type);
            $("#mdp-result-message").show("slow");
            $("html, body").animate({ scrollTop: 0 }, "slow");
        },
        "afficherNotificationEtab" : function (type, message){
            var othertype;
            // type should be only "danger" or "success"
            if(type == "danger"){
                othertype = "success";
            }
            else{
                if(type == "success"){
                    othertype = "danger";
                }
                else{
                    return 0;
                }
            }
            $("#mdpetab-result-message").html("<button type=\"button\" class=\"close notification\">&times;</button>" + message);
            $("#mdpetab-result-message").removeClass("alert-" + othertype).addClass("alert-" + type);
            $("#mdpetab-result-message").show("slow");
        }
    };
})();
