"use strict";

var vnc = (function() {

    var selected_group = null;    // keep here the selected group to restore it on refresh

    function refresh(){
        // Save the selected group before refresh
        selected_group = $("#select-eleves-group-selection").val();

        // Passing the list of groups to load to the selection widget
        select_eleves_widget.loadEleves(vnc_utils.getGroups());

        // Restore the selected group and apply it
        if ((selected_group !== null) && (selected_group != "") && (selected_group != "(vide)")){
            var available_groups = $('#select-eleves-group-selection').children().map(function() { return $(this).text(); });
            if ($.inArray(selected_group, available_groups) != -1){ // select previous group only if it still exists
                $("#select-eleves-group-selection").val(selected_group);
                $("#select-eleves-group-selection").trigger('chosen:updated');
            }
            select_eleves_widget.fillEleves($("option:selected", $("#select-eleves-group-selection")).attr("label"));
        };

        // Connecting when clicking on one of the selected eleves
        $(document).off("click", ".btn.btn-info.connection"); // remove previously added event before adding new one
        $(document).on("click", ".btn.btn-info.connection", function(event){
            var id = $(this).data("id");
            vnc_utils.connect(id);
        });
    };

    $(document).ready(function() {
        $.ajaxSetup({async:false});  // for the ajax call to be synchronous

        // Defining options for the selection widget
        select_eleves_widget.setOptions({'filter': "connected"}); // only connected users should appear for selection

        refresh();

        // Hiding the alert notification
        $(document).on("click", ".close.notification", function(event){
            $("#vnc-result-message").hide("slow");
        });

        // popover allows to display a popup for tooltip help
        $("a[data-toggle=popover]").popover({html : true}).click(function(e) {
            $("a[data-toggle=popover]").not(this).popover('hide'); // hide all other popover
            e.preventDefault();
        });

        // Refresh the page
        $(document).on("click", "#refresh", function(event){
            var link_text = $(this).text();
            $(this).html('<i class="fa fa-spinner"></i>');
            refresh();
            $(this).text(link_text);
        });
    });
})();