\r grr
SET character_set_client = utf8;
SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

-- ------------------------------------------------------------------------------------------------------------------------------------------
-- Uniquement si GRR est activé
-- ------------------------------------------------------------------------------------------------------------------------------------------
%if %%is_defined('activer_grr') and %%activer_grr == 'oui'


-- ------------------------------------------------------------------------------------------------------------------------------------------
-- ------------- Création admin secondaire --------------------------------------------------------------------------------------------------
-- ------------------------------------------------------------------------------------------------------------------------------------------


DROP PROCEDURE IF EXISTS AddAdminGrr;
delimiter |
CREATE PROCEDURE AddAdminGrr(_adminuser VARCHAR( 32 ))
BEGIN
    DECLARE ad_id INT DEFAULT 0;

    SELECT COUNT(*) INTO ad_id FROM grr_utilisateurs WHERE login=_adminuser;

    IF ad_id = 0 THEN
        INSERT IGNORE INTO `grr_utilisateurs` (`login`, `nom`, `prenom`, `password`, `email`, `statut`, `etat`, `default_site`, `default_area`, `default_room`, `default_style`, `default_list_type`, `default_language`, `source`) VALUES 
        ( _adminuser,'Envole','Administrateur','','','administrateur','actif',0,0,0,'','','','ext');
    END IF;

    UPDATE grr_utilisateurs SET statut = 'administrateur' WHERE login = _adminuser;
END|
DELIMITER ;

-- ------------------------------------------------------------------------------------------------------------------------------------------
-- ------------- Mise à jour des paramètres de connexion au SSO -----------------------------------------------------------------------------
-- ------------------------------------------------------------------------------------------------------------------------------------------

DROP PROCEDURE IF EXISTS SetDefaultSetting;
delimiter |

CREATE PROCEDURE SetDefaultSetting()
BEGIN

    INSERT IGNORE INTO grr_setting (NAME, VALUE) VALUES ('sso_statut','');
    INSERT IGNORE INTO grr_setting (NAME, VALUE) VALUES ('cas_port','');
    INSERT IGNORE INTO grr_setting (NAME, VALUE) VALUES ('cas_serveur','');
    INSERT IGNORE INTO grr_setting (NAME, VALUE) VALUES ('cas_racine','');

    UPDATE grr_setting SET value = 'cas_utilisateur' WHERE name = 'sso_statut';
    UPDATE grr_setting SET value = '%%eolesso_port' WHERE name = 'cas_port';
    UPDATE grr_setting SET value = '%%eolesso_adresse' WHERE name = 'cas_serveur';
    UPDATE grr_setting SET value = '%%eolesso_cas_folder' WHERE name = 'cas_racine';

    INSERT IGNORE INTO grr_setting (NAME, VALUE) VALUES ('sso_ac_corr_profil_statut','');
    INSERT IGNORE INTO grr_setting (NAME, VALUE) VALUES ('sso_IsNotAllowedModify','');
    INSERT IGNORE INTO grr_setting (NAME, VALUE) VALUES ('sso_redirection_accueil_grr','');

    UPDATE grr_setting SET value = 'n' WHERE name = 'sso_ac_corr_profil_statut';    
    UPDATE grr_setting SET value = 'n' WHERE name = 'sso_IsNotAllowedModify';
    UPDATE grr_setting SET value = 'n' WHERE name = 'sso_redirection_accueil_grr';

    INSERT IGNORE INTO grr_setting (NAME, VALUE) VALUES ('acces_fiche_reservation','');
    INSERT IGNORE INTO grr_setting (NAME, VALUE) VALUES ('authentification_obli','');
    INSERT IGNORE INTO grr_setting (NAME, VALUE) VALUES ('visu_fiche_description','');

    UPDATE grr_setting SET value = '1' WHERE name='acces_fiche_reservation';    
    UPDATE grr_setting SET value = '1' WHERE name='authentification_obli';
    UPDATE grr_setting SET value = '1' WHERE name='visu_fiche_description';

    INSERT IGNORE INTO grr_setting (NAME, VALUE) VALUES ('cacher_lien_deconnecter','');
    UPDATE grr_setting SET value = 'n' WHERE name = 'cacher_lien_deconnecter';

    CALL AddAdminGrr('admin');
    %if %%is_defined('activer_addadmin') and %%activer_addadmin == 'oui'
    CALL AddAdminGrr('%%uid_addadmin');
    %end if

    UPDATE grr_utilisateurs SET default_language='' WHERE default_language!='fr' OR default_language!='en' OR default_language!='de' OR default_language!='it' OR default_language!='es';
END|

DELIMITER ;

-- ------------------------------------------------------------------------------------------------------------------------------------------
-- Suppression des procédures et fonctions en sortant
-- ------------------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS addFieldIfNotExists;
DROP FUNCTION IF EXISTS isFieldExisting;


-- ------------------------------------------------------------------------------------------------------------------------------------------
-- Fin du si GRR est activé
-- ------------------------------------------------------------------------------------------------------------------------------------------
%end if
