\r grr
SET character_set_client = utf8;

-- ------------------------------------------------------------------------------------------------------------------------------------------
-- Uniquement si GRR est activé
-- ------------------------------------------------------------------------------------------------------------------------------------------
%if %%is_defined('activer_grr') and %%activer_grr == 'oui'

-- ------------------------------------------------------------------------------------------------------------------------------------------
-- Procédure et fonction d'ajout de colonne si elle n'existe pas
-- https://stackoverflow.com/questions/972922/add-column-to-mysql-table-if-it-does-not-exist
-- ------------------------------------------------------------------------------------------------------------------------------------------
DELIMITER $$

DROP PROCEDURE IF EXISTS addFieldIfNotExists
$$
DROP FUNCTION IF EXISTS isFieldExisting
$$

CREATE FUNCTION isFieldExisting (table_name_IN VARCHAR(100), field_name_IN VARCHAR(100))
RETURNS INT
RETURN (
    SELECT COUNT(COLUMN_NAME)
    FROM INFORMATION_SCHEMA.columns
    WHERE TABLE_SCHEMA = DATABASE()
    AND TABLE_NAME = table_name_IN
    AND COLUMN_NAME = field_name_IN
)
$$

CREATE PROCEDURE addFieldIfNotExists (
    IN table_name_IN VARCHAR(100)
    , IN field_name_IN VARCHAR(100)
    , IN field_definition_IN VARCHAR(100)
)
BEGIN

    -- http://javajon.blogspot.com/2012/10/mysql-alter-table-add-column-if-not.html

    SET @isFieldThere = isFieldExisting(table_name_IN, field_name_IN);
    IF (@isFieldThere = 0) THEN

        SET @ddl = CONCAT('ALTER TABLE ', table_name_IN);
        SET @ddl = CONCAT(@ddl, ' ', 'ADD COLUMN') ;
        SET @ddl = CONCAT(@ddl, ' ', field_name_IN);
        SET @ddl = CONCAT(@ddl, ' ', field_definition_IN);

        PREPARE stmt FROM @ddl;
        EXECUTE stmt;
        DEALLOCATE PREPARE stmt;

    END IF;

END;
$$
DELIMITER ;

-- -----------------------------------------------------------------------------------------------------------------------------------------
-- ------------- Migration 1.9.7e --> 2.2.2 ------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------------------------------------

DROP PROCEDURE IF EXISTS 197to222;
DELIMITER |
CREATE PROCEDURE 197to222()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT VALUE INTO version FROM grr_setting WHERE NAME='version';

	IF version < '2.2.2' THEN
        INSERT IGNORE INTO grr_setting (NAME, VALUE) VALUES ('default_css','default');

        -- Forcage du théme default
        UPDATE grr_setting SET VALUE='default' WHERE NAME='default_css';
        UPDATE grr_utilisateurs SET default_style='' WHERE 1;

        -- Suppression du login adminsitrateur qui a pu être généré par l'installeur de Grr
        DELETE FROM grr_utilisateurs WHERE login='ADMINISTRATEUR';

		-- Mise à jour de la version applicative
		UPDATE grr_setting SET VALUE='2.2.2' WHERE NAME='version';

	END IF;
END|
DELIMITER ;

CALL 197to222();
DROP PROCEDURE 197to222;


-- -----------------------------------------------------------------------------------------------------------------------------------------
-- ------------- Migration 2.2.2 --> 3.2.0 -------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------------------------------------

DROP PROCEDURE IF EXISTS 222to320;
DELIMITER |
CREATE PROCEDURE 222to320()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT VALUE INTO version FROM grr_setting WHERE NAME='version';

	IF version < '3.2.0' THEN
        -- Mise à jour de structure de la table grr_entry
        CALL addFieldIfNotExists ('grr_entry', 'clef', 'INT(2) NOT NULL DEFAULT \'0\' AFTER jours');
        CALL addFieldIfNotExists ('grr_entry', 'courrier', 'INT(2) NOT NULL DEFAULT \'0\' AFTER clef');

        -- Mise à jour de structure de la table grr_log
        ALTER TABLE `grr_log` CHANGE `START` `START` DATETIME NOT NULL DEFAULT '1970-01-01 00:00:00', CHANGE `END` `END` DATETIME NOT NULL DEFAULT '1970-01-01 00:00:00';

        -- Mise à jour de structure de la table grr_repeat
        CALL addFieldIfNotExists ('grr_repeat', 'courrier', 'INT(2) NOT NULL DEFAULT \'0\' AFTER jours');

        -- Mise à jour de structure de la table grr_room
        CALL addFieldIfNotExists ('grr_room', 'active_cle', 'CHAR(1) NOT NULL DEFAULT \'Y\' AFTER active_ressource_empruntee');

        -- Forcage du théme default car les autres thèmes sont vraiment trop moches
        INSERT INTO grr_setting (NAME, VALUE) VALUES ('default_css','default') ON DUPLICATE KEY UPDATE `VALUE`='default';

        -- Nouvelles entrées de configuration
        INSERT IGNORE INTO grr_setting (NAME, VALUE) VALUES ('smtp port','25');
        INSERT IGNORE INTO grr_setting (NAME, VALUE) VALUES ('smtp_secure','');
        INSERT IGNORE INTO grr_setting (NAME, VALUE) VALUES ('menu_gauche','1');

        -- Remise à plat des dates dans les logs suite modification de la valeur par défaut
        UPDATE `grr_log` SET `START`= '1970-01-01 00:00:00' WHERE `START`= '0000-00-00 00:00:00';
        UPDATE `grr_log` SET `END`= '1970-01-01 00:00:00' WHERE `END`= '0000-00-00 00:00:00';

		-- Mise à jour de la version applicative
		UPDATE grr_setting SET VALUE='3.2.0' WHERE NAME='version';

	END IF;
END|
DELIMITER ;

CALL 222to320();
DROP PROCEDURE 222to320;

-- -----------------------------------------------------------------------------------------------------------------------------------------
-- ------------- Migration 3.2.0 --> 3.3.0 -------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------------------------------------

DROP PROCEDURE IF EXISTS 320to330;
DELIMITER |
CREATE PROCEDURE 320to330()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT VALUE INTO version FROM grr_setting WHERE NAME='version';

	IF version < '3.3.0' THEN

        -- Mise à jour de structure de la table grr_setting
	INSERT INTO grr_setting (`NAME`, `VALUE`) VALUES ('periodicite', 'y');
	INSERT INTO grr_setting (`NAME`, `VALUE`) VALUES ('remplissage_description_complete', '0');

        -- Mise à jour de structure de la table grr_overload
	ALTER TABLE grr_overload CHANGE `fieldname` `fieldname` VARCHAR(55) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '';

	-- Mise à jour de la version applicative
	UPDATE grr_setting SET VALUE='3.3.0' WHERE NAME='version';

	END IF;
END|
DELIMITER ;

CALL 320to330();
DROP PROCEDURE 320to330;

-- -----------------------------------------------------------------------------------------------------------------------------------------
-- ------------- Migration 3.3.0 --> 3.3.1 -------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------------------------------------

DROP PROCEDURE IF EXISTS 330to331;
DELIMITER |
CREATE PROCEDURE 330to331()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT VALUE INTO version FROM grr_setting WHERE NAME='version';

	IF version < '3.3.1' THEN

	-- Création des nouvelles tables
	CREATE TABLE IF NOT EXISTS grr_calendrier_vacances (`DAY` int(11) NOT NULL DEFAULT '0');
        CREATE TABLE IF NOT EXISTS grr_calendrier_feries (`DAY` int(11) NOT NULL DEFAULT '0');

	-- Création des nouveaux paramètres
	INSERT INTO grr_setting (`NAME`, `VALUE`) VALUES ('cas_port', '');
	INSERT INTO grr_setting (`NAME`, `VALUE`) VALUES ('cas_racine', '');
	INSERT INTO grr_setting (`NAME`, `VALUE`) VALUES ('cas_serveur', '');
	INSERT INTO grr_setting (`NAME`, `VALUE`) VALUES ('ip_autorise', '');

	-- Mise à jour de la version applicative
	UPDATE grr_setting SET VALUE='3.3.1' WHERE NAME='version';

	END IF;
END|
DELIMITER ;

CALL 330to331();
DROP PROCEDURE 330to331;

-- -----------------------------------------------------------------------------------------------------------------------------------------
-- ------------- Migration 3.3.1 --> 3.4.0 -------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------------------------------------

DROP PROCEDURE IF EXISTS 331to340;
DELIMITER |
CREATE PROCEDURE 331to340()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT VALUE INTO version FROM grr_setting WHERE NAME='version';

	IF version < '3.4.0' THEN

	ALTER TABLE grr_type_area ADD `couleurhexa` VARCHAR(10) NOT NULL AFTER `couleur`;
	UPDATE grr_type_area SET `couleurhexa` = '#F49AC2' WHERE couleur = '1';
	UPDATE grr_type_area SET `couleurhexa` = '#99CCCC' WHERE couleur = '2';
	UPDATE grr_type_area SET `couleurhexa` = '#FF9999' WHERE couleur = '3';
	UPDATE grr_type_area SET `couleurhexa` = '#95a5a6' WHERE couleur = '4';
	UPDATE grr_type_area SET `couleurhexa` = '#C0E0FF' WHERE couleur = '5';
	UPDATE grr_type_area SET `couleurhexa` = '#FFCC99' WHERE couleur = '6';
	UPDATE grr_type_area SET `couleurhexa` = '#e74c3c' WHERE couleur = '7';
	UPDATE grr_type_area SET `couleurhexa` = '#3498db' WHERE couleur = '8';
	UPDATE grr_type_area SET `couleurhexa` = '#DDFFDD' WHERE couleur = '9';
	UPDATE grr_type_area SET `couleurhexa` = '#34495e' WHERE couleur = '10';
	UPDATE grr_type_area SET `couleurhexa` = '#2ecc71' WHERE couleur = '11';
	UPDATE grr_type_area SET `couleurhexa` = '#9b59b6' WHERE couleur = '12';
	UPDATE grr_type_area SET `couleurhexa` = '#f1c40f' WHERE couleur = '13';
	UPDATE grr_type_area SET `couleurhexa` = '#FF00DE' WHERE couleur = '14';
	UPDATE grr_type_area SET `couleurhexa` = '#009900' WHERE couleur = '15';
	UPDATE grr_type_area SET `couleurhexa` = '#e67e22' WHERE couleur = '16';
	UPDATE grr_type_area SET `couleurhexa` = '#bdc3c7' WHERE couleur = '17';
	UPDATE grr_type_area SET `couleurhexa` = '#C000FF' WHERE couleur = '18';
	UPDATE grr_type_area SET `couleurhexa` = '#FF0000' WHERE couleur = '19';
	UPDATE grr_type_area SET `couleurhexa` = '#FFFFFF' WHERE couleur = '20';
	UPDATE grr_type_area SET `couleurhexa` = '#A0A000' WHERE couleur = '21';
	UPDATE grr_type_area SET `couleurhexa` = '#f39c12' WHERE couleur = '22';
	UPDATE grr_type_area SET `couleurhexa` = '#1abc9c' WHERE couleur = '23';
	UPDATE grr_type_area SET `couleurhexa` = '#884DA7' WHERE couleur = '24';
	UPDATE grr_type_area SET `couleurhexa` = '#4169E1' WHERE couleur = '25';
	UPDATE grr_type_area SET `couleurhexa` = '#6A5ACD' WHERE couleur = '26';
	UPDATE grr_type_area SET `couleurhexa` = '#AA5050' WHERE couleur = '27';
	UPDATE grr_type_area SET `couleurhexa` = '#FFBB20' WHERE couleur = '28';
	UPDATE grr_type_area SET `couleurhexa` = '#CFCFCF' WHERE couleur > '28';
	CREATE TABLE IF NOT EXISTS grr_page (`nom` varchar(30) NOT NULL, `valeur` longtext NOT NULL);
	INSERT INTO grr_page (`nom`, `valeur`) VALUES ('CGU', 'Les CGU');
	ALTER TABLE grr_page ADD UNIQUE KEY `nom` (`nom`);
	CREATE TABLE IF NOT EXISTS grr_modulesext (`nom` varchar(50) NOT NULL, `actif` tinyint(1) NOT NULL DEFAULT '0', `version` INT(11) NOT NULL);
	ALTER TABLE grr_modulesext ADD UNIQUE KEY `nom` (`nom`);
	INSERT INTO grr_setting (`NAME`, `VALUE`) VALUES ('imprimante', '0');

	-- Mise à jour de la version applicative
	UPDATE grr_setting SET VALUE='3.4.0' WHERE NAME='version';

	END IF;
END|
DELIMITER ;

CALL 331to340();
DROP PROCEDURE 331to340;


-- -----------------------------------------------------------------------------------------------------------------------------------------
-- ------------- Migration 3.4.0 --> 3.4.1 -------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------------------------------------

DROP PROCEDURE IF EXISTS 340to341;
DELIMITER |
CREATE PROCEDURE 340to341()
BEGIN
	DECLARE version VARCHAR(100);

	SELECT VALUE INTO version FROM grr_setting WHERE NAME='version';

	IF version < '3.4.1' THEN
	ALTER TABLE grr_type_area ADD `couleur_texte` VARCHAR(10) NOT NULL DEFAULT '#000000' AFTER `disponible`;
	
	-- Mise à jour de la version applicative
	UPDATE grr_setting SET VALUE='3.4.1' WHERE NAME='version';

	END IF;
END|
DELIMITER ;

CALL 340to341();
DROP PROCEDURE 340to341;

-- ------------------------------------------------------------------------------------------------------------------------------------------
-- ------------- Création admin secondaire --------------------------------------------------------------------------------------------------
-- ------------------------------------------------------------------------------------------------------------------------------------------
%if %%is_defined('activer_addadmin') and %%activer_addadmin == 'oui'

DROP PROCEDURE IF EXISTS AddAdminGrr;
delimiter |
CREATE PROCEDURE AddAdminGrr(_adminuser VARCHAR( 32 ))
BEGIN
    DECLARE ad_id INT DEFAULT 0;

    SELECT COUNT(*) INTO ad_id FROM grr_utilisateurs WHERE login=_adminuser;

    IF ad_id = 0 THEN
        INSERT IGNORE INTO `grr_utilisateurs` (`login`, `nom`, `prenom`, `password`, `email`, `statut`, `etat`, `default_site`, `default_area`, `default_room`, `default_style`, `default_list_type`, `default_language`, `source`) VALUES
        ( _adminuser,'Envole','Administrateur','','','administrateur','actif',0,0,0,'','','','ext');
    END IF;

    UPDATE grr_utilisateurs SET statut = 'administrateur' WHERE login = _adminuser;

END|
DELIMITER ;

CALL AddAdminGrr('%%uid_addadmin');

%end if

-- ------------------------------------------------------------------------------------------------------------------------------------------
-- ------------- Mise à jour des paramètres de connexion au SSO -----------------------------------------------------------------------------
-- ------------------------------------------------------------------------------------------------------------------------------------------

DROP PROCEDURE IF EXISTS SetCASParameters;
delimiter |

CREATE PROCEDURE SetCASParameters(_sso_statut VARCHAR( 20 ), _cas_port VARCHAR( 5 ), _cas_server VARCHAR( 255 ), _cas_folder VARCHAR ( 255 ))
BEGIN
    DECLARE is_set_sso_statut INT DEFAULT 0;
    UPDATE grr_setting SET value = _cas_port WHERE name = 'cas_port';
    UPDATE grr_setting SET value = _cas_server WHERE name = 'cas_serveur';
    UPDATE grr_setting SET value = _cas_folder WHERE name = 'cas_racine';
    SELECT COUNT(*) INTO is_set_sso_statut FROM grr_setting WHERE name = 'sso_statut';
    IF is_set_sso_statut = 1 THEN
        DELETE FROM grr_setting WHERE name = 'sso_statut';
    END IF;
    IF _sso_statut != '' THEN
        INSERT INTO grr_setting VALUES ('sso_statut', _sso_statut);
    END IF;

END|
DELIMITER ;
%set %%sso_statut = 'cas_utilisateur' if %%getVar('grr_cas_auth', 'non') == 'oui' else ''
CALL SetCASParameters('%%sso_statut', '%%eolesso_port', '%%eolesso_adresse', '%%eolesso_cas_folder');

-- ------------------------------------------------------------------------------------------------------------------------------------------
-- Suppression des procédures et fonctions en sortant
-- ------------------------------------------------------------------------------------------------------------------------------------------
DROP PROCEDURE IF EXISTS addFieldIfNotExists;
DROP FUNCTION IF EXISTS isFieldExisting;
DROP PROCEDURE IF EXISTS AddAdminGrr;
DROP PROCEDURE IF EXISTS SetCASParameters;

-- ------------------------------------------------------------------------------------------------------------------------------------------
-- Fin du si GRR est activé
-- ------------------------------------------------------------------------------------------------------------------------------------------
%end if
