-- création de la base de donnée
CREATE DATABASE grr DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

use grr;

-- Adminer 4.6.2 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

DROP TABLE IF EXISTS `grr_area`;
CREATE TABLE `grr_area` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `area_name` varchar(30) NOT NULL DEFAULT '',
  `access` char(1) NOT NULL DEFAULT '',
  `order_display` smallint(6) NOT NULL DEFAULT '0',
  `ip_adr` varchar(15) NOT NULL DEFAULT '',
  `morningstarts_area` smallint(6) NOT NULL DEFAULT '0',
  `eveningends_area` smallint(6) NOT NULL DEFAULT '0',
  `duree_max_resa_area` int(11) NOT NULL DEFAULT '-1',
  `resolution_area` int(11) NOT NULL DEFAULT '0',
  `eveningends_minutes_area` smallint(6) NOT NULL DEFAULT '0',
  `weekstarts_area` smallint(6) NOT NULL DEFAULT '0',
  `twentyfourhour_format_area` smallint(6) NOT NULL DEFAULT '0',
  `calendar_default_values` char(1) NOT NULL DEFAULT 'y',
  `enable_periods` char(1) NOT NULL DEFAULT 'n',
  `display_days` varchar(7) NOT NULL DEFAULT 'yyyyyyy',
  `id_type_par_defaut` int(11) NOT NULL DEFAULT '-1',
  `duree_par_defaut_reservation_area` int(11) NOT NULL DEFAULT '0',
  `max_booking` smallint(6) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `grr_area` (`id`, `area_name`, `access`, `order_display`, `ip_adr`, `morningstarts_area`, `eveningends_area`, `duree_max_resa_area`, `resolution_area`, `eveningends_minutes_area`, `weekstarts_area`, `twentyfourhour_format_area`, `calendar_default_values`, `enable_periods`, `display_days`, `id_type_par_defaut`, `duree_par_defaut_reservation_area`, `max_booking`) VALUES
(1,	'Domaine 1',	'a',	0,	'',	8,	19,	-1,	1800,	0,	1,	1,	'n',	'n',	'yyyyyyy',	-1,	1800,	-1);

DROP TABLE IF EXISTS `grr_area_periodes`;
CREATE TABLE `grr_area_periodes` (
  `id_area` int(11) NOT NULL DEFAULT '0',
  `num_periode` smallint(6) NOT NULL DEFAULT '0',
  `nom_periode` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_area`,`num_periode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_calendar`;
CREATE TABLE `grr_calendar` (
  `DAY` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_calendrier_feries`;
CREATE TABLE `grr_calendrier_feries` (
  `DAY` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_calendrier_jours_cycle`;
CREATE TABLE `grr_calendrier_jours_cycle` (
  `DAY` int(11) NOT NULL DEFAULT '0',
  `Jours` varchar(20) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_calendrier_vacances`;
CREATE TABLE `grr_calendrier_vacances` (
  `DAY` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_correspondance_statut`;
CREATE TABLE `grr_correspondance_statut` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code_fonction` varchar(30) NOT NULL,
  `libelle_fonction` varchar(200) NOT NULL,
  `statut_grr` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_entry`;
CREATE TABLE `grr_entry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `start_time` int(11) NOT NULL DEFAULT '0',
  `end_time` int(11) NOT NULL DEFAULT '0',
  `entry_type` int(11) NOT NULL DEFAULT '0',
  `repeat_id` int(11) NOT NULL DEFAULT '0',
  `room_id` int(11) NOT NULL DEFAULT '1',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_by` varchar(100) NOT NULL DEFAULT '',
  `beneficiaire_ext` varchar(200) NOT NULL DEFAULT '',
  `beneficiaire` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(80) NOT NULL DEFAULT '',
  `type` char(2) NOT NULL DEFAULT 'A',
  `description` text,
  `statut_entry` char(1) NOT NULL DEFAULT '-',
  `option_reservation` int(11) NOT NULL DEFAULT '0',
  `overload_desc` text,
  `moderate` tinyint(1) DEFAULT '0',
  `jours` int(2) NOT NULL DEFAULT '0',
  `clef` int(2) NOT NULL DEFAULT '0',
  `courrier` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idxStartTime` (`start_time`),
  KEY `idxEndTime` (`end_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_entry_moderate`;
CREATE TABLE `grr_entry_moderate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login_moderateur` varchar(40) NOT NULL DEFAULT '',
  `motivation_moderation` text NOT NULL,
  `start_time` int(11) NOT NULL DEFAULT '0',
  `end_time` int(11) NOT NULL DEFAULT '0',
  `entry_type` int(11) NOT NULL DEFAULT '0',
  `repeat_id` int(11) NOT NULL DEFAULT '0',
  `room_id` int(11) NOT NULL DEFAULT '1',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_by` varchar(100) NOT NULL DEFAULT '',
  `beneficiaire_ext` varchar(200) NOT NULL DEFAULT '',
  `beneficiaire` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(80) NOT NULL DEFAULT '',
  `type` char(2) DEFAULT NULL,
  `description` text,
  `statut_entry` char(1) NOT NULL DEFAULT '-',
  `option_reservation` int(11) NOT NULL DEFAULT '0',
  `overload_desc` text,
  `moderate` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idxStartTime` (`start_time`),
  KEY `idxEndTime` (`end_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_j_mailuser_room`;
CREATE TABLE `grr_j_mailuser_room` (
  `login` varchar(40) NOT NULL DEFAULT '',
  `id_room` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`login`,`id_room`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_j_site_area`;
CREATE TABLE `grr_j_site_area` (
  `id_site` int(11) NOT NULL DEFAULT '0',
  `id_area` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_site`,`id_area`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_j_type_area`;
CREATE TABLE `grr_j_type_area` (
  `id_type` int(11) NOT NULL DEFAULT '0',
  `id_area` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_j_useradmin_area`;
CREATE TABLE `grr_j_useradmin_area` (
  `login` varchar(40) NOT NULL DEFAULT '',
  `id_area` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`login`,`id_area`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_j_useradmin_site`;
CREATE TABLE `grr_j_useradmin_site` (
  `login` varchar(40) NOT NULL DEFAULT '',
  `id_site` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`login`,`id_site`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_j_user_area`;
CREATE TABLE `grr_j_user_area` (
  `login` varchar(40) NOT NULL DEFAULT '',
  `id_area` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`login`,`id_area`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_j_user_room`;
CREATE TABLE `grr_j_user_room` (
  `login` varchar(40) NOT NULL DEFAULT '',
  `id_room` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`login`,`id_room`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_log`;
CREATE TABLE `grr_log` (
  `LOGIN` varchar(40) NOT NULL DEFAULT '',
  `START` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `SESSION_ID` varchar(64) NOT NULL DEFAULT '',
  `REMOTE_ADDR` varchar(16) NOT NULL DEFAULT '',
  `USER_AGENT` varchar(255) NOT NULL DEFAULT '',
  `REFERER` varchar(255) NOT NULL DEFAULT '',
  `AUTOCLOSE` enum('0','1') NOT NULL DEFAULT '0',
  `END` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`SESSION_ID`,`START`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_modulesext`;
CREATE TABLE `grr_modulesext` (
  `nom` varchar(50) NOT NULL,
  `actif` tinyint(1) NOT NULL DEFAULT '0',
  `version` int(11) NOT NULL,
  PRIMARY KEY (`nom`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_overload`;
CREATE TABLE `grr_overload` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_area` int(11) NOT NULL,
  `fieldname` varchar(55) NOT NULL DEFAULT '',
  `fieldtype` varchar(25) NOT NULL DEFAULT '',
  `fieldlist` text NOT NULL,
  `obligatoire` char(1) NOT NULL DEFAULT 'n',
  `affichage` char(1) NOT NULL DEFAULT 'n',
  `confidentiel` char(1) NOT NULL DEFAULT 'n',
  `overload_mail` char(1) NOT NULL DEFAULT 'n',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_page`;
CREATE TABLE `grr_page` (
  `nom` varchar(30) NOT NULL,
  `valeur` longtext NOT NULL,
  PRIMARY KEY (`nom`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `grr_page` (`nom`, `valeur`) VALUES
('CGU',	'Les CGU');

DROP TABLE IF EXISTS `grr_repeat`;
CREATE TABLE `grr_repeat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `start_time` int(11) NOT NULL DEFAULT '0',
  `end_time` int(11) NOT NULL DEFAULT '0',
  `rep_type` int(11) NOT NULL DEFAULT '0',
  `end_date` int(11) NOT NULL DEFAULT '0',
  `rep_opt` varchar(32) NOT NULL DEFAULT '',
  `room_id` int(11) NOT NULL DEFAULT '1',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `create_by` varchar(100) NOT NULL DEFAULT '',
  `beneficiaire_ext` varchar(200) NOT NULL DEFAULT '',
  `beneficiaire` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(80) NOT NULL DEFAULT '',
  `type` char(2) NOT NULL DEFAULT 'A',
  `description` text,
  `rep_num_weeks` tinyint(4) DEFAULT '0',
  `overload_desc` text,
  `jours` tinyint(2) NOT NULL DEFAULT '0',
  `courrier` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_room`;
CREATE TABLE `grr_room` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `area_id` int(11) NOT NULL DEFAULT '0',
  `room_name` varchar(60) NOT NULL DEFAULT '',
  `description` varchar(60) NOT NULL DEFAULT '',
  `capacity` int(11) NOT NULL DEFAULT '0',
  `max_booking` smallint(6) NOT NULL DEFAULT '-1',
  `statut_room` char(1) NOT NULL DEFAULT '1',
  `show_fic_room` char(1) NOT NULL DEFAULT 'n',
  `picture_room` varchar(50) NOT NULL DEFAULT '',
  `comment_room` text NOT NULL,
  `show_comment` char(1) NOT NULL DEFAULT 'n',
  `delais_max_resa_room` smallint(6) NOT NULL DEFAULT '-1',
  `delais_min_resa_room` smallint(6) NOT NULL DEFAULT '0',
  `allow_action_in_past` char(1) NOT NULL DEFAULT 'n',
  `dont_allow_modify` char(1) NOT NULL DEFAULT 'n',
  `order_display` smallint(6) NOT NULL DEFAULT '0',
  `delais_option_reservation` smallint(6) NOT NULL DEFAULT '0',
  `type_affichage_reser` smallint(6) NOT NULL DEFAULT '0',
  `moderate` tinyint(1) DEFAULT '0',
  `qui_peut_reserver_pour` char(1) NOT NULL DEFAULT '5',
  `active_ressource_empruntee` char(1) NOT NULL DEFAULT 'y',
  `active_cle` char(1) NOT NULL DEFAULT 'y',
  `who_can_see` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `grr_room` (`id`, `area_id`, `room_name`, `description`, `capacity`, `max_booking`, `statut_room`, `show_fic_room`, `picture_room`, `comment_room`, `show_comment`, `delais_max_resa_room`, `delais_min_resa_room`, `allow_action_in_past`, `dont_allow_modify`, `order_display`, `delais_option_reservation`, `type_affichage_reser`, `moderate`, `qui_peut_reserver_pour`, `active_ressource_empruntee`, `active_cle`, `who_can_see`) VALUES
(1,	1,	'Ressource 1',	'',	0,	-1,	'1',	'n',	'',	'',	'n',	-1,	0,	'n',	'n',	0,	0,	0,	0,	'5',	'y',	'y',	0);

DROP TABLE IF EXISTS `grr_setting`;
CREATE TABLE `grr_setting` (
  `NAME` varchar(32) NOT NULL DEFAULT '',
  `VALUE` text NOT NULL,
  PRIMARY KEY (`NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `grr_setting` (`NAME`, `VALUE`) VALUES
('acces_fiche_reservation',	'0'),
('ActiveModeDiagnostic',	'n'),
('allow_gestionnaire_modify_del',	'1'),
('allow_search_level',	'1'),
('allow_users_modify_email',	'2'),
('allow_users_modify_mdp',	'2'),
('allow_users_modify_profil',	'2'),
('allow_user_delete_after_begin',	'0'),
('area_list_format',	'item'),
('authentification_obli',	'0'),
('automatic_mail',	'yes'),
('begin_bookings',	'1514761200'),
('cas_port',	''),
('cas_racine',	''),
('cas_serveur',	''),
('company',	'Nom de l\'établissement'),
('ConvertLdapUtf8toIso',	'y'),
('default_css',	'default'),
('default_language',	'fr'),
('default_report_days',	'30'),
('default_room',	'-1'),
('default_site',	'-1'),
('disable_login',	'no'),
('display_full_description',	'1'),
('display_info_bulle',	'1'),
('display_level_email',	'0'),
('display_short_description',	'1'),
('end_bookings',	'1609369200'),
('envoyer_email_avec_formulaire',	'no'),
('file',	'1'),
('gestion_lien_aide',	'ext'),
('grr_mail_Bcc',	'n'),
('grr_mail_method',	'mail'),
('grr_mail_Password',	''),
('grr_mail_smtp',	''),
('grr_mail_Username',	''),
('grr_url',	'http://mon.site.fr/grr/'),
('ip_autorise',	''),
('javascript_info_admin_disabled',	'0'),
('javascript_info_disabled',	'0'),
('jours_cycles_actif',	'Non'),
('jour_debut_Jours/Cycles',	'1'),
('ldap_champ_email',	'mail'),
('ldap_champ_nom',	'sn'),
('ldap_champ_prenom',	'givenname'),
('ldap_champ_recherche',	'uid'),
('lien_aide',	''),
('longueur_liste_ressources_max',	'20'),
('mail_destinataire',	'test@test.fr'),
('mail_etat_destinataire',	'0'),
('maj194_champs_additionnels',	'1'),
('maj195_champ_rep_type_grr_repeat',	'1'),
('maj196_qui_peut_reserver_pour',	'1'),
('menu_gauche',	'1'),
('message_home_page',	'En raison du caractère personnel du contenu, ce site est soumis à des restrictions utilisateurs. Pour accéder aux outils de réservation, identifiez-vous :'),
('nb_calendar',	'1'),
('nombre_jours_Jours/Cycles',	'1'),
('pass_leng',	'8'),
('periodicite',	'y'),
('pview_new_windows',	'1'),
('remplissage_description_breve',	'1'),
('remplissage_description_complete',	'0'),
('sessionMaxLength',	'30'),
('smtp_port',	'25'),
('smtp_secure',	''),
('technical_support_email',	'support.technique@mon.site.fr'),
('title_home_page',	'Gestion et Réservation de Ressources'),
('url_disconnect',	''),
('UserAllRoomsMaxBooking',	'-1'),
('use_fckeditor',	'1'),
('verif_reservation_auto',	'0'),
('version',	'3.4.1'),
('versionRC',	''),
('visu_fiche_description',	'0'),
('webmaster_email',	'admin@mon.site.fr'),
('webmaster_name',	'Webmestre de GRR');

DROP TABLE IF EXISTS `grr_site`;
CREATE TABLE `grr_site` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sitecode` varchar(10) DEFAULT NULL,
  `sitename` varchar(50) NOT NULL DEFAULT '',
  `adresse_ligne1` varchar(38) DEFAULT NULL,
  `adresse_ligne2` varchar(38) DEFAULT NULL,
  `adresse_ligne3` varchar(38) DEFAULT NULL,
  `cp` varchar(5) DEFAULT NULL,
  `ville` varchar(50) DEFAULT NULL,
  `pays` varchar(50) DEFAULT NULL,
  `tel` varchar(25) DEFAULT NULL,
  `fax` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `grr_type_area`;
CREATE TABLE `grr_type_area` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type_name` varchar(30) NOT NULL DEFAULT '',
  `order_display` smallint(6) NOT NULL DEFAULT '0',
  `couleur` smallint(6) NOT NULL DEFAULT '0',
  `couleurhexa` varchar(10) NOT NULL,
  `type_letter` char(2) NOT NULL DEFAULT '',
  `disponible` varchar(1) NOT NULL DEFAULT '2',
  `couleur_texte` varchar(10) NOT NULL DEFAULT '#000000',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `grr_type_area` (`id`, `type_name`, `order_display`, `couleur`, `couleurhexa`, `type_letter`, `disponible`, `couleur_texte`) VALUES
(1,	'Cours',	1,	1,	'#1abc9c',	'A',	'2',	'#000'),
(2,	'Réunion',	2,	2,	'#C03000',	'B',	'2',	'#FFF'),
(3,	'Autre',	3,	3,	'#4BB5C1',	'C',	'2',	'#000');

DROP TABLE IF EXISTS `grr_utilisateurs`;
CREATE TABLE `grr_utilisateurs` (
  `login` varchar(40) NOT NULL DEFAULT '',
  `nom` varchar(30) NOT NULL DEFAULT '',
  `prenom` varchar(30) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `statut` varchar(30) NOT NULL DEFAULT '',
  `etat` varchar(20) NOT NULL DEFAULT '',
  `default_site` smallint(6) NOT NULL DEFAULT '0',
  `default_area` smallint(6) NOT NULL DEFAULT '0',
  `default_room` smallint(6) NOT NULL DEFAULT '0',
  `default_style` varchar(50) NOT NULL DEFAULT '',
  `default_list_type` varchar(50) NOT NULL DEFAULT '',
  `default_language` char(3) NOT NULL DEFAULT '',
  `source` varchar(10) NOT NULL DEFAULT 'local',
  PRIMARY KEY (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `grr_utilisateurs` (`login`, `nom`, `prenom`, `password`, `email`, `statut`, `etat`, `default_site`, `default_area`, `default_room`, `default_style`, `default_list_type`, `default_language`, `source`) VALUES
('ADMINISTRATEUR',	'Administrateur',	'grr',	'ab4f63f9ac65152575886860dde480a1',	'admin@labas.fr',	'administrateur',	'actif',	0,	0,	0,	'default',	'item',	'fr',	'local');


