#!/bin/bash

if [ "$4" == "" ]; then
    echo "syntaxe $(basename $0) <NomDomaine> <Account> <GroupeProprietaire> <SeparateurWinbind>"
    exit 1
fi

DIR_INDIVIDUEL=/data/bureautique/individuel
CURRENT_UMASK=$(umask)
DIR_SKEL="/etc/skel"

# le quatrième paramètre correspond au séparateur winbind

if [ ! -e $DIR_INDIVIDUEL/"$1"/"$2" ]; then
    if [ ! -e "$DIR_INDIVIDUEL/$1" ]; then
        mkdir $DIR_INDIVIDUEL/"$1"
        chmod 755 $DIR_INDIVIDUEL/"$1"
    fi
    umask=0066
    mkdir $DIR_INDIVIDUEL/"$1"/"$2"
    cp $DIR_SKEL/.bash_logout $DIR_SKEL/.bashrc $DIR_SKEL/.profile $DIR_INDIVIDUEL/"$1"/"$2"
    chown -R "$1""$4""$2":"$3" $DIR_INDIVIDUEL/"$1"/"$2"
    chmod g-s $DIR_INDIVIDUEL/"$1"/"$2"
    chmod 0711 $DIR_INDIVIDUEL/"$1"/"$2"
    chmod g-r,o-r $DIR_INDIVIDUEL/"$1"/"$2"/.bash_logout
    chmod g-r,o-r $DIR_INDIVIDUEL/"$1"/"$2"/.bashrc
    chmod g-r,o-r $DIR_INDIVIDUEL/"$1"/"$2"/.profile
    umask=$CURRENT_UMASK
fi
exit 0

