# -*- coding: utf-8 -*-
'''
Support for Linux File Access Control Lists
'''
from creole.client import CreoleClient as _CreoleClient
from os.path import abspath as _abspath
_DIRECTORIES = _CreoleClient().get('.acl.acl.directories')


def report(path, **kwargs):
    path = _abspath(path)
    for directory in _DIRECTORIES:
        if path.startswith(directory):
            break
    else:
        return
    return __salt__['quota.report'](path)


def set(path, **kwargs):
    path = _abspath(path)
    for directory in _DIRECTORIES:
        if path.startswith(directory):
            break
    else:
        return
    pass
    return __salt__['quota.set'](path, **kwargs)
