/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   iron-iconset-svg.html
 */

/// <reference path="../polymer/types/polymer.d.ts" />
/// <reference path="../iron-meta/iron-meta.d.ts" />

/**
 * The `iron-iconset-svg` element allows users to define their own icon sets
 * that contain svg icons. The svg icon elements should be children of the
 * `iron-iconset-svg` element. Multiple icons should be given distinct id's.
 *
 * Using svg elements to create icons has a few advantages over traditional
 * bitmap graphics like jpg or png. Icons that use svg are vector based so
 * they are resolution independent and should look good on any device. They
 * are stylable via css. Icons can be themed, colorized, and even animated.
 *
 * Example:
 *
 *     <iron-iconset-svg name="my-svg-icons" size="24">
 *       <svg>
 *         <defs>
 *           <g id="shape">
 *             <rect x="12" y="0" width="12" height="24" />
 *             <circle cx="12" cy="12" r="12" />
 *           </g>
 *         </defs>
 *       </svg>
 *     </iron-iconset-svg>
 *
 * This will automatically register the icon set "my-svg-icons" to the iconset
 * database.  To use these icons from within another element, make a
 * `iron-iconset` element and call the `byId` method
 * to retrieve a given iconset. To apply a particular icon inside an
 * element use the `applyIcon` method. For example:
 *
 *     iconset.applyIcon(iconNode, 'car');
 */
interface IronIconsetSvgElement extends Polymer.Element {

  /**
   * The name of the iconset.
   */
  name: string|null|undefined;

  /**
   * The size of an individual icon. Note that icons must be square.
   */
  size: number|null|undefined;

  /**
   * Set to true to enable mirroring of icons where specified when they are
   * stamped. Icons that should be mirrored should be decorated with a
   * `mirror-in-rtl` attribute.
   *
   * NOTE: For performance reasons, direction will be resolved once per
   * document per iconset, so moving icons in and out of RTL subtrees will
   * not cause their mirrored state to change.
   */
  rtlMirroring: boolean|null|undefined;

  /**
   * Set to true to measure RTL based on the dir attribute on the body or
   * html elements (measured on document.body or document.documentElement as
   * available).
   */
  useGlobalRtlAttribute: boolean|null|undefined;
  created(): void;
  attached(): void;

  /**
   * Construct an array of all icon names in this iconset.
   *
   * @returns Array of icon names.
   */
  getIconNames(): any[];

  /**
   * Applies an icon to the given element.
   *
   * An svg icon is prepended to the element's shadowRoot if it exists,
   * otherwise to the element itself.
   *
   * If RTL mirroring is enabled, and the icon is marked to be mirrored in
   * RTL, the element will be tested (once and only once ever for each
   * iconset) to determine the direction of the subtree the element is in.
   * This direction will apply to all future icon applications, although only
   * icons marked to be mirrored will be affected.
   *
   * @param element Element to which the icon is applied.
   * @param iconName Name of the icon to apply.
   * @returns The svg element which renders the icon.
   */
  applyIcon(element: Element|null, iconName: string): Element|null;

  /**
   * Remove an icon from the given element by undoing the changes effected
   * by `applyIcon`.
   *
   * @param element The element from which the icon is removed.
   */
  removeIcon(element: Element|null): void;

  /**
   * Measures and memoizes the direction of the element. Note that this
   * measurement is only done once and the result is memoized for future
   * invocations.
   */
  _targetIsRTL(target: any): any;

  /**
   * When name is changed, register iconset metadata
   */
  _nameChanged(): void;

  /**
   * Create a map of child SVG elements by id.
   *
   * @returns Map of id's to SVG elements.
   */
  _createIconMap(): object;

  /**
   * Produce installable clone of the SVG element matching `id` in this
   * iconset, or `undefined` if there is no matching element.
   *
   * @returns Returns an installable clone of the SVG element
   * matching `id`.
   */
  _cloneIcon(id: any, mirrorAllowed: any): Element|null;
  _prepareSvgClone(sourceSvg: Element|null, size: number, mirrorAllowed: Boolean|null): Element|null;
}

interface HTMLElementTagNameMap {
  "iron-iconset-svg": IronIconsetSvgElement;
}
