#!/usr/bin/python3
"""Module quota"""
from pyeole.process import system_code
from pyeole.bareosrestore import bareos_restore_one_file, exit_if_running_jobs


# COPY FROM fichier/quota.py
def set_quota(login, quota=0):
    """
    applique un nouveau quota disque
    pour un utilisateur
        @quota: int (str admis)
    """
    if type(quota) != int:
        try:
            quota = int(quota)
        except:
            raise Exception("valeur entière attendue pour un quota disque")
    cmd = ['/usr/sbin/quotatool', '-b',
           '-q', '%dM' % quota,
           '-l', '%dM' % (quota*2,),
           '-u', login, '/home']
    return system_code(cmd, container='fichier')


quotafile = "/home/backup/samba/sauv_quota.txt"

def execute(option, opt_str, value, parser, jobid, test_jobs=True):
    """ldap helper"""
    if len(parser.rargs) > 0:
        option = parser.rargs[0]
        if option == 'pre':
            pre()
        elif option == 'post':
            post()
    else:
        if test_jobs:
            exit_if_running_jobs()
        job(jobid)

def pre():
    print("pre quota")

def post():
    print("post quota")
    with open(quotafile, 'r') as fp:
        started = False
        for ligne in fp.readlines():
            if not started:
                if ligne.startswith('------------'):
                    started = True
                continue
            # cas plusieurs partitions
            if ligne.startswith('***'):
                started = False
                continue
            elts = ligne.strip().split()
            try:
                user  = elts[0]
                quota = elts[3]
            except:
                continue
            if quota != '0':
                set_quota(user, int(quota)//1024)

def job(jobid):
    print("Restauration quota")
    bareos_restore_one_file(quotafile, jobid)

priority=40
