# -*- coding: utf-8 -*-
#
##########################################################################
# eoleflask
# Copyright © 2013 Pôle de compétences EOLE <eole@ac-dijon.fr>
#
# License CeCILL:
#  * in french: http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
#  * in english http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
##########################################################################

"""EOLE flask server

This flask server load all applications declared under
``/etc/eole/flask/enabled``

"""

from flask import Flask
from werkzeug.middleware.dispatcher import DispatcherMiddleware
from eoleflask.loader import get_apps_list

apps = get_apps_list()

def run(config=None):
    apps = get_apps_list(config)

    # FIXME: dad: should provide a real root application
    first_application = apps[list(apps.keys())[0]]

    dispatcher = DispatcherMiddleware(first_application, apps)
    return dispatcher

#dispatcher.app.config['ROUTES'] = dispatcher.mounts
#dispatcher.app.config['AVAILABLE'] = dispatcher.mounts.copy()
