# -*- coding :utf-8 -*-

from json import dump, load
from hashlib import sha256
from os import urandom
import sys
from os.path import splitext, join, isfile, isdir
from os import walk, mkdir
from glob import glob
from eoleflask.util import APPS_CONF_DIR, APPS_ENABLE_DIR

KEYS_DIR = "/etc/eole/flask/keys/"

def save_file_key(app_name=None, secret=None):
    if not isdir(KEYS_DIR):
        if sys.version_info[0] >= 3:
            mkdir(KEYS_DIR, 0o700)
        else:
            mkdir(KEYS_DIR, oct(448))
    keyfile = join(KEYS_DIR, '{0}.key'.format(app_name))
    secret_key = {'secret_key':secret}
    try:
        with open(keyfile, 'w') as keyfile_out:
            dump(secret_key, keyfile_out)
    except:
        raise "Flask key not writeable {0}".format(keyfile)

def generate_key(app_name=None, force=False):
    """ Generate or update the key for app_name """
    secret_key = sha256(urandom(24)).hexdigest()
    save_file_key(app_name, secret_key)
    return secret_key

def get_secret_key(app_name=None, force=False):
    """
    if force
    if not present
    if not loadable
    if key is None
    if value is None
    else pass
    """
    if force is True:
        return generate_key(app_name, force=force)
    if not isfile(join(KEYS_DIR,'{0}.key'.format(app_name))):
        return generate_key(app_name, force=True)
    with open(join(KEYS_DIR,'{0}.key'.format(app_name)), 'r') as keyfile_in:
        try:
            load(keyfile_in)
        except:
            return generate_key(app_name, force=True)
    with open(join(KEYS_DIR,'{0}.key'.format(app_name)), 'r') as keyfile_in:
        content = load(keyfile_in)
        if content is None:
            return generate_key(app_name, force=True)
        elif not 'secret_key' in content:
            return generate_key(app_name, force=True)
        elif content['secret_key'] is None:
            return generate_key(app_name, force=True)
        else:
            return content['secret_key']

def gen_secret_keys(force=False):
    """loop over all apps in /etc/eole/flask/enabled/
    and subdirectories containing 'enabled' directory
    """
    conf_dirs = [join(APPS_ENABLE_DIR)]
    for app_conf_dir in glob(join(APPS_CONF_DIR, '*', 'enabled')):
        if isdir(app_conf_dir):
            conf_dirs.append(app_conf_dir)
    for conf_dir in conf_dirs:
        for root, dirs, filenames in walk(conf_dir):
            for name in filenames:
                if not name.endswith('.conf'):
                    continue
                app_name = splitext(name)[0]
                get_secret_key(app_name, force=force)
