# -*- coding: utf-8 -*- #

from eoleauthlib.authclient import login_required, init_authentication
from eolegenconfig import webapi, app
from flask import session

def get_id_redis():
    return session.sid

webapi.lib.get_id = get_id_redis
# initialiazes session management and login/logout url with eoleauth
init_authentication(app)


glob = globals()

for func_name, options in webapi.api_funcs.items():
    route, methods, auth = options
    api_func = getattr(webapi, func_name)
    if methods is not None:
        api_func.methods = methods
    if auth:
        api_func = login_required(api_func)
    app.add_url_rule(route, func_name, api_func)
    glob[func_name] = api_func

after_request = webapi.after_request
