# -*- coding: utf-8 -*- #

import StringIO
import cjson

from os import path, unlink, close
from tempfile import mkstemp
from werkzeug import secure_filename
from flask import session, request, render_template, g, send_file
from eoleauthlib import authclient

from eolegenconfig.util import make_json_response, make_error_response
from eolegenconfig import app, lib
from tiramisu.error import PropertiesOptionError

api_funcs = {'quit':('/quit', ['POST'], False),
             'root':('/', None, True),
             'user':('/user', None, True),
             'test':('/test', None, True),
             'categories':('/categories', None, True),
             'init_categories':('/init_categories', None, True),
             'tags':('/categories/<category_name>/tags', None, True),
             'variables':('/categories/<category_name>/variables', None, True),
             'variables_set':('/variables/set/<variables_ids>', None, True),
             'update_variable':('/variables/<variable_name>', ['PUT'], True),
             'add_value':('/variables/<variable_name>/addValue', ['PUT'], True),
             'remove_value':('/variables/<variable_name>/removeValue/<index>', ['PUT'], True),
             'reset_variable':('/variables/<variable_name>/reset', ['PUT'], True),
             'modes':('/modes', None, True),
             'set_config_mode':('/modes/<mode>', ['PUT'], True),
             'validate_config':('/validate', ['POST'], True),
             'save_config':('/save', ['POST'], True),
             'download_config':('/download', ['GET'], True),
             'upload_config':('/upload', ['POST'], True),
             'discard_config':('/discard', ['POST'], True),
             'set_debug_param':('/setDebug', ['POST'], True),
             'get_debug_param':('/getDebug', ['GET'], True)
            }

@app.after_request
def after_request(response):
    zephir = getattr(g, 'zephir', None)
    if zephir is not None:
        id_ = lib.get_id()
        lib.init_zephir_session(id_, zephir)
    return response

def root():
    """Entry point of the application
    """
    id_ = lib.get_id()
    lib.init_session(id_)
    return render_template('index.html')

def user():
    """Route for username retrieval
    """
    id_ = lib.get_id()
    zephir = lib.get_zephir(id_)
    # sur Zéphir, l'authentification est gérée autrement
    if lib.init_zephir is None and zephir.get('reauth', False):
        lib.del_config(id_)
        user = authclient.get_active_client()
        return user.logout()
    keys = ['available', 'registered', 'server_ip', 'server_id', 'reauth']
    zephir_infos = {}
    for z_key in set(keys) & set(zephir.keys()):
        zephir_infos[z_key] = zephir[z_key]
    return(make_json_response({
            'name'  : session.get('username', 'dev user'),
            'zephir': zephir_infos
            }))

def test():
    """Route for unitary tests
    """
    return render_template('test.html')

def quit():
    """Route to quit GenConfig in application mode
    """
    proceed_kill = request.form.get('kill', False)
    id_ = lib.get_id()
    lib.del_session(id_)
    user = authclient.get_active_client()
    user.logout()
    if proceed_kill:
        lib.quit_genconfig(id_)
    return ''

def categories():
    zephir_sync = request.args.get('zephir_sync', 'false')
    zephir_sync = zephir_sync != 'false' or zephir_sync == 'true'
    try:
        init = request.args.get('init', False)
        return make_json_response(lib.get_categories(lib.get_id(), init=init, zephir_sync=zephir_sync))
    except Exception, err:
        #FIXME mettre dans les logs
        app.logger.error(err, exc_info=True)
        return make_error_response(err.message)

def init_categories():
    zephir_sync = request.args.get('zephir_sync', False)
    zephir_sync = zephir_sync != 'false' or zephir_sync == 'true'
    try:
        return make_json_response(lib.get_categories(lib.get_id(), get_nested=True, zephir_sync=zephir_sync))
    except Exception, err:
        #FIXME mettre dans les logs
        app.logger.error(err, exc_info=True)
        return make_error_response(err.message)

def tags(category_name):
    try:
        return make_json_response(lib.get_tags(lib.get_id(), category_name))
    except Exception, err:
        #FIXME mettre dans les logs
        app.logger.error(err, exc_info=True)
        return make_error_response(err.message)

def variables(category_name):
    id_ = lib.get_id()
    try:
        if not lib.is_category(id_, category_name):
            #FIXME bad id ?
            return make_error_response("Not a category")
        return make_json_response(lib.get_variables(id_, category_name))
    except Exception, err:
        app.logger.error(err, exc_info=True)
        return make_error_response(err.message)

def variables_set(variables_ids):
    variables = variables_ids.split(';')
    id_ = lib.get_id()
    try:
        return make_json_response(lib.get_variables_set(id_, variables))
    except Exception, err:
        app.logger.error(err, exc_info=True)
        return make_error_response(err.message)


def update_variable(variable_name = None):
    """
    returns: if category_name == cat2:
             [{'name': 'cat1', variables: []},
              {'name': 'cat2', variables: [{'name': 'var1' ....}]},
              {'name': 'cat1', variables: []},
    """
    if variable_name is not None:
        category_name = request.json.get('categoryid')
        master_name = request.json.get('groupid', None)
        value = request.json.get('value')
        try:
            if master_name is None:
                lib.set_value(lib.get_id(), category_name, variable_name,
                              value)
                ret = lib.get_variable(lib.get_id(), category_name,
                                       variable_name)
            else:
                index = request.json.get('index')
                variable_name = '_'.join(variable_name.split('_')[:-1])
                lib.set_value_multi(lib.get_id(), category_name, master_name,
                              variable_name, value, index)
                # TODO: return the sub variable if part of a group
                ret = {} #lib.get_variable(lib.get_id(), category_name,
                          #             master_name, variable_name)
            return make_json_response(ret)
        except Exception, err:
            app.logger.error(err, exc_info=True)
            return make_error_response(err.message)
    else:
        return make_error_response("pas de variable_name")


def add_value(variable_name = None):
    """
    returns: if category_name == cat2:
             [{'name': 'cat1', variables: []},
              {'name': 'cat2', variables: [{'name': 'var1' ....}]},
              {'name': 'cat1', variables: []},
    """
    if variable_name is not None:
        try:
            category_name = request.json.get('categoryid')
            master_name = request.json.get('name', None)
            lib.append_value(lib.get_id(), category_name, master_name, variable_name)
            return make_json_response(lib.get_variable(lib.get_id(), category_name,
                master_name))
        except Exception, err:
            app.logger.error(err, exc_info=True)
            return make_error_response(err.message)
    else:
        return make_error_response("pas de variable_name")


def remove_value(variable_name = None, index = None):
    """
    returns: if category_name == cat2:
             [{'name': 'cat1', variables: []},
              {'name': 'cat2', variables: [{'name': 'var1' ....}]},
              {'name': 'cat1', variables: []},
    """
    if variable_name is not None and index is not None:
        try:
            index = int(index)
            category_name = request.json.get('categoryid')
            master_name = request.json.get('groupid', None)
            value = request.json.get('value')
            lib.pop_value(lib.get_id(), category_name, master_name, variable_name, index)
            return make_json_response(lib.get_variable(lib.get_id(), category_name,
                variable_name))
        except Exception, err:
            app.logger.error(err, exc_info=True)
            return make_error_response(err.message)
    else:
        return make_error_response("pas de variable_name")


def reset_variable(variable_name = None):
    """
    returns: if category_name == cat2:
             [{'name': 'cat1', variables: []},
              {'name': 'cat2', variables: [{'name': 'var1' ....}]},
              {'name': 'cat1', variables: []},
    """
    if variable_name is not None:
        try:
            category_name = request.json.get('categoryid')
            master_name = request.json.get('groupid', None)
            if master_name is None:
                lib.reset_value(lib.get_id(), category_name, master_name, variable_name)
                try:
                    return make_json_response(lib.get_variable(lib.get_id(), category_name, variable_name))
                except PropertiesOptionError:
                    return make_json_response(request.json) # Si la variable vient à disparaitre
            else:
                variable_name = '_'.join(variable_name.split('_')[:-1])
                lib.reset_value(lib.get_id(), category_name, master_name, variable_name)
                try:
                    return make_json_response(lib.get_variable(lib.get_id(), category_name,
                        master_name))
                except PropertiesOptionError:
                    return make_json_response({})
        except Exception, err:
            app.logger.error(err, exc_info=True)
            return make_error_response(err.message)
    else:
        return make_error_response("pas de variable_name")


def modes():
    id_ = lib.get_id()
    try:
        return make_json_response(lib.get_modes(id_))
    except Exception, err:
        app.logger.error(err, exc_info=True)
        return make_error_response(err.message)


def set_config_mode(mode):
    id_ = lib.get_id()
    try:
        lib.set_mode(id_, mode)
        return make_json_response(request.json)
    except Exception, err:
        app.logger.error(err, exc_info=True)
        return make_error_response(err.message)


def validate_config():
    id_ = lib.get_id()
    zephir_sync = request.form.get('zephir_sync', False)
    try:
        ret = lib.valid_mandatory(id_, zephir_sync=zephir_sync)
        if ret:
            return make_json_response({ 'status': 'validate', 'variables': ret })
        diff = lib.diff_config(id_, zephir_sync=zephir_sync)
        if zephir_sync and diff == []:
            return make_json_response({ 'status': 'init' })
        return make_json_response({ 'status': 'diff', 'variables': diff })
    except lib.ConfigEmptyError, err:
        app.logger.error(err, exc_info=True)
        return make_json_response({ 'status': 'zephir_empty' })
    except Exception, err:
        app.logger.error(err, exc_info=True)
        return make_error_response(err.message)


def save_config():
    id_ = lib.get_id()
    source = request.form.get('source', None)
    try:
        lib.save_values(id_, 'save', source=source)
        lib.del_config(id_)
        return make_json_response({})
    except Exception, err:
        app.logger.error(err, exc_info=True)
        return make_error_response(err.message)


def download_config():
    try:
        id_ = lib.get_id()
        json_config = lib.get_values(id_)
        json_config = cjson.encode(json_config)
        strIO = StringIO.StringIO()
        strIO.write(json_config)
        strIO.seek(0)
        return send_file(strIO,
                     attachment_filename="config.eol",
                     as_attachment=True)
    except Exception, err:
        app.logger.error(err.message, exc_info=True)
        return make_error_response(err.message)


def allowed_file(filename):
    return '.' in filename and \
            filename.rsplit('.', 1)[1] in app.config['ALLOWED_EXTENSIONS']


def upload_config():
    try:
        upfile = request.files['file']
        if upfile and allowed_file(upfile.filename):
            filename = secure_filename(upfile.filename)
            f_ext = path.splitext(filename)[-1]
            descr, config_file = mkstemp(suffix=f_ext, dir=app.config['UPLOAD_FOLDER'])
            upfile.save(config_file)
            id_ = lib.get_id()
            lib.load_config(id_, config_file)
            if lib.get_load_error(id_) and lib.is_upgrade(id_) is False:
                return make_error_response("le fichier importé n'est pas dans un format connu.")
            else:
                load_errors = lib.get_load_errors(id_)
            # on supprime le fichier temporaire après chargement
            close(descr)
            unlink(config_file)
            for load_error in load_errors:
                app.logger.error(unicode(load_error, 'utf-8'))
            version = lib.get_upgrade_version(id_)
            return make_json_response({ 'filename': filename, 'errors': load_errors, 'version': version })
        else:
            return make_error_response("Le fichier de configuration doit obligatoirement avoir l'extension .eol.")
    except Exception, err:
        #le err.message d'un SyntaxError sont vide ... d'ou le str(err)
        app.logger.error(str(err), exc_info=True)
        return make_error_response(str(err))


def discard_config():
    id_ = lib.get_id()
    try:
        lib.del_config(id_)
        return make_json_response({})
    except Exception, err:
        app.logger.error(err, exc_info=True)
        return make_error_response(err.message)


def set_debug_param():
    id_ = lib.get_id()
    try:
        debug = request.form.get('debug') == 'true'
        debug = lib.set_debug(id_, debug)
        return make_json_response({ 'debug': debug })
    except Exception, err:
        app.logger.error(err, exc_info=True)
        return make_error_response(err.message)


def get_debug_param():
    id_ = lib.get_id()
    try:
        debug = lib.get_debug(id_)
        init = False
        errors = None
        if not lib.config_exists():
            init = True
        elif lib.is_upgrade(id_):
            init = True
            errors = lib.get_load_errors(id_)
        if lib.get_load_error(id_):
            init = True
            if errors is None:
                errors = ["Fichier de configuration invalide"]
        config = lib.get_config(id_)
        eole_module = config._getattr("creole.general.eole_module", force_permissive=True)
        eole_version = lib.get_version(id_)
        eole_release = lib.get_release(id_)

        return make_json_response({ 'debug': debug, 'init': init, 'version': lib.get_upgrade_version(id_),
                    'eole': {
                        'module' : eole_module,
                        'version': eole_version,
                        'release': eole_release,
                    },
                    'errors': errors})
    except Exception, err:
        app.logger.error(err, exc_info=True)
        return make_error_response(err.message)
