<?php
/**
 *
 * $Id$
 *
 * Copyright 2001, 2010 Thomas Belliard, Laurent Delineau, Eric Lebrun, Stephane Boireau, Julien Jocal
 *
 * This file is part of GEPI.
 *
 * GEPI is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GEPI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GEPI; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*

Génération du fichier XML devant être transmis au système
"admission post-bac"

La structure de ce fichier est connue et documentée. Ce script génère
un fichier XML conforme aux spécifications.

Trois types de données sont requises, chacune nécessitant un traitement
spécifique :
- les données de l'année en cours : facilement accessibles, connues
- les données des années précédentes : plus difficilement accessible,
et pas nécessairement complètes pour tous les élèves. Ce script part du
principe qu'on intègre tout ce qu'on peut, et que l'absence de données ne
constitue pas en soit une cause de blocage de l'export. Il serait néanmoins
judicieux de vérifier que ce comportement est conforme à ce qui est attendu
par APB.
- les données de configuration pour chaque enseignement, permettant de
déterminer si l'enseignement est une LV1/2/3, s'il s'agit d'un enseignement
de spécialité ou non, etc. Ces données sont paramétrées directement
dans ce module, pour ne pas surcharger les pages de paramétrage des
groupes. L'absences de paramètres pour un groupe donné entraîne un blocage
de l'export, pour éviter les erreurs.


Ce script n'a besoin d'aucun paramètre particulier pour pouvoir fonctionner.
L'utilisation des informations de paramétrage pour chaque classe permet 
de déterminer ce qui devra être inclus ou non.

*/

$plugin_version="2.16.2"; // la version du plugin

$bdd_type="utf8"; // utf8 ou iso 


// finalement cette fonction ne sert à rien : mieux vaut encoder lors de la génération du fichier
function encode($text) {
	global $bdd_type;
	if ($bdd_type=="iso") {
		return($text);
	} else {
		return($text);
	}
}


function calc_rang($note, $groupe_id, $periode, $annee) {
  $notes=array();
  $req=mysql_query("SELECT moyenne FROM `plugin_archAPB_notes` WHERE `code_service`=".$groupe_id." AND `trimestre`=".$periode." AND annee =".$annee." AND etat !='D' AND etat!='N' ORDER BY moyenne DESC");
  //echo "SELECT moyenne FROM `plugin_archAPB_notes` WHERE `code_service`=".$groupe_id." AND `trimestre`=".$periode." AND annee =".$annee." AND etat !='D' AND etat!='N' ORDER BY moyenne ASC";
  //echo mysql_error();
  //echo "<br/> la note : ".$note;
  //echo "les notes : ";
  while ($n=mysql_fetch_object($req)) {
    $notes[]=$n->moyenne;
    //echo " ".$n->moyenne;
  }
  if(!empty($notes)){
    $j=0;
    while ($note<$notes[$j] AND $j<sizeof($notes)-1) {
      $j++;
    }
    $j++;
    //echo " rang : ".$j;
    return ($j++);
  } else {
    return(0);
  }
}



//$utiliser_pdo = 'on';

$affiche_connexion = 'yes';
$niveau_arbo = "2";
// Initialisations files
include("../../lib/initialisations.inc.php");
// TESTS DE SECURITE
$resultat_session = $session_gepi->security_check();
if ($resultat_session == 'c') {
	header("Location: ../utilisateurs/mon_compte.php?change_mdp=yes");
	die();
} else if ($resultat_session == '0') {
	header("Location: ../logout.php?auto=1");
	die();
}

require_once("./helpers.inc.php");

/*
 * Liste des données requises :
 * - Etablissement : RNE, Nom, Code postal
 * - Classes : Code, année, nom, niveau [Premiere,Terminale], Prof principal (optionnel), decoupage des bulletins (en trimestre ou semestre)
 * - Services-notation (= enseignements évalués) : Code, année, trimestre, code-enseignants (lien vers l'enseignant), code-matiere (lien vers la matière), niveau langue-vivante [LV1, LV2, LV3], code langue vivante, nom groupe, moyenne classe, moyenne min, moyenne max, effectif
 * - Matières : Code, code-sconet, libellé, matiere-spécialité
 * - Langues vivantes : Code, libellé  // Cette distinction entre 'langue vivante' et 'services notation' est une abberration de modélisation...
 * - Enseignants : Code, nom, prénom
 * - Elèves : Code, INE, nom, prénom, date de naissance
 * 
 * Imbrication des données :
 * 'Etablissement' contient Classes, Services-notation, Matières, Langues vivantes, Enseignants, Eleves
 * Ensuite toutes les données d'évaluation sont sous 'Eleves'
 * Etablissement/Eleves/Annees-scolaires/Bulletins/Notes
 * 
 */


/*
 * Attributs utilisés spécifiquement par APB :
 * - classes : apb_niveau ['','premiere','terminale']
 * - j_groupes_classes : apb_langue_vivante ['LV1', 'LV2', 'LV3', '']
 * 
 */

if (!isset($_POST)) {
  echo "Vous ne pouvez pas accéder à ce script directement.";
  die();
}

// Initialisation des données de paramétrage de l'export

// Numéro de l'export
if (isset($_POST['num_export'])) {
  $numero_export = $_POST['num_export'];
  if (!is_numeric($numero_export)) {
    echo "Le numéro d'export n'est pas correct.";
    die();
  }
} else {
  echo "Impossible de déterminer le numéro de l'export.";
  die();
}

// Année
if (isset($_POST['annee'])) {
	
  $annee_scolaire = (int) $_POST['annee'];
  //echo $annee_scolaire;
  if (!is_numeric($annee_scolaire)) {
    echo "L'année n'est pas correcte (pas de type entier).";
    die();
  }
} else {
  echo "Impossible de déterminer l'année de l'export.";
  die();
}

if ($numero_export==2) {
//------------------------------------------------------ export de type 2 -------------------------------------------------------------
  $req_classes = mysql_query("SELECT id, nom_court classe, nom_complet, decoupage periodes FROM plugin_archAPB_classes WHERE niveau = 'terminale' AND annee = ".$annee_scolaire);
  $data_classes_term = array($annee_scolaire=>array());
  
  $an1=$annee_scolaire-1;
  $an2=$annee_scolaire-2;

  $data_classes = array($annee_scolaire=>array(),
                        $an1=>array(),
                        $an2=>array());

  // Limites de périodes
  $limites_periodes = array($annee_scolaire=>array(),
                        $an1=>array(),
                        $an2=>array());


  // on va mémoriser les infos sur les classes, tout en verifiant qu'elles ont bien été sauvegardées dans le plugin archivageAPB
  $succes = True;
  while ($cl = mysql_fetch_object($req_classes)) {
    // On initialise ce tableau pour plus tard, lorsque l'on traitera des groupes.
    //$data_groupes[$cl->classe] = array();
    // On stocke les données relatives aux classes de terminale, qui sont la base de cet export
    $classe_selected = (isset($_POST[trim($cl->id)]) && $_POST[trim($cl->id)] == '1') ? true : false;
    if ($classe_selected) {
      $req_apb= mysql_query("SELECT id,nom_court,nom_complet,login_pp,niveau,annee,decoupage,id_structure_sconet FROM plugin_archAPB_classes WHERE id = '".$cl->id."' AND annee = ".$annee_scolaire);
      if (mysql_num_rows($req_apb)==0) {
        echo "<p>Vous n'avez pas archivé de données pour la classe de ".$cl->nom_complet." pour l'année ".$annee_scolaire.". Vous devez le faire à l'aide du plugin Archivage APB.</p>";
        die();
      }
      $classe = mysql_fetch_object($req_apb);
      if ($classe->decoupage>=3) $classe->decoupage=3; // pour les lycees ayant plus de 3 périodes !
      $data_classes_term[$annee_scolaire][$cl->id] = array('code' => $classe->id,
                            'classe' => $classe->nom_court,
                            'id' => $classe->id,
                            'nom' => $classe->nom_court,
                            'annee' => $classe->annee,//strftime("%Y")-1, // L'année ici correspond toujours à l'année courante. Sauf pour tests : annee-1
                            'niveau' => $classe->niveau,
                            'decoupage' => $classe->decoupage,
                            'id_structure_sconet' => $classe->id_structure_sconet,
                            'login_pp' => $classe->login_pp
                          );
      // On s'occupe des limites de périodes, pour n'exporter que jusqu'à la dernière période saisie
      if (!array_key_exists($classe->decoupage,$limites_periodes)) {
        if (!isset($_POST[$classe->decoupage.'per'])) {
          echo "Impossible de trouver la limite de périodes.";
          die();
        } else if (!is_numeric($_POST[$classe->decoupage.'per'])) {
          echo "Impossible de déterminer la limite de périodes.";
          die();
        }
        $limites_periodes[$annee_scolaire][$classe->decoupage] = $_POST[$classe->decoupage.'per'];
      }
    }
  }


  // On s'occupe des classes de cette année
  $req_apb= mysql_query("SELECT id,nom_court,nom_complet,login_pp,niveau,annee,decoupage,id_structure_sconet FROM plugin_archAPB_classes WHERE annee = ".$annee_scolaire);
  while ($classe = mysql_fetch_object($req_apb)) {
    $classe_selected = (isset($_POST[trim($classe->id)]) && $_POST[trim($classe->id)] == '1') ? true : false;
    if ($classe_selected) {
	  if ($classe->decoupage>=3) $classe->decoupage=3; // pour les lycees ayant plus de 3 périodes !
      $data_classes[$classe->annee][$classe->id] = array('code' => $classe->id,
                          'classe' => $classe->nom_court,
                          'id' => $classe->id,
                          'nom' => $classe->nom_court,
                          'annee' => $classe->annee,
                          'niveau' => $classe->niveau,
                          'decoupage' => $classe->decoupage,
                          'id_structure_sconet' => $classe->id_structure_sconet,
                          'login_pp' => $classe->login_pp);
    }
  }
  $data_etablissement  = array();
  $data_etablissement['rne'] = $gepiSettings['gepiSchoolRne'];
  $data_etablissement['nom'] = encode($gepiSettings['gepiSchoolName']);
  $data_etablissement['cp'] = $gepiSettings['gepiSchoolZipCode'];

  // la partie xml a besoin de listes vides pour les années precedentes
  $data_classes[$annee_scolaire-1]=array();
  $data_classes[$annee_scolaire-2]=array();

  // Liste des élèves

  $data_eleves = array();

  foreach($data_classes_term[$annee_scolaire] as $classe) {
    $req_eleves = mysql_query("SELECT e.id id,e.ine ine,e.nom nom,e.prenom prenom,e.ddn ddn,e.id_classe id_classe,
                                em.code_mef code_mef, m.libelle_court libelle
                                FROM plugin_archAPB_eleves e, plugin_archAPB_eleves_mef em, plugin_archAPB_mef m
                                WHERE
                                e.id_classe = '".$classe['id']."'
                                AND e.annee=".$annee_scolaire."
                                AND em.no_gep = ine
                                AND em.annee = ".$annee_scolaire."
                                AND m.code_mef = em.code_mef");
                                    echo mysql_error();
    while($eleve = mysql_fetch_object($req_eleves)) {
      //$login_eleve = $eleve->login;
      $data_eleves[$eleve->ine] = array();
      $data_eleves[$eleve->ine]['code'] = $eleve->id;
      //$data_eleves[$login_eleve]['login'] = $eleve->login_eleve;
      $data_eleves[$eleve->ine]['ine'] = $eleve->ine;
      $data_eleves[$eleve->ine]['nom'] = $eleve->nom;
      $data_eleves[$eleve->ine]['prenom'] = $eleve->prenom;
      $data_eleves[$eleve->ine]['date-naissance'] = $eleve->ddn;
      $data_eleves[$eleve->ine]['code-classe'] = $classe['code'];
      $data_eleves[$eleve->ine]['code-mef'] = $eleve->code_mef;
      $data_eleves[$eleve->ine]['libelle-mef'] = $eleve->libelle;
    }
  }
  //print_r($data_eleves);

  // On traite maintenant les enseignements pour l'année en cours
  // Pour cela, on prend élève par élève, et on récupère tout au fur et à mesure.
  // Là encore, pas hyper optimisé au niveau des requêtes MySQL, puisqu'on boucle
  // sur les élèves. Il pourrait être judicieux de tenter ultérieurement des optimisations.

  // On boucle d'abord sur les élèves, puis sur les périodes, puis les enseignements.

  // On va renseigner au fur et à mesure les information de 'services-notations' et 'enseignants'
  $data_services_notations = array();
  $data_enseignants = array();
  $data_matieres = array();


  foreach($data_eleves as &$eleve) {
      //***************************************************************************
      //                              annee en cours
      //***************************************************************************
      $annee = $annee_scolaire; //$data_classes[$eleve['code-classe']]['annee'];
      //echo "annee : ".$annee;
      $eleve['annees-scolaires'] = array($annee => array(
                                                                  'annee' => $annee,
                                                                  'code-classe' => $eleve['code-classe'],
                                                                  'code-mef' => $eleve['code-mef'],
                                                                  'libelle-mef' => $eleve['libelle-mef'],
                                                                  'bulletins' => array()));
      // Boucle sur les périodes de l'année en cours
      //echo $eleve['code-classe'];
      //print_r($data_classes);
      $i=2 ; // en export 2, on ne traite que le 2e trimestre de terminale
      $eleve['annees-scolaires'][$annee]['bulletins'][$i] = array('trimestre' => $i, 'notes' => array());

      // Maintenant on boucle sur les différentes notes pour la période considérée
      // On ne se base plus sur les mécanismes existants dans le bulletin,mais sur les infos du plugin
      //
      // 1. On examine les notes qui ne sont pas des commentaires (!)
      $req_notes = mysql_query("SELECT annee, code_service, ine, moyenne, rang, trimestre , appreciation, etat
                                FROM plugin_archAPB_notes WHERE ine = '".$eleve['ine']."' AND annee =".$annee."
                                AND trimestre = ".$i." AND code_service!='MOYGEN'");
      // On passe les notes une par une
      while ($note = mysql_fetch_object($req_notes)) {
        $req_groupe = mysql_query("SELECT `id_gepi` id, `nom_complet` , `modalite` , `code_sconet` , `libelle_sconet` ,
                                  `login_prof` , `code_gestion_sconet`
                                  FROM `plugin_archAPB_matieres` WHERE id_gepi = '".$note->code_service."' AND annee = ".$annee." LIMIT 1");
        $groupe = mysql_fetch_object($req_groupe);
        if ($groupe) {
			if ($groupe->modalite!="Z") { // à ne pas prendre en compte, selon la demande faite lors de l'archivage
			  // On enregistre ce groupe dans la liste des services_notations s'il n'y est pas déjà
			  if (!array_key_exists($annee.$note->code_service."_".$i, $data_services_notations) ) {
				$req_stats1 = mysql_query("SELECT COUNT(DISTINCT(ine)) effectif FROM plugin_archAPB_notes
											WHERE code_service = '".$groupe->id."' AND
											  trimestre = '".$i."' AND annee = ".$annee);

				$stats1 = mysql_fetch_object($req_stats1);


				$req_stats2 = mysql_query("SELECT MIN(moyenne) note_min, MAX(moyenne) note_max, AVG(moyenne) moyenne
										   FROM plugin_archAPB_notes
										   WHERE code_service = '".$groupe->id."' AND
												 trimestre = '".$i."' AND annee = ".$annee." AND etat='S'");
				//echo mysql_error();
				$stats2 = mysql_fetch_object($req_stats2);

				// cas des groupes sans note - peu probable de tomber sur un prof qui a mis 0 à tout le monde non ?
				if ($stats2->note_max == 0 AND $stats2->note_min==0) {
				  $notemax='';
				  $notemin='';
				} else {
				  $notemax=$stats2->note_max;
				  $notemin=$stats2->note_min;
				}

				$data_services_notations[$annee.$groupe->id."_".$i] = array('code' => $groupe->id,
																  'annee' => $annee,
																  'trimestre' => $i,
																  'code-enseignant' => $groupe->login_prof,
																  'code-matiere' => $groupe->code_gestion_sconet,
																  'nom-groupe' => $groupe->nom_complet,
																  'id-structure-sconet' => $data_classes[$annee][$eleve['code-classe']]['id_structure_sconet'],
																  'effectif' => $stats1->effectif,
																  'moyenne-haute' => $notemax,
																  'moyenne-basse' => $notemin,
																  'moyenne-classe' => round($stats2->moyenne,2));
			  }
			  // On regarde si l'enseignant est déjà répertorié
			  if (!array_key_exists($groupe->login_prof, $data_enseignants)) {
				// Non, alors on va le chercher...
				$req_enseignant = mysql_query("SELECT nom, prenom FROM plugin_archAPB_profs WHERE login = '".$groupe->login_prof."'"); // AND annee = ".$annee);
				$enseignant = mysql_fetch_object($req_enseignant);
				$data_enseignants[$groupe->login_prof] = array('code' => $groupe->login_prof, 'nom' => $enseignant->nom, 'prenom' => $enseignant->prenom);
			  }
			  // Idem pour la matière
			  if (!array_key_exists($groupe->code_gestion_sconet, $data_matieres)) {
				$data_matieres[$groupe->code_gestion_sconet] = array('code' => $groupe->code_gestion_sconet,
																	'libelle' => $groupe->nom_complet,
																	'code-sconet' => $groupe->code_sconet,
																	'libelle-sconet' => $groupe->libelle_sconet);
			  }


				// Statut de la notation :
			  switch($note->etat) {
				case 'a':
				  $statut_note = 'A';
				  break;
				case 'n':
				  $statut_note = 'N';
				  break;
				case '-':
				  $statut_note = 'N';
				  break;
				case 'd':
				  $statut_note = 'D';
				  break;
				default:
				  $statut_note = 'S';
				}

				$rg = calc_rang($note->moyenne,$groupe->id,$i,$annee);

			  $eleve['annees-scolaires'][$annee]['bulletins'][$i]['notes'][$groupe->id."_".$i] = array(
				  'code-service-notation' => $groupe->id."_".$i,
				  'etat' => $note->etat,
				  'moyenne' => $note->moyenne,
				  'rang' => $rg, //$note->rang,
				  'appreciation' => $note->appreciation,
				  'modalite' => $groupe->modalite);
			} // Fin de modalite Z
		}
      } // Fin note

      // 2. On examine les appréciations de conseil de classe (MOYGEN)
      $req_notes = mysql_query("SELECT annee, code_service, ine, moyenne, rang, trimestre , appreciation, etat
                                FROM plugin_archAPB_notes WHERE ine = '".$eleve['ine']."' AND annee =".$annee."
                                AND trimestre = ".$i." AND code_service='MOYGEN'");
      // On passe les notes une par une
      while ($note = mysql_fetch_object($req_notes)) {
        // On enregistre ce groupe dans la liste des services_notations s'il n'y est pas déjà
        if (!array_key_exists($annee.$note->code_service."_".$eleve['code-classe']."_".$i, $data_services_notations) ) {
          $req_stats1 = mysql_query("SELECT COUNT(DISTINCT(ine)) effectif FROM plugin_archAPB_eleves
                                        WHERE id_classe = '".$eleve['code-classe']."' AND annee =".$annee);

          $stats1 = mysql_fetch_object($req_stats1);

          // on récupère le login du prof
          $req_prof=mysql_query("SELECT login_pp login FROM plugin_archAPB_classes WHERE id=".$eleve['code-classe']." and annee =".$annee);
          $login_prof=mysql_fetch_object($req_prof)->login;

          $data_services_notations[$annee.$note->code_service."_".$eleve['code-classe']."_".$i] = array('code' => $note->code_service."_".$eleve['code-classe']."_".$i,
                                                            'annee' => $annee,
                                                            'trimestre' => $i,
                                                            'code-enseignant' => $login_prof, //$groupe->login_prof,
                                                            'code-matiere' => "MOYGEN",
                                                            'nom-groupe' => "",
                                                            'id-structure-sconet' => $data_classes[$annee][$eleve['code-classe']]['id_structure_sconet'],
                                                            'effectif' => $stats1->effectif,
                                                            'moyenne-haute' => 0,
                                                            'moyenne-basse' => 0);
        }
        // On regarde si l'enseignant est déjà répertorié
        if (!array_key_exists($login_prof, $data_enseignants)) {
          // Non, alors on va le chercher...
          $req_enseignant = mysql_query("SELECT nom, prenom FROM plugin_archAPB_profs WHERE login = '".$login_prof."'");// AND annee =".$annee);
          $enseignant = mysql_fetch_object($req_enseignant);
          $data_enseignants[$login_prof] = array('code' => $login_prof, 'nom' => $enseignant->nom, 'prenom' => $enseignant->prenom);
        }
        // Idem pour la matière
        if (!array_key_exists("MOYGEN", $data_matieres)) {
          $data_matieres["MOYGEN"] = array('code' => "MOYGEN",
                                           'libelle' => "Appréciation générale",
                                           'code-sconet' => "",
                                           'libelle-sconet' => "");
        }


          // Statut de la notation :
        switch($note->etat) {
          case 'a':
            $statut_note = 'A';
            break;
          case 'n':
            $statut_note = 'N';
            break;
          case '-':
            $statut_note = 'N';
            break;
          case 'd':
            $statut_note = 'D';
            break;
          default:
            $statut_note = 'S';
          }

        $eleve['annees-scolaires'][$annee]['bulletins'][$i]['notes'][$note->code_service."_".$eleve['code-classe']."_".$i] = array(
            'code-service-notation' => $note->code_service."_".$eleve['code-classe']."_".$i,
            'etat' => $statut_note,
            'moyenne' => "",
            'rang' => "",
            'appreciation' => $note->appreciation,
            'modalite' => "S");
      } // Fin appreciation
  }
}
else {
//------------------------------------------------------ export de type 1 -------------------------------------------------------------

  //$req_classes = mysql_query("SELECT id, classe, nom_complet, MAX(p.num_periode) periodes, apb_niveau FROM classes c, periodes p WHERE c.apb_niveau = 'terminale' AND p.id_classe = c.id GROUP BY c.id");
  $req_classes = mysql_query("SELECT id, nom_court classe, nom_complet, decoupage periodes FROM plugin_archAPB_classes WHERE niveau = 'terminale' AND annee = ".$annee_scolaire);

  $an1=$annee_scolaire-1;
  $an2=$annee_scolaire-2;

  $data_classes_term = array($annee_scolaire=>array());

  $data_classes = array($annee_scolaire=>array(),
                        $an1=>array(),
                        $an2=>array());
  //$data_groupes = array();

  // Limites de périodes
  $limites_periodes = array($annee_scolaire=>array(),
                        $an1=>array(),
                        $an2=>array());


  // on va mémoriser les infos sur les classes, tout en verifiant qu'elles ont bien été sauvegardées dans le plugin archivageAPB
  $succes = True;
  while ($cl = mysql_fetch_object($req_classes)) {
    // On initialise ce tableau pour plus tard, lorsque l'on traitera des groupes.
    //$data_groupes[$cl->classe] = array();
    // On stocke les données relatives aux classes de terminale, qui sont la base de cet export
    $classe_selected = (isset($_POST[trim($cl->id)]) && $_POST[trim($cl->id)] == '1') ? true : false;
    if ($classe_selected) {
      $req_apb= mysql_query("SELECT id,nom_court,nom_complet,login_pp,niveau,annee,decoupage,id_structure_sconet FROM plugin_archAPB_classes WHERE id = '".$cl->id."' AND annee = ".$annee_scolaire);
      if (mysql_num_rows($req_apb)==0) {
        echo "<p>Vous n'avez pas archivé de données pour la classe de ".$cl->nom_complet." pour l'année ".$annee_scolaire.". Vous devez le faire à l'aide du plugin Archivage APB.</p>";
        die();
      }
      $classe = mysql_fetch_object($req_apb);
      if ($classe->decoupage>3) $classe->decoupage=3;
      $data_classes_term[$annee_scolaire][$cl->id] = array('code' => $classe->id,
                            'classe' => $classe->nom_court,
                            'id' => $classe->id,
                            'nom' => $classe->nom_court,
                            'annee' => $classe->annee,//strftime("%Y")-1, // L'année ici correspond toujours à l'année courante. Sauf pour tests : annee-1
                            'niveau' => $classe->niveau,
                            'decoupage' => $classe->decoupage,
                            'id_structure_sconet' => $classe->id_structure_sconet,
                            'login_pp' => $classe->login_pp
                          );
      // On s'occupe des limites de périodes, pour n'exporter que jusqu'à la dernière période saisie
      if (!array_key_exists($classe->decoupage,$limites_periodes)) {
        if (!isset($_POST[$classe->decoupage.'per'])) {
          echo "Impossible de trouver la limite de périodes.";
          die();
        } else if (!is_numeric($_POST[$classe->decoupage.'per'])) {
          echo "Impossible de déterminer la limite de périodes.";
          die();
        }
        $limites_periodes[$annee_scolaire][$classe->decoupage] = $_POST[$classe->decoupage.'per'];
      }
    }
  }


  // On s'occupe des classes de cette année
  $req_apb= mysql_query("SELECT id,nom_court,nom_complet,login_pp,niveau,annee,decoupage,id_structure_sconet FROM plugin_archAPB_classes WHERE annee = ".$annee_scolaire);
  while ($classe = mysql_fetch_object($req_apb)) {
    $classe_selected = (isset($_POST[trim($classe->id)]) && $_POST[trim($classe->id)] == '1') ? true : false;
    if ($classe_selected) {
	  if ($classe->decoupage>3) $classe->decoupage=3;
      $data_classes[$classe->annee][$classe->id] = array('code' => $classe->id,
                          'classe' => $classe->nom_court,
                          'id' => $classe->id,
                          'nom' => $classe->nom_court,
                          'annee' => $classe->annee,
                          'niveau' => $classe->niveau,
                          'decoupage' => $classe->decoupage,
                          'id_structure_sconet' => $classe->id_structure_sconet,
                          'login_pp' => $classe->login_pp);
    }
  }
  // On s'occupe des classes de l'année dernière
  $req_apb= mysql_query("SELECT id,nom_court,nom_complet,login_pp,niveau,annee,decoupage,id_structure_sconet FROM plugin_archAPB_classes WHERE annee = ".$an1." OR annee = ".$an2);
  while ($classe = mysql_fetch_object($req_apb)) {
	if ($classe->decoupage>3) $classe->decoupage=3;
    $data_classes[$classe->annee][$classe->id] = array('code' => $classe->id,
                        'classe' => $classe->nom_court,
                        'id' => $classe->id,
                        'nom' => $classe->nom_court,
                        'annee' => $classe->annee,
                        'niveau' => $classe->niveau,
                        'decoupage' => $classe->decoupage,
                        'id_structure_sconet' => $classe->id_structure_sconet,
                        'login_pp' => $classe->login_pp);
  }

  //print_r($data_classes);

  // On va initialiser toutes les données dans diverses tableaux. Ensuite
  // on va parcourir les tableaux et utiliser les outils adéquats pour générer le XML
  // Ce n'est pas vraiment le plus efficace d'un point de vue de gestion de la mémoire,
  // mais certainement le plus simple et le plus lisible dans le script.
  // Idéalement, il faudrait utiliser les classes Propel et faire proprement les
  // requêtes à travers des méthodes spécifiques (ou génériques, selon les cas).
  // Au pire, ce passage vers Propel pourra se faire ultérieurement. Ce fichier
  // devrait etre suffisamment lisible pour que la transition ne prenne que
  // peu de temps, une fois que toutes les modèles Propel sont correctement construits.

  $data_etablissement  = array();
  $data_etablissement['rne'] = $gepiSettings['gepiSchoolRne'];
  $data_etablissement['nom'] = encode($gepiSettings['gepiSchoolName']);
  $data_etablissement['cp'] = $gepiSettings['gepiSchoolZipCode'];

  // Liste des élèves

  $data_eleves = array();

  foreach($data_classes_term[$annee_scolaire] as $classe) {
    $req_eleves = mysql_query("SELECT e.id id,e.ine ine,e.nom nom,e.prenom prenom,e.ddn ddn,e.id_classe id_classe,
                                em.code_mef code_mef, m.libelle_court libelle
                                FROM plugin_archAPB_eleves e, plugin_archAPB_eleves_mef em, plugin_archAPB_mef m
                                WHERE
                                e.id_classe = '".$classe['id']."'
                                AND e.annee=".$annee_scolaire."
                                AND em.no_gep = ine
                                AND em.annee = ".$annee_scolaire."
                                AND m.code_mef = em.code_mef");
                                    echo mysql_error();
    while($eleve = mysql_fetch_object($req_eleves)) {
      //$login_eleve = $eleve->login;
      $data_eleves[$eleve->ine] = array();
      $data_eleves[$eleve->ine]['code'] = $eleve->id;
      //$data_eleves[$login_eleve]['login'] = $eleve->login_eleve;
      $data_eleves[$eleve->ine]['ine'] = $eleve->ine;
      $data_eleves[$eleve->ine]['nom'] = $eleve->nom;
      $data_eleves[$eleve->ine]['prenom'] = $eleve->prenom;
      $data_eleves[$eleve->ine]['date-naissance'] = $eleve->ddn;
      $data_eleves[$eleve->ine]['code-classe'] = $classe['code'];
      $data_eleves[$eleve->ine]['code-mef'] = $eleve->code_mef;
      $data_eleves[$eleve->ine]['libelle-mef'] = $eleve->libelle;
    }
  }
  //print_r($data_eleves);

  // On traite maintenant les enseignements pour l'année en cours
  // Pour cela, on prend élève par élève, et on récupère tout au fur et à mesure.
  // Là encore, pas hyper optimisé au niveau des requêtes MySQL, puisqu'on boucle
  // sur les élèves. Il pourrait être judicieux de tenter ultérieurement des optimisations.

  // On boucle d'abord sur les élèves, puis sur les périodes, puis les enseignements.

  // On va renseigner au fur et à mesure les information de 'services-notations' et 'enseignants'
  $data_services_notations = array();
  $data_enseignants = array();
  $data_matieres = array();


  foreach($data_eleves as &$eleve) {
      //***************************************************************************
      //                              annee en cours
      //***************************************************************************
      $annee = $annee_scolaire; //$data_classes[$eleve['code-classe']]['annee'];
      //echo "annee : ".$annee;
      $eleve['annees-scolaires'] = array($annee => array(
                                                                  'annee' => $annee,
                                                                  'code-classe' => $eleve['code-classe'],
                                                                  'code-mef' => $eleve['code-mef'],
                                                                  'libelle-mef' => $eleve['libelle-mef'],
                                                                  'bulletins' => array()));
      // Boucle sur les périodes de l'année en cours
      //echo $eleve['code-classe'];
      //print_r($data_classes);
      for($i=1;$i<=$limites_periodes[$annee][$data_classes[$annee][$eleve['code-classe']]['decoupage']];$i++) {
        $eleve['annees-scolaires'][$annee]['bulletins'][$i] = array('trimestre' => $i, 'notes' => array());

        // Maintenant on boucle sur les différentes notes pour la période considérée
        // On ne se base plus sur les mécanismes existants dans le bulletin,mais sur les infos du plugin
        //
        // 1. On examine les notes qui ne sont pas des commentaires (!)
        $req_notes = mysql_query("SELECT annee, code_service, ine, moyenne, rang, trimestre , appreciation, etat
                                  FROM plugin_archAPB_notes WHERE ine = '".$eleve['ine']."' AND annee =".$annee."
                                  AND trimestre = ".$i." AND code_service!='MOYGEN'");
        // On passe les notes une par une
        while ($note = mysql_fetch_object($req_notes)) {
          $req_groupe = mysql_query("SELECT `id_gepi` id, `nom_complet` , `modalite` , `code_sconet` , `libelle_sconet` ,
                                    `login_prof` , `code_gestion_sconet`
                                    FROM `plugin_archAPB_matieres` WHERE id_gepi = '".$note->code_service."' AND annee = ".$annee." LIMIT 1");
/*
          echo "SELECT `id_gepi` id, `nom_complet` , `modalite` , `code_sconet` , `libelle_sconet` ,
                                    `login_prof` , `code_gestion_sconet`
                                    FROM `plugin_archAPB_matieres` WHERE id_gepi = '".$note->code_service."' AND annee = ".$annee." LIMIT 1"; 
*/
          $groupe = mysql_fetch_object($req_groupe);
          if ($groupe) {
			  if ($groupe->modalite!="Z") { // à ne pas prendre en compte, selon la demande faite lors de l'archivage
				// On enregistre ce groupe dans la liste des services_notations s'il n'y est pas déjà
				if (!array_key_exists($annee.$note->code_service."_".$i, $data_services_notations) ) {
				  $req_stats1 = mysql_query("SELECT COUNT(DISTINCT(ine)) effectif FROM plugin_archAPB_notes
											  WHERE code_service = '".$groupe->id."' AND
												trimestre = '".$i."' AND annee = ".$annee);

				  $stats1 = mysql_fetch_object($req_stats1);


				  $req_stats2 = mysql_query("SELECT MIN(moyenne) note_min, MAX(moyenne) note_max, AVG(moyenne) moyenne
											 FROM plugin_archAPB_notes
											 WHERE code_service = '".$groupe->id."' AND
												   trimestre = '".$i."' AND annee = ".$annee." AND etat='S'");
				  //echo mysql_error();
				  $stats2 = mysql_fetch_object($req_stats2);

				  // cas des groupes sans note - peu probable de tomber sur un prof qui a mis 0 à tout le monde non ?
				  if ($stats2->note_max == 0 AND $stats2->note_min==0) {
					$notemax='';
					$notemin='';
				  } else {
					$notemax=$stats2->note_max;
					$notemin=$stats2->note_min;
				  }

				  $data_services_notations[$annee.$groupe->id."_".$i] = array('code' => $groupe->id,
																	'annee' => $annee,
																	'trimestre' => $i,
																	'code-enseignant' => $groupe->login_prof,
																	'code-matiere' => $groupe->code_gestion_sconet,
																	'nom-groupe' => $groupe->nom_complet,
																	'id-structure-sconet' => $data_classes[$annee][$eleve['code-classe']]['id_structure_sconet'],
																	'effectif' => $stats1->effectif,
																	'moyenne-haute' => $notemax,
																	'moyenne-basse' => $notemin,
																	'moyenne-classe' => round($stats2->moyenne,2));
				}
				// On regarde si l'enseignant est déjà répertorié
				if (!array_key_exists($groupe->login_prof, $data_enseignants)) {
				  // Non, alors on va le chercher...
				  $req_enseignant = mysql_query("SELECT nom, prenom FROM plugin_archAPB_profs WHERE login = '".$groupe->login_prof."'"); // AND annee = ".$annee);
				  $enseignant = mysql_fetch_object($req_enseignant);
				  $data_enseignants[$groupe->login_prof] = array('code' => $groupe->login_prof, 'nom' => $enseignant->nom, 'prenom' => $enseignant->prenom);
				}
				// Idem pour la matière
				if (!array_key_exists($groupe->code_gestion_sconet, $data_matieres)) {
				  $data_matieres[$groupe->code_gestion_sconet] = array('code' => $groupe->code_gestion_sconet,
																	  'libelle' => $groupe->nom_complet,
																	  'code-sconet' => $groupe->code_sconet,
																	  'libelle-sconet' => $groupe->libelle_sconet);
				}


				  // Statut de la notation :
				switch($note->etat) {
				  case 'a':
					$statut_note = 'A';
					break;
				  case 'n':
					$statut_note = 'N';
					break;
				  case '-':
					$statut_note = 'N';
					break;
				  case 'd':
					$statut_note = 'D';
					break;
				  default:
					$statut_note = 'S';
				  }

				  $rg = calc_rang($note->moyenne,$groupe->id,$i,$annee);

				$eleve['annees-scolaires'][$annee]['bulletins'][$i]['notes'][$groupe->id."_".$i] = array(
					'code-service-notation' => $groupe->id."_".$i,
					'etat' => $note->etat,
					'moyenne' => $note->moyenne,
					'rang' => $rg, //$note->rang,
					'appreciation' => $note->appreciation,
					'modalite' => $groupe->modalite);
			  } // Fin de modalite Z
			}
        } // Fin note

        // 2. On examine les appréciations de conseil de classe (MOYGEN)
        $req_notes = mysql_query("SELECT annee, code_service, ine, moyenne, rang, trimestre , appreciation, etat
                                  FROM plugin_archAPB_notes WHERE ine = '".$eleve['ine']."' AND annee =".$annee."
                                  AND trimestre = ".$i." AND code_service='MOYGEN'");
        // On passe les notes une par une
        while ($note = mysql_fetch_object($req_notes)) {
          // On enregistre ce groupe dans la liste des services_notations s'il n'y est pas déjà
          if (!array_key_exists($annee.$note->code_service."_".$eleve['code-classe']."_".$i, $data_services_notations) ) {
            $req_stats1 = mysql_query("SELECT COUNT(DISTINCT(ine)) effectif FROM plugin_archAPB_eleves
                                          WHERE id_classe = '".$eleve['code-classe']."' AND annee =".$annee);

            $stats1 = mysql_fetch_object($req_stats1);

            // on récupère le login du prof
            $req_prof=mysql_query("SELECT login_pp login FROM plugin_archAPB_classes WHERE id=".$eleve['code-classe']." and annee =".$annee);
            $login_prof=mysql_fetch_object($req_prof)->login;

            $data_services_notations[$annee.$note->code_service."_".$eleve['code-classe']."_".$i] = array('code' => $note->code_service."_".$eleve['code-classe']."_".$i,
                                                              'annee' => $annee,
                                                              'trimestre' => $i,
                                                              'code-enseignant' => $login_prof, //$groupe->login_prof,
                                                              'code-matiere' => "MOYGEN",
                                                              'nom-groupe' => "",
                                                              'id-structure-sconet' => $data_classes[$annee][$eleve['code-classe']]['id_structure_sconet'],
                                                              'effectif' => $stats1->effectif,
                                                              'moyenne-haute' => 0,
                                                              'moyenne-basse' => 0);
          }
          // On regarde si l'enseignant est déjà répertorié
          if (!array_key_exists($login_prof, $data_enseignants)) {
            // Non, alors on va le chercher...
            $req_enseignant = mysql_query("SELECT nom, prenom FROM plugin_archAPB_profs WHERE login = '".$login_prof."'");// AND annee =".$annee);
            $enseignant = mysql_fetch_object($req_enseignant);
            $data_enseignants[$login_prof] = array('code' => $login_prof, 'nom' => $enseignant->nom, 'prenom' => $enseignant->prenom);
          }
          // Idem pour la matière
          if (!array_key_exists("MOYGEN", $data_matieres)) {
            $data_matieres["MOYGEN"] = array('code' => "MOYGEN",
                                             'libelle' => "Appréciation générale",
                                             'code-sconet' => "",
                                             'libelle-sconet' => "");
          }


            // Statut de la notation :
          switch($note->etat) {
            case 'a':
              $statut_note = 'A';
              break;
            case 'n':
              $statut_note = 'N';
              break;
            case '-':
              $statut_note = 'N';
              break;
            case 'd':
              $statut_note = 'D';
              break;
            default:
              $statut_note = 'S';
            }

          $eleve['annees-scolaires'][$annee]['bulletins'][$i]['notes'][$note->code_service."_".$eleve['code-classe']."_".$i] = array(
              'code-service-notation' => $note->code_service."_".$eleve['code-classe']."_".$i,
              'etat' => $statut_note,
              'moyenne' => "",
              'rang' => "",
              'appreciation' => $note->appreciation,
              'modalite' => "S");
        } // Fin appreciation

      } //Fin trimestre
      //***************************************************************************
      //                              annee précédente
      //***************************************************************************

      $annee=$an1;
      $req = mysql_query("SELECT id_classe,annee FROM plugin_archAPB_eleves WHERE ine = '".$eleve['ine']."' AND annee = ".$annee);
      if (mysql_num_rows($req)>0) {
        $tmpcl=mysql_fetch_object($req);
        $code_classe=$tmpcl->id_classe;
        $req2 = mysql_query("SELECT em.code_mef code_mef, m.libelle_court libelle_court
                            FROM plugin_archAPB_eleves_mef em, plugin_archAPB_mef m
                            WHERE em.no_gep = '".$eleve['ine']."' AND em.annee = ".$annee." AND m.code_mef=em.code_mef");
        $rep2 = mysql_fetch_object($req2);
        if ($rep2) {
          $cm = $rep2->code_mef;
          $lm = $rep2->libelle_court;
        } else {
          $cm = "";
          $lm = "";
        }
        $eleve['annees-scolaires'][$annee] = array('annee' => $annee,
                                                    'code-classe' => $code_classe,
                                                    'code-mef' => $cm,
                                                    'libelle-mef' => $lm,
                                                    'bulletins' => array());
        // Boucle sur les périodes de l'année en cours
        //echo $eleve['code-classe'];
        //print_r($data_classes);
        for($i=1;$i<=3;$i++) {
          $eleve['annees-scolaires'][$annee]['bulletins'][$i] = array('trimestre' => $i, 'notes' => array());

          // Maintenant on boucle sur les différentes notes pour la période considérée
          // On ne se base plus sur les mécanismes existants dans le bulletin,mais sur les infos du plugin
          //
          // 1. On examine les notes qui ne sont pas des commentaires (!)
          $req_notes = mysql_query("SELECT annee, code_service, ine, moyenne, rang, trimestre , appreciation, etat
                                    FROM plugin_archAPB_notes WHERE ine = '".$eleve['ine']."' AND annee =".$annee."
                                    AND trimestre = ".$i." AND code_service!='MOYGEN'");
          // On passe les notes une par une
          while ($note = mysql_fetch_object($req_notes)) {
            $req_groupe = mysql_query("SELECT `id_gepi` id, `nom_complet` , `modalite` , `code_sconet` , `libelle_sconet` ,
                                      `login_prof` , `code_gestion_sconet`
                                      FROM `plugin_archAPB_matieres` WHERE id_gepi = '".$note->code_service."' AND annee = ".$annee." LIMIT 1");
            //echo $eleve['ine']." <br/>";
            $groupe = mysql_fetch_object($req_groupe);
            //if (!$groupe) echo "<br/> AVANT : SELECT `id_gepi` id, `nom_complet` , `modalite` , `code_sconet` , `libelle_sconet` ,
            //                          `login_prof` , `code_gestion_sconet`
            //                          FROM `plugin_archAPB_matieres` WHERE id_gepi = '".$note->code_service."' AND annee = ".$annee." LIMIT 1 <br/>";
            //echo "<br/>groupe id 1 : ".$groupe->id." <br/>";
			if ($groupe) {
				if ($groupe->modalite!="Z") { // à ne pas prendre en compte, selon la demande faite lors de l'archivage
				  // On enregistre ce groupe dans la liste des services_notations s'il n'y est pas déjà
				  if (!array_key_exists($annee.$note->code_service."_".$i, $data_services_notations) ) {
					$req_stats1 = mysql_query("SELECT COUNT(DISTINCT(ine)) effectif FROM plugin_archAPB_notes
												WHERE code_service = '".$groupe->id."' AND
												  trimestre = '".$i."' AND annee = ".$annee);

					$stats1 = mysql_fetch_object($req_stats1);


					$req_stats2 = mysql_query("SELECT MIN(moyenne) note_min, MAX(moyenne) note_max, AVG(moyenne) moyenne
											   FROM plugin_archAPB_notes
											   WHERE code_service = '".$groupe->id."' AND
													 trimestre = '".$i."' AND annee = ".$annee." AND etat='S'");
					//echo mysql_error();
					$stats2 = mysql_fetch_object($req_stats2);

					if ($stats2->note_max == 0 AND $stats2->note_min==0) {
					  $notemax='';
					  $notemin='';
					} else {
					  $notemax=$stats2->note_max;
					  $notemin=$stats2->note_min;
					}

					$data_services_notations[$annee.$groupe->id."_".$i] = array('code' => $groupe->id,
																	  'annee' => $annee,
																	  'trimestre' => $i,
																	  'code-enseignant' => $groupe->login_prof,
																	  'code-matiere' => $groupe->code_gestion_sconet,
																	  'nom-groupe' => $groupe->nom_complet,
																	  'id-structure-sconet' => $data_classes[$annee][$code_classe]['id_structure_sconet'],
																	  'effectif' => $stats1->effectif,
																	  'moyenne-haute' => $notemax,
																	  'moyenne-basse' => $notemin,
																	  'moyenne-classe' => round($stats2->moyenne,2));
				  }
				  // On regarde si l'enseignant est déjà répertorié
				  if (!array_key_exists($groupe->login_prof, $data_enseignants)) {
					// Non, alors on va le chercher...
					$req_enseignant = mysql_query("SELECT nom, prenom FROM plugin_archAPB_profs WHERE login = '".$groupe->login_prof."'");// AND annee = ".$annee);
					//echo "SELECT nom, prenom FROM plugin_archAPB_profs WHERE login = '".$groupe->login_prof."' AND annee = ".$annee;
					$enseignant = mysql_fetch_object($req_enseignant);
					$data_enseignants[$groupe->login_prof] = array('code' => $groupe->login_prof, 'nom' => $enseignant->nom, 'prenom' => $enseignant->prenom);
				  }
				  // Idem pour la matière
				  if (!array_key_exists($groupe->code_gestion_sconet, $data_matieres)) {
					$data_matieres[$groupe->code_gestion_sconet] = array('code' => $groupe->code_gestion_sconet,
																		'libelle' => $groupe->nom_complet,
																		'code-sconet' => $groupe->code_sconet,
																		'libelle-sconet' => $groupe->libelle_sconet);
				  }


					// Statut de la notation :
				  switch($note->etat) {
					case 'a':
					  $statut_note = 'A';
					  break;
					case 'n':
					  $statut_note = 'N';
					  break;
					case '-':
					  $statut_note = 'N';
					  break;
					case 'd':
					  $statut_note = 'D';
					  break;
					default:
					  $statut_note = 'S';
					}
				  if (!$groupe) echo "<br/>groupe id : ".$groupe->id." - classe : ".$data_classes[$annee][$code_classe]['id_structure_sconet']."<br/>";
				  $rg = calc_rang($note->moyenne,$groupe->id,$i,$annee);

				  $eleve['annees-scolaires'][$annee]['bulletins'][$i]['notes'][$groupe->id."_".$i] = array(
					  'code-service-notation' => $groupe->id."_".$i,
					  'etat' => $note->etat,
					  'moyenne' => $note->moyenne,
					  'rang' => $rg,//$note->rang,
					  'appreciation' => $note->appreciation,
					  'modalite' => $groupe->modalite);
				} // Fin de modalite Z
			}
          } // Fin note

          // 2. On examine les appréciations de conseil de classe (MOYGEN)
          $req_notes = mysql_query("SELECT annee, code_service, ine, moyenne, rang, trimestre , appreciation, etat
                                    FROM plugin_archAPB_notes WHERE ine = '".$eleve['ine']."' AND annee =".$annee."
                                    AND trimestre = ".$i." AND code_service='MOYGEN'");
          // On passe les notes une par une
          while ($note = mysql_fetch_object($req_notes)) {
            // On enregistre ce groupe dans la liste des services_notations s'il n'y est pas déjà
            //if (!array_key_exists($annee.$note->code_service."_".$eleve['code-classe']."_".$i, $data_services_notations) ) {
            if (!array_key_exists($annee.$note->code_service."_".$code_classe."_".$i, $data_services_notations) ) {
              $req_stats1 = mysql_query("SELECT COUNT(DISTINCT(ine)) effectif FROM plugin_archAPB_eleves
                                            WHERE id_classe = '".$code_classe."' AND annee =".$annee);

              $stats1 = mysql_fetch_object($req_stats1);

              // on récupère le login du prof
              $req_prof=mysql_query("SELECT login_pp login FROM plugin_archAPB_classes WHERE id=".$code_classe." and annee =".$annee);
              //echo "SELECT login_pp login FROM plugin_archAPB_classes WHERE id=".$code_classe." and annee =".$annee."</br>";//debug
              $login_prof=mysql_fetch_object($req_prof)->login;

              $data_services_notations[$annee.$note->code_service."_".$code_classe."_".$i] = array('code' => $note->code_service."_".$code_classe."_".$i,
                                                                'annee' => $annee,
                                                                'trimestre' => $i,
                                                                'code-enseignant' => $login_prof, //$groupe->login_prof,
                                                                'code-matiere' => "MOYGEN",
                                                                'nom-groupe' => "",
                                                                'id-structure-sconet' => $data_classes[$annee][$code_classe]['id_structure_sconet'],
                                                                'effectif' => $stats1->effectif,
                                                                'moyenne-haute' => 0,
                                                                'moyenne-basse' => 0);
            }
            //echo "login prof : ".$login_prof." <br/>"; // debug
            // On regarde si l'enseignant est déjà répertorié
            if (!array_key_exists($login_prof, $data_enseignants)) {
              // Non, alors on va le chercher...
              $req_enseignant = mysql_query("SELECT nom, prenom FROM plugin_archAPB_profs WHERE login = '".$login_prof."'");// AND annee =".$annee);
              $enseignant = mysql_fetch_object($req_enseignant);
              $data_enseignants[$login_prof] = array('code' => $login_prof, 'nom' => $enseignant->nom, 'prenom' => $enseignant->prenom);
            }
            // Idem pour la matière
            if (!array_key_exists("MOYGEN", $data_matieres)) {
              $data_matieres["MOYGEN"] = array('code' => "MOYGEN",
                                               'libelle' => "Appréciation générale",
                                               'code-sconet' => "",
                                               'libelle-sconet' => "");
            }


              // Statut de la notation :
            switch($note->etat) {
              case 'a':
                $statut_note = 'A';
                break;
              case 'n':
                $statut_note = 'N';
                break;
              case '-':
                $statut_note = 'N';
                break;
              case 'd':
                $statut_note = 'D';
                break;
              default:
                $statut_note = 'S';
              }

            $eleve['annees-scolaires'][$annee]['bulletins'][$i]['notes'][$note->code_service."_".$code_classe."_".$i] = array(
                'code-service-notation' => $note->code_service."_".$code_classe."_".$i,
                'etat' => $statut_note,
                'moyenne' => "",
                'rang' => "",
                'appreciation' => $note->appreciation,
                'modalite' => "S");
          } // Fin appreciation
        }
      }
  } //fin élèves

  //print_r($data_eleves);
}
// Génération du fichier XML à partir des données rassemblées ci-dessus

$doc = new DOMDocument('1.0','iso-8859-15');

// La racine : <fichier>
$root = $doc->createElement('fichier');
$doc->appendChild($root);

// Fichier
$rootLogiciel = $doc->createAttribute('logiciel');
$rootVersion = $doc->createAttribute('version');
$rootDateCreation = $doc->createAttribute('date-creation');
$root->appendChild($rootLogiciel);
$root->appendChild($rootVersion);
$root->appendChild($rootDateCreation);

$rootLogicielValue = $doc->createTextNode('gepi');
$rootVersionValue = $doc->createTextNode($gepiVersion."p".$plugin_version);
$rootDateValue = $doc->createTextNode(strftime("%Y-%m-%d"));

$rootLogiciel->appendChild($rootLogicielValue);
$rootVersion->appendChild($rootVersionValue);
$rootDateCreation->appendChild($rootDateValue);

// Etablissement
$etab = $doc->createElement('etablissement');
$root->appendChild($etab);

$etabRne = $doc->createAttribute('rne');
$etabNom = $doc->createAttribute('nom');
$etabCp = $doc->createAttribute('cp');
$etab->appendChild($etabRne);
$etab->appendChild($etabNom);
$etab->appendChild($etabCp);
$etabRneValue = $doc->createTextNode(strtoupper($data_etablissement['rne']));
$etabNomValue = $doc->createTextNode($data_etablissement['nom']);
$etabCpValue = $doc->createTextNode($data_etablissement['cp']);
$etabRne->appendChild($etabRneValue);
$etabCp->appendChild($etabCpValue);
$etabNom->appendChild($etabNomValue);

// Classes
$classes = $doc->createElement('classes');
$etab->appendChild($classes);

for ($annee=$annee_scolaire;$annee>=$annee_scolaire-2;$annee--) {
  //echo $annee;
  foreach($data_classes[$annee] as $cl) {

    $current_classe = $doc->createElement('classe');
    $classes->appendChild($current_classe);

    $clCode = $doc->createAttribute('code');
    $clCodeValue = $doc->createTextNode(preg_replace('/ /','','C-'.encode($cl['annee']).encode($cl['code'])));
    $current_classe->appendChild($clCode);
    $clCode->appendChild($clCodeValue);

    $clAnnee = $doc->createAttribute('annee');
    $clAnneeValue = $doc->createTextNode($cl['annee']);
    $current_classe->appendChild($clAnnee);
    $clAnnee->appendChild($clAnneeValue);

    $clNom = $doc->createAttribute('nom');
    $clNomValue = $doc->createTextNode(encode($cl['nom']));
    $current_classe->appendChild($clNom);
    $clNom->appendChild($clNomValue);

    $clNiveau = $doc->createAttribute('niveau');
    $clNiveauValue = $doc->createTextNode(encode($cl['niveau']));
    $current_classe->appendChild($clNiveau);
    $clNiveau->appendChild($clNiveauValue);

    $clDecoupage = $doc->createAttribute('decoupage');
    $clDecoupageValue = $doc->createTextNode($cl['decoupage']);
    $current_classe->appendChild($clDecoupage);
    $clDecoupage->appendChild($clDecoupageValue);
  }
}
// Services notations

$services_notations = $doc->createElement('services-notations');
$etab->appendChild($services_notations);

foreach($data_services_notations as $code => $sn) {
  // Note : csn pour current_service_notation
  $csn = $doc->createElement('service-notation');
  $services_notations->appendChild($csn);
  
  // On passe les attributs
  $snCode = $doc->createAttribute('code');
  $snCodeValue = $doc->createTextNode('S-'.encode($code));
  $csn->appendChild($snCode);
  $snCode->appendChild($snCodeValue);
  
  $snAnnee = $doc->createAttribute('annee');
  $snAnneeValue = $doc->createTextNode(encode($sn['annee']));
  $csn->appendChild($snAnnee);
  $snAnnee->appendChild($snAnneeValue);
  
  $snTrimestre = $doc->createAttribute('trimestre');
  $snTrimestreValue = $doc->createTextNode(encode($sn['trimestre']));
  $csn->appendChild($snTrimestre);
  $snTrimestre->appendChild($snTrimestreValue);
  
  $snCodeEnseignant = $doc->createAttribute('code-enseignant');
  $snCodeEnseignantValue = $doc->createTextNode('P-'.encode(str_replace (".","_",$sn['code-enseignant'])));
  $csn->appendChild($snCodeEnseignant);
  $snCodeEnseignant->appendChild($snCodeEnseignantValue);
  
  $snCodeMatiere = $doc->createAttribute('code-matiere');
  if ($sn['code-matiere']=="MOYGEN") {
    $snCodeMatiereValue = $doc->createTextNode(encode($sn['code-matiere']));
  } else {
    $snCodeMatiereValue = $doc->createTextNode('M-'.encode($sn['code-matiere']));
  }
  $csn->appendChild($snCodeMatiere);
  $snCodeMatiere->appendChild($snCodeMatiereValue);
  
  // Moyenne classe : à déterminer !!!
  if (isset($sn['moyenne-classe']) AND $sn['moyenne-classe'] != '') {
    $moyenneBasse = $doc->createElement('moyenne-classe');
    $csn->appendChild($moyenneBasse);
    $moyenneBasseValue = $doc->createTextNode($sn['moyenne-classe']);
    $moyenneBasse->appendChild($moyenneBasseValue);
  }

//   Moyenne haute

  if (isset($sn['moyenne-haute']) AND $sn['moyenne-haute'] != '') {
    $moyenneHaute = $doc->createElement('moyenne-haute');
    $csn->appendChild($moyenneHaute);
    $moyenneHauteValue = $doc->createTextNode($sn['moyenne-haute']);
    $moyenneHaute->appendChild($moyenneHauteValue);
  }

  
//   Moyenne basse

  if (isset($sn['moyenne-basse']) AND $sn['moyenne-basse'] != '') {
    $moyenneBasse = $doc->createElement('moyenne-basse');
    $csn->appendChild($moyenneBasse);
    $moyenneBasseValue = $doc->createTextNode($sn['moyenne-basse']);
    $moyenneBasse->appendChild($moyenneBasseValue);
  }

  // Effectif
  if ($sn['effectif'] != '0') {
    $effectif = $doc->createElement('effectif');
    $csn->appendChild($effectif);
    $effectifValue = $doc->createTextNode($sn['effectif']);
    $effectif->appendChild($effectifValue);
  }
}

// Les matières

$matieres = $doc->createElement('matieres');
$etab->appendChild($matieres);

foreach($data_matieres as $matiere) {
  $mat = $doc->createElement('matiere');
  $matieres->appendChild($mat);
  
  // On passe les attributs
  $matCode = $doc->createAttribute('code');
  if ($matiere['code']=="MOYGEN") {
    $matCodeValue = $doc->createTextNode(encode($matiere['code']));
  } else {
    $matCodeValue = $doc->createTextNode('M-'.encode($matiere['code']));
  }
  $mat->appendChild($matCode);
  $matCode->appendChild($matCodeValue);

  $matCodeSconet = $doc->createAttribute('code-sconet');
  $matCodeSconetValue = $doc->createTextNode(encode($matiere['code-sconet']));
  $mat->appendChild($matCodeSconet);
  $matCodeSconet->appendChild($matCodeSconetValue);
  
  $matLibelle = $doc->createAttribute('libelle');
  $matLibelleValue = $doc->createTextNode(encode($matiere['libelle']));
  $mat->appendChild($matLibelle);
  $matLibelle->appendChild($matLibelleValue);

  $matLibelle = $doc->createAttribute('libelle-sconet');
  $matLibelleValue = $doc->createTextNode(encode($matiere['code']));
  $mat->appendChild($matLibelle);
  $matLibelle->appendChild($matLibelleValue);
}



// Les enseignants
$enseignants = $doc->createElement('enseignants');
$etab->appendChild($enseignants);

foreach($data_enseignants as $prof) {
  $e = $doc->createElement('enseignant');
  $enseignants->appendChild($e);
  
  // On passe les attributs
  $eCode = $doc->createAttribute('code');
  $eCodeValue = $doc->createTextNode('P-'.encode(str_replace (".","_",$prof['code'])));
  $e->appendChild($eCode);
  $eCode->appendChild($eCodeValue);

  $eNom = $doc->createAttribute('nom');
  $eNomValue = $doc->createTextNode(encode($prof['nom']));
  $e->appendChild($eNom);
  $eNom->appendChild($eNomValue);
  
  $ePrenom = $doc->createAttribute('prenom');
  $ePrenomValue = $doc->createTextNode(encode($prof['prenom']));
  $e->appendChild($ePrenom);
  $ePrenom->appendChild($ePrenomValue);
}


// Et enfin, les élèves

$eleves = $doc->createElement('eleves');
$etab->appendChild($eleves);

foreach($data_eleves as $el) {
  // verifions qu'il y a bien des données pour cet élève
  $el_empty=1;
  foreach($el['annees-scolaires'] as $an) {
	foreach($an['bulletins'] as $bulletin) {
		if (count($bulletin['notes'])>0) {
			$el_empty=0;
		}
	}
  }
  if ($el_empty==0) {
	  $e = $doc->createElement('eleve');
	  $eleves->appendChild($e);
	  
	  // On passe les attributs
	  $eCode = $doc->createAttribute('code');
	  $eCodeValue = $doc->createTextNode('E-'.encode($el['code']));
	  $e->appendChild($eCode);
	  $eCode->appendChild($eCodeValue);

	  $eINE = $doc->createAttribute('ine');
	  $eINEValue = $doc->createTextNode(encode($el['ine']));
	  $e->appendChild($eINE);
	  $eINE->appendChild($eINEValue);

	  $eNom = $doc->createAttribute('nom');
	  $eNomValue = $doc->createTextNode(encode($el['nom']));
	  $e->appendChild($eNom);
	  $eNom->appendChild($eNomValue);
	  
	  $ePrenom = $doc->createAttribute('prenom');
	  $ePrenomValue = $doc->createTextNode(encode($el['prenom']));
	  $e->appendChild($ePrenom);
	  $ePrenom->appendChild($ePrenomValue);
	  
	  $eNaissance = $doc->createAttribute('date-naissance');
	  $eNaissanceValue = $doc->createTextNode(encode($el['date-naissance']));
	  $e->appendChild($eNaissance);
	  $eNaissance->appendChild($eNaissanceValue);
	  
	  // On passe les années scolaires
	  $annees_scolaires = $doc->createElement('annees-scolaires');
	  $e->appendChild($annees_scolaires);
	  
	  foreach($el['annees-scolaires'] as $an) {
		// On commence par vérifier qu'il y a bien des infos dans le bulletin, sinon on zappe
		$bul_empty=1;
		foreach($an['bulletins'] as $bulletin) {
			if (count($bulletin['notes'])>0) {
				$bul_empty=0;
			}
		}
		if ($bul_empty==0) {
			$annee = $doc->createElement('annee-scolaire');
			$annees_scolaires->appendChild($annee);
			
			$anneeDescription = $doc->createAttribute('annee');
			$anneeDescriptionValue = $doc->createTextNode(encode($an['annee']));
			$annee->appendChild($anneeDescription);
			$anneeDescription->appendChild($anneeDescriptionValue);
			
			$anneeCodeClasse = $doc->createAttribute('code-classe');
			$anneeCodeClasseValue = $doc->createTextNode(preg_replace('/ /','','C-'.encode($an['annee']).encode($an['code-classe'])));
			$annee->appendChild($anneeCodeClasse);
			$anneeCodeClasse->appendChild($anneeCodeClasseValue);

			$anneeCodeMef = $doc->createAttribute('code-mef');
			$anneeCodeMefValue = $doc->createTextNode(preg_replace('/ /','',encode($an['code-mef']))); // prise en compte de l'annee
			$annee->appendChild($anneeCodeMef);
			$anneeCodeMef->appendChild($anneeCodeMefValue);

			$anneeCodeMef = $doc->createAttribute('libelle-mef');
			$anneeCodeMefValue = $doc->createTextNode(preg_replace('/ /','',encode($an['libelle-mef']))); // prise en compte de l'annee
			$annee->appendChild($anneeCodeMef);
			$anneeCodeMef->appendChild($anneeCodeMefValue);
			
			// Les bulletins pour l'année considérée
			$bulletins = $doc->createElement('bulletins');
			$annee->appendChild($bulletins);
			
			foreach($an['bulletins'] as $bulletin) {
			  if (count($bulletin['notes'])>0) {
				$b = $doc->createElement('bulletin');
				$bulletins->appendChild($b);

				$bTrimestre = $doc->createAttribute('trimestre');
				$bTrimestreValue = $doc->createTextNode(encode($bulletin['trimestre']));
				$b->appendChild($bTrimestre);
				$bTrimestre->appendChild($bTrimestreValue);

				// Les notes pour ce trimestre
				//echo $el['ine']." : ";print_r($bulletin['notes']);echo "<br/>";
				foreach($bulletin['notes'] as $note) {
				  $n = $doc->createElement('notes');
				  $b->appendChild($n);

				  $nServiceNotation = $doc->createAttribute('code-service-notation');
				  $nServiceNotationValue = $doc->createTextNode('S-'.encode($an['annee']).encode($note['code-service-notation']));
				  $n->appendChild($nServiceNotation);
				  $nServiceNotation->appendChild($nServiceNotationValue);

				  // Etat de la note
				  $nEtat = $doc->createAttribute('etat');
				  $nEtatValue = $doc->createTextNode(encode($note['etat']));
				  $n->appendChild($nEtat);
				  $nEtat->appendChild($nEtatValue);

				  $nModalite = $doc->createAttribute('modalite-election');
				  $nModaliteValue = $doc->createTextNode(encode($note['modalite']));
				  $n->appendChild($nModalite);
				  $nModalite->appendChild($nModaliteValue);

				  if ($note['etat'] == 'S') {
					if ($note['moyenne']!="") {
					  $nMoyenne = $doc->createElement('moyenne');
					  $nMoyenneValue = $doc->createTextNode(encode($note['moyenne']));
					  $n->appendChild($nMoyenne);
					  $nMoyenne->appendChild($nMoyenneValue);
					}
					if ($note['rang']!="") {
					  $nRang = $doc->createElement('rang');
					  $nRangValue = $doc->createTextNode(encode($note['rang']));
					  $n->appendChild($nRang);
					  $nRang->appendChild($nRangValue);
					}
				  }

		  //        if ($note['coefficient'] != '0.0') {
		  //          $nCoefficient = $doc->createElement('coefficient');
		  //          $nCoefficientValue = $doc->createTextNode(encode($note['coefficient']));
		  //          $n->appendChild($nCoefficient);
		  //          $nCoefficient->appendChild($nCoefficientValue);
		  //        }
				  $nAppreciation = $doc->createElement('appreciation');
				  $nAppreciationValue = $doc->createTextNode(encode($note['appreciation']));
				  $n->appendChild($nAppreciation);
				  $nAppreciation->appendChild($nAppreciationValue);

				}

			  }
			}
		  }
	}
}
}
$export_filename = strtoupper($data_etablissement['rne']).'_E'.$numero_export.'.xml';

header("Content-Type: text/xml");
header("Content-Disposition: attachment; filename=$export_filename"); 
//echo $doc->saveXML($doc->documentElement);
echo $doc->saveXML();

?>
