#!/bin/bash

GPO_NAME="$1"
EXPORT_TAR_GZ="$2"

if [ -z "$GPO_NAME" ]
then
    echo "Usage: $0 <gpo_name> [<export_gpos.tar.gz>]"
    exit 1
fi
echo "* Export GPO $GPO_NAME"
if [ -z "$EXPORT_TAR_GZ" ]
then
    EXPORT_TAR_GZ="/usr/share/eole/gpo/${GPO_NAME}.tar.gz"
fi    
if [ -f "$EXPORT_TAR_GZ" ]
then
    echo "Usage: $0 <gpo_name> <export_gpos.tar.gz>"
    echo "$EXPORT_TAR_GZ existe."
    exit 1
fi

# shellcheck disable=SC1091,SC1090
. /etc/eole/samba4-vars.conf

# shellcheck disable=SC1091,SC1090
. /usr/lib/eole/samba4.sh

if [ "${AD_SERVER_ROLE}" != "controleur de domaine" ]
then
    echo "Pas de GPO sur les serveurs membres"
    exit 0
fi

if [ "${AD_ADDITIONAL_DC}" != "non" ]
then
    echo "Cette commande ne doit pas être éxecutée sur les Dc Secondaires."
    exit 0
fi

GPO_ADMIN="gpo-${AD_HOST_NAME}"
GPO_ADMIN_DN="${GPO_ADMIN}@${AD_REALM^^}"
GPO_ADMIN_PWD_FILE=$(get_passwordfile_for_account "${GPO_ADMIN}")
if [ ! -f "${GPO_ADMIN_PWD_FILE}" ]
then
    echo "Warning:Le fichier ${GPO_ADMIN_PWD_FILE} est manquant"
    exit 1
fi
ADMIN_PWD="$(cat "${GPO_ADMIN_PWD_FILE}")"
CREDENTIAL="${GPO_ADMIN_DN}%${ADMIN_PWD}"

GPO_ID=$(gpo-tool importation show_by_name "$GPO_NAME" --attribut name -U"${CREDENTIAL}" )
if [ -z "$GPO_ID" ]
then
    echo "La GPO $GPO_NAME n'existe pas!"
    exit 1
fi

rm -rf "/var/tmp/$GPO_NAME"
mkdir -p "/var/tmp/$GPO_NAME"
samba-tool gpo backup "$GPO_ID" --tmpdir="/var/tmp/$GPO_NAME" -d 0
cd "/var/tmp/$GPO_NAME/policy/" || exit 1
mv "$GPO_ID/"* .
rm -rf "/var/tmp/$GPO_NAME/policy/$GPO_ID"
ldbsearch -H /var/lib/samba/private/sam.ldb -U"${CREDENTIAL}" CN="$GPO_ID" >"/var/tmp/$GPO_NAME/ldif"
cd "/home/sysvol/${AD_REALM}/Policies/$GPO_ID" || exit 1
getfattr -Rd . >"/var/tmp/$GPO_NAME/attrs"
getfacl -R . >"/var/tmp/$GPO_NAME/acls"
find . |while read -r F ; do file "$F"; done >"/var/tmp/$GPO_NAME/encodings"
find . |while read -r F ; do SDDL=$(samba-tool ntacl get  "$F" --as-sddl); echo "$SDDL $F"; done >"/var/tmp/$GPO_NAME/sddl"

echo "${AD_DOMAIN}" >"/var/tmp/$GPO_NAME/domain"
gpo-tool importation show_by_name "$GPO_NAME" --attribut name -U"${CREDENTIAL}" >"/var/tmp/$GPO_NAME/version"
samba-tool ntacl get "/home/sysvol/${AD_REALM}/Policies/$GPO_ID/" --as-sddl >"/var/tmp/$GPO_NAME/sddl.FS_GPO"
samba-tool dsacl get --objectdn="CN=$GPO_ID,CN=Policies,CN=System,${BASEDN}"  -U"${CREDENTIAL}" | tail -1 >"/var/tmp/$GPO_NAME/sddl.DS_GPO"
samba-tool ntacl get "/home/sysvol/${AD_REALM}/Policies/$GPO_ID/User" --as-sddl >"/var/tmp/$GPO_NAME/sddl.FS_GPO_User"
samba-tool dsacl get --objectdn="CN=USer,CN=$GPO_ID,CN=Policies,CN=System,${BASEDN}"  -U"${CREDENTIAL}" | tail -1 >"/var/tmp/$GPO_NAME/sddl.FS_GPO_User"
samba-tool ntacl get "/home/sysvol/${AD_REALM}/Policies/$GPO_ID/Machine" --as-sddl >"/var/tmp/$GPO_NAME/sddl.FS_GPO_Machine"
samba-tool dsacl get --objectdn="CN=Machine,CN=$GPO_ID,CN=Policies,CN=System,${BASEDN}" -U"${CREDENTIAL}" | tail -1 >"/var/tmp/$GPO_NAME/sddl.DS_GPO_Machine"

cd "/var/tmp/$GPO_NAME/" || exit 1
tar --xattrs --acls -cvf "$EXPORT_TAR_GZ" .
ls -l "$EXPORT_TAR_GZ"

echo "* Export GPO $GPO_NAME from export $EXPORT_TAR_GZ"