<?php
/*---------------------------------------------------------------
		f_session_scribe.inc.php
-----------------------------------------------------------------
	Librairie de fonctions pour pour gérer la session des services
   sur les serveurs Eole Scribe
-----------------------------------------------------------------
	auteur : Olivier HACQUARD - Académie de Besançon   
---------------------------------------------------------------*/


//fonction bidon... en attendant la vraie...
function getCasUid() {
	//authentification et récupération des informations de l'utilisateur
	$attributs = envole_cas_auth();
	//print_r($attributs);exit();
	//test sur un attribut particulier pour vérifier la bonne application du filtre par le serveur CAS
	if(!isset($attributs['utilisateur']['user'])) include("../envole/echecCAS.php");
	
	$_SESSION['_user_']=recupInfosUserLDAP($login); //recup des infos de l'utilisateur dans le ldap
	$_SESSION['_user_']['login']=$attributs['utilisateur']['user'][0];
	return ($attributs['utilisateur']['user'][0]);
	
}

//*------------------______________________----------------------

/*--- Fonction ----------------------------------------------------------
  initSession
 ----------------------
  initialise la session pour le service et récupére l'utilisateur connecté
 ----------------------
  Entrée :
 	
  Sortie :
    session ouverte et uid de l'utilisateur mis en session pour le service concerné
-------------------------------*/
function initSession() {
	
	global $uid;

	require_once('./CAS/cas_envole.inc.php');
	
	//nom de session compatible envole
	session_name("myhomepage");
	//ouverture de la session
	@session_start();
	
	//demande de déconnexion de la session CAS
	if (isset($_GET['logout'])) envole_cas_logout($_SERVER['SCRIPT_NAME']);
	
	//recup du nom de l'utilisateur connecté via le CAS
	if(!empty($_SESSION['phpCAS']['user']) && ($_SESSION['phpCAS']['user']!="")) 
		$uid = $_SESSION['phpCAS']['user']; 
	else 
	//sinon appel à l'authentification du cas		    
		$uid = getCasUid();
}


/*--- Fonction ----------------------------------------------------------
  recupUid
 ----------------------
  lance la session pour le service et récupére l'utilisateur connecté
 ----------------------
  Entrée :
 	
  Sortie :
    session ouverte et uid de l'utilisateur retourné dans la variable $uid
-------------------------------*/
function recupUid() {
	global $uid;

	//nom de session compatible envole
	session_name("myhomepage");
	//ouverture de la session
	@session_start();
	if(!empty($_SESSION['phpCAS']['user'])) 
		$uid = $_SESSION['phpCAS']['user']; 
	else { //si on ne récupère pas l'uid
		//on retourne à la page index...
		header("Location: ./index.php"); 
	
		//arrêt du script... normalement, on ne passe pas par là...	
		exit(); 
	}
}

/*------------------------------------------
 Fonction : 
-------------------------------------
 -
-------------------------------------
 - Entrée :
 - Sortie : 
---------------------------------------------*/

function verifAccesPage() {
	$tabAutorises=func_get_args();
	
	//global $uid;
	$pasAutorise=true;
	if (is_array($tabAutorises)) foreach($tabAutorises as $autorise) {
		//si on trouve un des noms autorisés dans le groupe ou le login de l'utilisateur en cours, on l'autorise
		$tCompare=array(strtolower($_SESSION['_user_']['groupep']),strtolower($_SESSION['_user_']['login']),$_SESSION['phpCAS']['user']);
		if (in_array(strtolower($autorise),$tCompare)) $pasAutorise=false;
	}
	//si pas autorisé... on sort
	if ($pasAutorise) {
		//header("Location: ./inc/pasAutorise.html"); 
		include ("./inc/pasAutorise.html");
		exit(); //c'est fini...!
	}
}

?>
