<?php
/*---------------------------------------------------------------
		quota.php
-----------------------------------------------------------------
	Affichage du contenu d'un fichier
-----------------------------------------------------------------
	auteur : Olivier HACQUARD - Académie de Besançon   
---------------------------------------------------------------*/
include ('./inc/f_session_scribe.inc.php');
/*
//initialisation de la Session et recup de l'uid
recupUid();

verifAccesPage("admin","raip");

include ('./inc/f_scribe.inc.php');
include ('./inc/f_ldap_scribe.inc.php');
*/
include ('./inc/f_ldap_scribe.inc.php');

//initialisation de la Session et recup de l'uid
recupUid();

include ('./inc/f_scribe.inc.php');
//verifie si l'utilisateur connecté est du login ou du groupe mis dans la liste (ELEVES, PROFS, etc...)
//verifAccesPage("admin");
verifAccesPage($comptesAutorises);


$titrePage="Affichage du contenu du fichier";

//------------------- Controler ----------------------
$leFic=$logQuota=false;

if (isset($_GET['type'])) {
	//si fichier type logQuota
	if ($_GET['type']=="logQuota") $logQuota=true; 
	if ($logQuota && isset($_GET['login']) && $_GET['login']!="") $leFic=$cheminLogs.'/'.$_GET['login'].'.log';
	else $logQuota=false;
}

//if (!$logQuota) {if (isset($_GET['fic'])) if (file_exists($_GET['fic'])) $leFic=$_GET['fic'];}

if (!$logQuota) $titreDeLaPage="Erreur de traitement..."; 
else $titreDeLaPage="Fichiers de l'utilisateur <span style=\"color:red;font-size:1.5em\">".$_GET['login']."</span> situés en dehors de son espace personnel";


//---------------------------------- Module ---------------------------------------------------
/*------------------------------------------
 Fonction : 
-------------------------------------
 - calcule la taille du fichier d'après une chaine du type  5,54k ou 5M ou 775
-------------------------------------
 - Entrée :
 - Sortie : 
---------------------------------------------*/
function calcTaille($chaine) {
	//return ($taille=floatval(str_replace(',','.',$chaine)));
	$chaine=trim(strtoupper(str_replace(',','.',$chaine)));
	$mul=1;
	if (strpos($chaine,'K')!==false) $mul=1000;
	else if (strpos($chaine,'M')!==false) $mul=1000000;
	else if (strpos($chaine,'G')!==false) $mul=1000000000;
	$taille=floatval($chaine)*$mul;
	return $taille;
}

$page=$prePage="";
//on limite seulement le traitement au fichier de log
if ($logQuota) {
	if ($leFic!="") {
		$nbLig=0;
		$fd=fopen($leFic, 'r');
		while (($buffer = fgets($fd)) !== false) {
			if ($nbLig<4 && $logQuota) $buffer=utf8_decode($buffer); //alors on décode les 3 premières lignes
			if ($logQuota) {
				list($_fic,$_taille)=explode(" -> ",$buffer);
				$_laTaille=calcTaille($_taille);
				$tFic[]=array('fic'=>$_fic,'taille'=>$_laTaille);
				$cumul+=$_laTaille;
			}
			$page.= $buffer.BRCR;
			$nbLig++;
		}
		if ($logQuota) $prePage.='Taille totale de fichiers hors espace personnel : <b>'.number_format($cumul/(1024*1024),1,',',' ').'M</b>';
		fclose($fd);
	} else {
		$page.="Impossible d'ouvrir le fichier <b>$leFic</b>";
	}
}
//------------------- View -------------------------
headerPage();
enteteHTML($titrePage,array("./scribe.css"));
?>


	<h3 style="text-align:center"><?php echo $titreDeLaPage; ?></h3>
<p><i>Attention, cette liste de fichiers n'est actualisée qu'une fois par semaine.<br/>Les fichiers supprimés du quota ne seront donc absents de cette liste que la semaine prochaine...</i></p><hr/>
<?php
echo $prePage.BR.BRCR;
?>	
<div id="contFichier">
<?php
echo $page;
?>
</div>
<?php
finHTML();

?>